/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;

public class JsonEntityBean
implements Serializable {
    public static final String ENTITY_CATEGORY = "category";
    public static final String ENTITY_CHANNEL = "channel";
    public static final String ENTITY_GROUP = "group";
    public static final String ENTITY_PERSON = "person";
    private String entityType;
    private String id;
    private String name;
    private String creatorId;
    private String description;
    private List children = new ArrayList();
    private boolean childrenInitialized = false;

    public JsonEntityBean() {
    }

    public JsonEntityBean(ChannelCategory category) {
        this.entityType = ENTITY_CATEGORY;
        this.id = category.getId();
        this.name = category.getName();
        this.creatorId = category.getCreatorId();
        this.description = category.getDescription();
    }

    public JsonEntityBean(IGroupMember groupMember, String entityType) {
        this.entityType = entityType;
        this.id = groupMember.getKey();
    }

    public JsonEntityBean(IEntityGroup entityGroup, String entityType) {
        this.entityType = entityType;
        this.id = entityGroup.getKey();
        this.name = entityGroup.getName();
        this.creatorId = entityGroup.getCreatorID();
        this.description = entityGroup.getDescription();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public void addChild(Object child) {
        this.children.add(child);
    }

    public boolean isChildrenInitialized() {
        return this.childrenInitialized;
    }

    public void setChildrenInitialized(boolean childrenInitialized) {
        this.childrenInitialized = childrenInitialized;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childrenInitialized ? 1231 : 1237);
        result = 31 * result + (this.creatorId == null ? 0 : this.creatorId.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonEntityBean other = (JsonEntityBean)obj;
        if (this.childrenInitialized != other.childrenInitialized) {
            return false;
        }
        if (this.creatorId == null ? other.creatorId != null : !this.creatorId.equals(other.creatorId)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

