/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.layout.dlm.remoting.registry.ChannelBean;
import org.jasig.portal.layout.dlm.remoting.registry.ChannelCategoryBean;
import org.jasig.portal.layout.dlm.remoting.registry.ChannelRegistryBean;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ChannelListController
extends AbstractController {
    private IChannelRegistryStore channelRegistryStore;
    private IPersonManager personManager;
    private static final String TYPE_SUBSCRIBE = "subscribe";
    private static final String TYPE_MANAGE = "manage";

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String type = request.getParameter("type");
        if (type == null || !type.equals(TYPE_MANAGE)) {
            type = TYPE_SUBSCRIBE;
        }
        IPerson user = this.personManager.getPerson(request);
        ChannelRegistryBean registry = this.getRegistry(user, type);
        if ("true".equals(request.getParameter("xml"))) {
            XStream stream = new XStream();
            stream.processAnnotations(ChannelRegistryBean.class);
            String xml = stream.toXML((Object)registry);
            return new ModelAndView("xmlView", "xml", (Object)xml);
        }
        return new ModelAndView("jsonView", "registry", (Object)registry);
    }

    private ChannelRegistryBean getRegistry(IPerson user, String type) {
        List<IChannelDefinition> allChannels = this.channelRegistryStore.getChannelDefinitions();
        ChannelRegistryBean registry = new ChannelRegistryBean();
        ChannelCategory rootCategory = this.channelRegistryStore.getTopLevelChannelCategory();
        registry.addCategory(this.addChildren(rootCategory, allChannels, user, type));
        if (type.equals(TYPE_MANAGE)) {
            EntityIdentifier ei = user.getEntityIdentifier();
            IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
            for (IChannelDefinition channel : allChannels) {
                if (!ap.canManage(channel.getId())) continue;
                registry.addChannel(new ChannelBean(channel));
            }
        }
        return registry;
    }

    private ChannelCategoryBean addChildren(ChannelCategory category, List<IChannelDefinition> allChannels, IPerson user, String type) {
        ChannelCategoryBean categoryBean = new ChannelCategoryBean(category);
        IChannelDefinition[] channels = type.equals(TYPE_MANAGE) ? this.channelRegistryStore.getManageableChildChannels(category, user) : this.channelRegistryStore.getChildChannels(category, user);
        for (IChannelDefinition channelDef : channels) {
            ChannelBean channel = new ChannelBean(channelDef);
            categoryBean.addChannel(channel);
            allChannels.remove(channel);
        }
        for (ChannelCategory childCategory : this.channelRegistryStore.getChildCategories(category)) {
            ChannelCategoryBean childCategoryBean = this.addChildren(childCategory, allChannels, user, type);
            categoryBean.addCategory(childCategoryBean);
        }
        return categoryBean;
    }

    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        this.channelRegistryStore = channelRegistryStore;
    }

    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }
}

