/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.processing;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.layout.dlm.DistributedLayoutManager;
import org.jasig.portal.layout.dlm.processing.IOptionalParameterProcessor;
import org.jasig.portal.layout.dlm.processing.IParameterProcessor;
import org.jasig.portal.layout.dlm.processing.ISaxProcessor;
import org.jasig.portal.security.IPerson;
import org.xml.sax.ContentHandler;

public class ProcessingPipe
implements IParameterProcessor {
    private static final Log LOG = LogFactory.getLog(ProcessingPipe.class);
    private List fixedProcessors = null;
    private Map optionalProcessors = null;
    private Object optionalProcessor = null;
    private String optionalProcessorKey;
    private boolean hasFixedSaxProcessor = false;
    public static final String CHANGE_PROCESSOR_PARAM = "uP_dlmPrc";
    public static final String PROCESSING_PIPE_BEAN_ID = "dlmProcessingPipe";

    public ProcessingPipe() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Constructing new instance.");
        }
    }

    public void setFixedProcessors(List fixedProcessors) {
        if (fixedProcessors != null && fixedProcessors.size() > 0) {
            this.fixedProcessors = fixedProcessors;
            for (Object proc : fixedProcessors) {
                if (!(proc instanceof ISaxProcessor)) continue;
                this.hasFixedSaxProcessor = true;
                break;
            }
        }
    }

    private void setOptionalProcessor(Object optionalProcessor) {
        this.optionalProcessor = optionalProcessor;
        if (LOG.isDebugEnabled()) {
            if (optionalProcessor == null) {
                LOG.debug((Object)"Setting Optional processor to null.");
            } else {
                LOG.debug((Object)("Setting Optional processor to: " + optionalProcessor.getClass().getName()));
            }
        }
    }

    public void setOptionalProcessors(Map optionalProcessors) {
        this.optionalProcessor = null;
        this.optionalProcessors = optionalProcessors;
    }

    @Override
    public void setResources(IPerson person, DistributedLayoutManager dlm) {
        if (this.fixedProcessors != null) {
            this.initProcessorResources(this.fixedProcessors.iterator(), person, dlm);
        }
        if (this.optionalProcessors != null) {
            this.initProcessorResources(this.optionalProcessors.values().iterator(), person, dlm);
        }
    }

    private void initProcessorResources(Iterator itr, IPerson person, DistributedLayoutManager dlm) {
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof IParameterProcessor)) continue;
            IParameterProcessor pp = (IParameterProcessor)obj;
            pp.setResources(person, dlm);
        }
    }

    @Override
    public void processParameters(UserPreferences prefs, HttpServletRequest request) {
        this.handleOptionalProcessorSelection(request);
        this.pushRequestToProcessors(prefs, request);
    }

    private void pushRequestToProcessors(UserPreferences prefs, HttpServletRequest request) {
        if (this.fixedProcessors != null) {
            for (Object obj : this.fixedProcessors) {
                if (!(obj instanceof IParameterProcessor)) continue;
                IParameterProcessor pp = (IParameterProcessor)obj;
                pp.processParameters(prefs, request);
            }
        }
        if (this.optionalProcessor != null && this.optionalProcessor instanceof IParameterProcessor) {
            ((IParameterProcessor)this.optionalProcessor).processParameters(prefs, request);
            if (this.optionalProcessor instanceof IOptionalParameterProcessor && ((IOptionalParameterProcessor)this.optionalProcessor).isFinished()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("isFinished() = true: " + this.optionalProcessor.getClass().getName()));
                }
                this.setOptionalProcessor(null);
            }
        }
    }

    private void handleOptionalProcessorSelection(HttpServletRequest request) {
        String key = request.getParameter(CHANGE_PROCESSOR_PARAM);
        if (key != null) {
            if (key.equals("")) {
                this.setOptionalProcessor(null);
            } else if (this.optionalProcessors == null || this.optionalProcessors.isEmpty()) {
                LOG.error((Object)("Optional Processor for uP_dlmPrc=" + key + "requested but there are no " + "optional processors registered."));
            } else {
                Object proc = this.optionalProcessors.get(key);
                if (proc == null) {
                    LOG.error((Object)("Optional Processor for uP_dlmPrc=" + key + " not found in registered optional processors."));
                } else {
                    this.setOptionalProcessor(proc);
                }
            }
        }
    }

    public String getCacheKey() {
        if (this.fixedProcessors == null && this.optionalProcessors == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.hasFixedSaxProcessor) {
            ISaxProcessor sProc = null;
            for (Object obj : this.fixedProcessors) {
                if (!(obj instanceof ISaxProcessor)) continue;
                if (sProc == null) {
                    buf.append("FX[");
                } else {
                    buf.append(':');
                }
                sProc = (ISaxProcessor)obj;
                buf.append(sProc.getCacheKey());
            }
            if (sProc != null) {
                buf.append("]");
            }
        }
        if (this.optionalProcessor != null && this.optionalProcessor instanceof ISaxProcessor) {
            buf.append("OP[");
            buf.append(this.optionalProcessorKey);
            buf.append(':');
            buf.append(((ISaxProcessor)this.optionalProcessor).getCacheKey());
            buf.append(']');
        }
        return buf.toString();
    }

    public ContentHandler getContentHandler(ContentHandler handler) {
        ISaxProcessor saxProc = null;
        if (this.optionalProcessor != null && this.optionalProcessor instanceof ISaxProcessor) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Injecting exit handler into " + this.optionalProcessor.getClass().getName()));
            }
            saxProc = (ISaxProcessor)this.optionalProcessor;
            handler = saxProc.getContentHandler(handler);
        }
        if (this.fixedProcessors != null && this.fixedProcessors.size() > 0) {
            for (int i = this.fixedProcessors.size() - 1; i >= 0; --i) {
                Object next = this.fixedProcessors.get(i);
                if (!(next instanceof ISaxProcessor)) continue;
                saxProc = (ISaxProcessor)next;
                handler = saxProc.getContentHandler(handler);
            }
        }
        return handler;
    }
}

