/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.processing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.layout.dlm.processing.ISaxProcessor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class ExampleBookmarksRemover
extends XMLFilterImpl
implements ISaxProcessor {
    private static final Log LOG = LogFactory.getLog(ExampleBookmarksRemover.class);
    private boolean stripIt = false;

    @Override
    public String getCacheKey() {
        return "BMR:" + this.stripIt;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.stripIt) {
            super.characters(ch, start, length);
            LOG.error((Object)("\n\n\n***BMR: stripping Bookmarks chars by " + this.hashCode()));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.stripIt) {
            super.endElement(uri, localName, qName);
        }
        if (this.stripIt && qName.equals("channel")) {
            this.stripIt = false;
            LOG.error((Object)("\n\n\n***BMR: done stripping Bookmarks by " + this.hashCode()));
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String name;
        if (qName.equals("channel") && (name = atts.getValue("name")) != null && name.equals("Bookmarks")) {
            this.stripIt = true;
            LOG.error((Object)("\n\n\n***BMR: stripping Bookmarks by " + this.hashCode()));
        }
        if (!this.stripIt) {
            super.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public ContentHandler getContentHandler(ContentHandler handler) {
        super.setContentHandler(handler);
        return this;
    }
}

