/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.dlm.IntegrationResult;
import org.jasig.portal.layout.dlm.NodeInfo;
import org.jasig.portal.layout.dlm.Precedence;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PositionManager {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(PositionManager.class);
    private static RDBMDistributedLayoutStore dls = null;

    private static RDBMDistributedLayoutStore getDLS() {
        if (dls == null) {
            IUserLayoutStore uls = null;
            uls = UserLayoutStoreFactory.getUserLayoutStoreImpl();
            dls = (RDBMDistributedLayoutStore)uls;
        }
        return dls;
    }

    static void applyPositions(Element compViewParent, Element positionSet, IntegrationResult result) throws PortalException {
        if (positionSet == null || positionSet.getFirstChild() == null) {
            return;
        }
        ArrayList order = new ArrayList();
        PositionManager.applyOrdering(order, compViewParent, positionSet);
        PositionManager.applyNoReparenting(order, compViewParent, positionSet);
        PositionManager.applyNoHopping(order, compViewParent, positionSet);
        PositionManager.applyLowerPrecedence(order, compViewParent, positionSet);
        PositionManager.evaluateAndApply(order, compViewParent, positionSet, result);
    }

    static void evaluateAndApply(ArrayList order, Element compViewParent, Element positionSet, IntegrationResult result) throws PortalException {
        PositionManager.adjustPositionSet(order, positionSet, result);
        if (PositionManager.hasAffectOnCVP(order, compViewParent)) {
            PositionManager.applyToNodes(order, compViewParent);
            result.changedILF = true;
        }
    }

    static void adjustPositionSet(ArrayList order, Element positionSet, IntegrationResult result) {
        Node nodeToMatch = positionSet.getFirstChild();
        Element nodeToInsertBefore = positionSet.getOwnerDocument().createElement("INSERT_POINT");
        positionSet.insertBefore(nodeToInsertBefore, nodeToMatch);
        for (NodeInfo ni : order) {
            if (ni.positionDirective == null) continue;
            if (ni.positionDirective != nodeToMatch) {
                result.changedPLF = true;
            }
            if (nodeToMatch != null) {
                nodeToMatch = nodeToMatch.getNextSibling();
            }
            positionSet.insertBefore(ni.positionDirective, nodeToInsertBefore);
        }
        while (nodeToInsertBefore.getNextSibling() != null) {
            positionSet.removeChild(nodeToInsertBefore.getNextSibling());
        }
        positionSet.removeChild(nodeToInsertBefore);
    }

    static boolean hasAffectOnCVP(ArrayList order, Element compViewParent) {
        Element child;
        if (order.size() == 0) {
            return false;
        }
        int idx = 0;
        NodeInfo ni = (NodeInfo)order.get(idx);
        if (child == null && ni != null) {
            return true;
        }
        for (child = (Element)compViewParent.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            if (!child.getAttribute("hidden").equals("false") || child.getAttribute("chanID").equals("") && !child.getAttribute("type").equals("regular")) continue;
            if (ni.id.equals(child.getAttribute("ID"))) {
                if (idx >= order.size() - 1) {
                    return false;
                }
                ni = (NodeInfo)order.get(++idx);
                continue;
            }
            return true;
        }
        return idx < order.size();
    }

    static void applyToNodes(ArrayList order, Element compViewParent) {
        Element insertPoint = compViewParent.getOwnerDocument().createElement("bogus");
        Node first = compViewParent.getFirstChild();
        if (first != null) {
            compViewParent.insertBefore(insertPoint, first);
        } else {
            compViewParent.appendChild(insertPoint);
        }
        for (int i = 0; i < order.size(); ++i) {
            compViewParent.insertBefore(((NodeInfo)order.get((int)i)).node, insertPoint);
        }
        compViewParent.removeChild(insertPoint);
    }

    static void applyLowerPrecedence(ArrayList order, Element compViewParent, Element positionSet) {
        for (int i = 0; i < order.size(); ++i) {
            NodeInfo ni = (NodeInfo)order.get(i);
            if (!ni.node.getAttribute("dlm:moveAllowed").equals("false")) continue;
            for (int j = 0; j < i; ++j) {
                NodeInfo lefty = (NodeInfo)order.get(j);
                if (lefty.precedence != null && !lefty.precedence.isLessThan(ni.precedence)) continue;
                order.remove(j);
                order.add(i, lefty);
            }
        }
    }

    static void applyNoHopping(ArrayList order, Element compViewParent, Element positionSet) {
        if (PositionManager.isIllegalHoppingSpecified(order)) {
            ArrayList cvpNodeInfos = new ArrayList();
            for (int i = order.size() - 1; i >= 0; --i) {
                if (((NodeInfo)order.get((int)i)).indexInCVP == -1) continue;
                cvpNodeInfos.add(order.remove(i));
            }
            Object[] nodeInfos = cvpNodeInfos.toArray();
            Arrays.sort(nodeInfos, new NodeInfoComparator());
            List<Object> list = Arrays.asList(nodeInfos);
            order.addAll(0, list);
        }
    }

    static boolean isIllegalHoppingSpecified(ArrayList order) {
        for (int i = 0; i < order.size(); ++i) {
            NodeInfo niSib;
            int j;
            NodeInfo ni = (NodeInfo)order.get(i);
            if (!ni.node.getAttribute("dlm:moveAllowed").equals("false")) continue;
            for (j = 0; j < i; ++j) {
                niSib = (NodeInfo)order.get(j);
                if (niSib.precedence == Precedence.getUserPrecedence() || !niSib.precedence.isEqualTo(ni.precedence) || niSib.indexInCVP != -1 && ni.indexInCVP >= niSib.indexInCVP) continue;
                return true;
            }
            for (j = i + 1; j < order.size(); ++j) {
                niSib = (NodeInfo)order.get(j);
                if (niSib.indexInCVP == -1 || niSib.precedence == Precedence.getUserPrecedence() || ni.indexInCVP <= niSib.indexInCVP || !niSib.precedence.isEqualTo(ni.precedence)) continue;
                return true;
            }
        }
        return false;
    }

    static void applyNoReparenting(ArrayList order, Element compViewParent, Element positionSet) {
        int i = 0;
        while (i < order.size()) {
            NodeInfo ni = (NodeInfo)order.get(i);
            if (!ni.node.getParentNode().equals(compViewParent)) {
                ni.differentParent = true;
                if (PositionManager.isNotReparentable(ni)) {
                    ni.positionDirective = null;
                    order.remove(i);
                    continue;
                }
            }
            ++i;
        }
    }

    private static boolean isNotReparentable(NodeInfo ni) {
        if (ni.node.getAttribute("dlm:moveAllowed").equals("false")) {
            return true;
        }
        Precedence nodePrec = ni.precedence;
        for (Element node = (Element)ni.node.getNextSibling(); node != null; node = (Element)node.getNextSibling()) {
            Precedence p;
            if (!node.getAttribute("dlm:moveAllowed").equals("false") || !nodePrec.isEqualTo(p = Precedence.newInstance(node.getAttribute("dlm:fragment")))) continue;
            return true;
        }
        return false;
    }

    static void applyOrdering(ArrayList order, Element compViewParent, Element positionSet) {
        ArrayList<NodeInfo> available = new ArrayList<NodeInfo>();
        Element child = (Element)compViewParent.getFirstChild();
        Element next = null;
        int indexInCVP = 0;
        while (child != null) {
            next = (Element)child.getNextSibling();
            if (child.getAttribute("hidden").equals("false") && (!child.getAttribute("chanID").equals("") || child.getAttribute("type").equals("regular"))) {
                available.add(new NodeInfo(child, indexInCVP++));
            }
            child = next;
        }
        Document CV = compViewParent.getOwnerDocument();
        Element directive = (Element)positionSet.getFirstChild();
        while (directive != null) {
            next = (Element)directive.getNextSibling();
            String id = directive.getAttribute("name");
            child = CV.getElementById(id);
            if (child != null) {
                int idx = 0;
                boolean found = false;
                while (!found && idx < available.size()) {
                    if (((NodeInfo)available.get((int)idx)).node == child) {
                        found = true;
                        continue;
                    }
                    ++idx;
                }
                NodeInfo ni = found ? (NodeInfo)available.remove(idx) : new NodeInfo(child);
                ni.positionDirective = directive;
                order.add(ni);
            }
            directive = next;
        }
        for (int i = 0; i < available.size(); ++i) {
            order.add(available.get(i));
        }
    }

    public static void updatePositionSet(Element compViewParent, Element plfParent, IPerson person) throws PortalException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Updating Position Set");
        }
        if (compViewParent.getChildNodes().getLength() == 0) {
            Element positions;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No Nodes to position");
            }
            if ((positions = PositionManager.getPositionSet(plfParent, person, false)) != null) {
                plfParent.removeChild(positions);
            }
            return;
        }
        Element posSet = PositionManager.getPositionSet(plfParent, person, true);
        Element position = (Element)posSet.getFirstChild();
        boolean ilfNodesFound = false;
        for (Element viewNode = (Element)compViewParent.getFirstChild(); viewNode != null; viewNode = (Element)viewNode.getNextSibling()) {
            String ID = viewNode.getAttribute("ID");
            String channelId = viewNode.getAttribute("chanID");
            String type = viewNode.getAttribute("type");
            String hidden = viewNode.getAttribute("hidden");
            if (ID.startsWith("u")) {
                ilfNodesFound = true;
            }
            if (channelId.equals("") && (!type.equals("regular") || !hidden.equals("false"))) continue;
            if (position != null) {
                position.setAttribute("name", ID);
            } else {
                position = PositionManager.createAndAppendPosition(ID, posSet, person);
            }
            position = (Element)position.getNextSibling();
        }
        if (!ilfNodesFound) {
            plfParent.removeChild(posSet);
        } else {
            while (position != null) {
                Element nextPos = (Element)position.getNextSibling();
                posSet.removeChild(position);
                position = nextPos;
            }
        }
    }

    private static Element getPositionSet(Element plfParent, IPerson person, boolean create) throws PortalException {
        for (Node child = plfParent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("dlm:positionSet")) continue;
            return (Element)child;
        }
        if (!create) {
            return null;
        }
        String ID = null;
        try {
            ID = PositionManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new position set node Id for userId=" + person.getID(), (Throwable)e);
        }
        Document plf = plfParent.getOwnerDocument();
        Element positions = plf.createElement("dlm:positionSet");
        positions.setAttribute("type", "dlm:positionSet");
        positions.setAttribute("ID", ID);
        plfParent.appendChild(positions);
        return positions;
    }

    private static Element createAndAppendPosition(String elementID, Element positions, IPerson person) throws PortalException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding Position Set entry " + elementID + "."));
        }
        String ID = null;
        try {
            ID = PositionManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new position node Id for userId=" + person.getID(), (Throwable)e);
        }
        Document plf = positions.getOwnerDocument();
        Element position = plf.createElement("dlm:position");
        position.setAttribute("type", "dlm:position");
        position.setAttribute("ID", ID);
        position.setAttributeNS("http://www.uportal.org/layout/dlm", "name", elementID);
        positions.appendChild(position);
        return position;
    }

    static class NodeInfoComparator
    implements Comparator {
        NodeInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((NodeInfo)o1).indexInCVP - ((NodeInfo)o2).indexInCVP;
        }
    }
}

