/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserIdentityStoreFactory;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.layout.IFolderLocalNameResolver;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.LayoutEvent;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.LayoutMoveEvent;
import org.jasig.portal.layout.dlm.ChannelDescription;
import org.jasig.portal.layout.dlm.FragmentChannelInfo;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.FragmentNodeInfo;
import org.jasig.portal.layout.dlm.HandlerUtils;
import org.jasig.portal.layout.dlm.IFolderLabelPolicy;
import org.jasig.portal.layout.dlm.ILayoutCachingService;
import org.jasig.portal.layout.dlm.ILayoutProcessingAction;
import org.jasig.portal.layout.dlm.LPAAddParameter;
import org.jasig.portal.layout.dlm.LPAChangeAttribute;
import org.jasig.portal.layout.dlm.LPAChangeParameter;
import org.jasig.portal.layout.dlm.LPAEditRestriction;
import org.jasig.portal.layout.dlm.LPARemoveParameter;
import org.jasig.portal.layout.dlm.LPAResetAttribute;
import org.jasig.portal.layout.dlm.LPAResetParameter;
import org.jasig.portal.layout.dlm.MovementRules;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.layout.dlm.RootLocator;
import org.jasig.portal.layout.dlm.TabColumnPrefsHandler;
import org.jasig.portal.layout.dlm.processing.ProcessingPipe;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutFolderDescription;
import org.jasig.portal.layout.simple.SimpleLayout;
import org.jasig.portal.security.AdminEvaluator;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.provider.AuthorizationImpl;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XML;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class DistributedLayoutManager
implements IUserLayoutManager,
IFolderLocalNameResolver {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(DistributedLayoutManager.class);
    protected final IPerson owner;
    protected final UserProfile profile;
    protected final ILayoutCachingService layoutCachingService;
    protected RDBMDistributedLayoutStore store = null;
    protected Set<LayoutEventListener> listeners = new HashSet<LayoutEventListener>();
    static final String FOLDER_LABEL_POLICY = "FolderLabelPolicy";
    protected static Random rnd = new Random();
    protected String cacheKey = "initialKey";
    protected String rootNodeId = null;
    private boolean channelsAdded = false;
    private boolean isFragmentOwner = false;
    private ProcessingPipe processingPipe = null;
    private int domRequests = 0;

    public DistributedLayoutManager(IPerson owner, UserProfile profile, IUserLayoutStore store) throws PortalException {
        if (owner == null) {
            throw new PortalException("Unable to instantiate DistributedLayoutManager. A non-null owner must to be specified.");
        }
        if (profile == null) {
            throw new PortalException("Unable to instantiate DistributedLayoutManager for " + owner.getAttribute("username") + ". A " + "non-null profile must to be specified.");
        }
        ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
        this.layoutCachingService = (ILayoutCachingService)applicationContext.getBean("layoutCachingService", ILayoutCachingService.class);
        if (!owner.isGuest()) {
            this.layoutCachingService.removeCachedLayout(owner, profile);
        }
        owner.setAttribute("UserProfile", profile);
        try {
            this.owner = owner;
            this.profile = profile;
            this.setLayoutStore(store);
            this.loadUserLayout();
            this.getRootFolderId();
            this.addLayoutEventListener(new LayoutEventListener(){

                @Override
                public void channelAdded(LayoutEvent ev) {
                    DistributedLayoutManager.this.channelsAdded = true;
                }

                @Override
                public void channelUpdated(LayoutEvent ev) {
                }

                @Override
                public void channelMoved(LayoutMoveEvent ev) {
                }

                @Override
                public void channelDeleted(LayoutMoveEvent ev) {
                }

                @Override
                public void folderAdded(LayoutEvent ev) {
                }

                @Override
                public void folderUpdated(LayoutEvent ev) {
                }

                @Override
                public void folderMoved(LayoutMoveEvent ev) {
                }

                @Override
                public void folderDeleted(LayoutMoveEvent ev) {
                }

                @Override
                public void layoutLoaded() {
                }

                @Override
                public void layoutSaved() {
                    DistributedLayoutManager.this.channelsAdded = false;
                }
            });
        }
        catch (Throwable e) {
            throw new PortalException("Unable to instantiate DistributedLayoutManager for " + owner.getAttribute("username") + ".", e);
        }
    }

    private void setUserLayoutDOM(Document doc) {
        this.layoutCachingService.cacheLayout(this.owner, this.profile, doc);
        this.updateCacheKey();
        Element layout = doc.getDocumentElement();
        Attr attr = layout.getAttributeNodeNS("http://www.uportal.org/layout/dlm", "fragmentName");
        this.isFragmentOwner = attr != null;
        IFolderLabelPolicy labelPolicy = ContextHolder.getLabelPolicy();
        if (labelPolicy != null) {
            labelPolicy.coordinateFolderLabels(this.owner.getID(), this.isFragmentOwner, doc);
        }
    }

    @Override
    @Deprecated
    public Document getUserLayoutDOM() throws PortalException {
        try {
            Document userLayoutDocument;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("domRequest: " + this.domRequests++));
            }
            if (null == (userLayoutDocument = this.layoutCachingService.getCachedLayout(this.owner, this.profile))) {
                IUserLayoutStore layoutStore = this.getLayoutStore();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Load from store for " + this.owner.getAttribute("username")));
                }
                userLayoutDocument = layoutStore.getUserLayout(this.owner, this.profile);
                IAuthorizationService authServ = AuthorizationImpl.singleton();
                IAuthorizationPrincipal principal = authServ.newPrincipal(this.owner.getUserName(), IPerson.class);
                NodeList nodes = userLayoutDocument.getElementsByTagName("folder");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element fd = (Element)nodes.item(i);
                    String type = fd.getAttribute("type");
                    if (type == null || !type.equals("header") && !type.equals("footer")) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RDBMUserLayoutStore examining the '" + type + "' folder of user '" + this.owner.getUserName() + "' for non-authorized channels."));
                    }
                    NodeList channels = fd.getElementsByTagName("channel");
                    for (int j = 0; j < channels.getLength(); ++j) {
                        Element ch = (Element)channels.item(j);
                        try {
                            int chanId = Integer.parseInt(ch.getAttribute("chanID"));
                            if (principal.canRender(chanId)) continue;
                            fd.removeChild(ch);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("RDBMUserLayoutStore removing channel '" + ch.getAttribute("fname") + "' from the header or footer of user '" + this.owner.getUserName() + "' because he/she isn't authorized to render it."));
                            continue;
                        }
                        catch (Throwable t) {
                            LOG.warn((Object)("RDBMUserLayoutStore was unable to analyze channel element with Id=" + ch.getAttribute("chanID")), t);
                        }
                    }
                }
                this.setUserLayoutDOM(userLayoutDocument);
            }
            return userLayoutDocument;
        }
        catch (Exception ex) {
            throw new PortalException(ex);
        }
    }

    private void loadProcessingPipe() {
        ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
        this.processingPipe = (ProcessingPipe)applicationContext.getBean("dlmProcessingPipe", ProcessingPipe.class);
        this.processingPipe.setResources(this.owner, this);
    }

    @Override
    public void getUserLayout(ContentHandler ch) throws PortalException {
        Document ul = this.getUserLayoutDOM();
        if (ul == null) {
            throw new PortalException("User layout has not been initialized for " + this.owner.getAttribute("username") + ".");
        }
        this.getUserLayout(ul, ch);
    }

    @Override
    public void getUserLayout(String nodeId, ContentHandler ch) throws PortalException {
        Document ul = this.getUserLayoutDOM();
        if (ul == null) {
            throw new PortalException("User layout has not been initialized for " + this.owner.getAttribute("username") + ".");
        }
        Element rootNode = ul.getElementById(nodeId);
        if (rootNode == null) {
            throw new PortalException("A requested root node (with id=\"" + nodeId + "\") is not in the user layout for " + this.owner.getAttribute("username") + ".");
        }
        this.getUserLayout(rootNode, ch);
    }

    protected void getUserLayout(Node n, ContentHandler ch) throws PortalException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Layout event stream for " + this.owner.getAttribute("username") + " starting."));
        }
        Transformer xfrmr = null;
        xfrmr = this.getEmptyTransformer();
        try {
            ProcessingPipe pipe = this.getProcessingPipe();
            ch = pipe.getContentHandler(ch);
            xfrmr.transform(new DOMSource(n), new SAXResult(ch));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Layout event stream for " + this.owner.getAttribute("username") + " incurred exception."), (Throwable)e);
            }
            this.processingPipe = null;
            throw new PortalException("Unable to output user layout for " + this.owner.getAttribute("username") + ". Resetting processing pipe.", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Layout event stream for " + this.owner.getAttribute("username") + " finished."));
        }
    }

    private Transformer getEmptyTransformer() throws PortalException {
        Transformer xfrmr = null;
        try {
            xfrmr = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            throw new PortalException("Unable to instantiate transformer.", (Throwable)e);
        }
        return xfrmr;
    }

    @Override
    public void setLayoutStore(IUserLayoutStore store) {
        this.store = (RDBMDistributedLayoutStore)store;
    }

    protected IUserLayoutStore getLayoutStore() {
        return this.store;
    }

    @Override
    public synchronized void loadUserLayout() throws PortalException {
        this.loadUserLayout(false);
    }

    @Override
    public synchronized void loadUserLayout(boolean reload) throws PortalException {
        IUserLayoutStore layoutStore = this.getLayoutStore();
        if (layoutStore == null) {
            throw new PortalException("Store implementation has not been set for " + this.owner.getAttribute("username") + ".");
        }
        Document uli = null;
        try {
            if (reload) {
                this.layoutCachingService.removeCachedLayout(this.owner, this.profile);
            }
            uli = this.getUserLayoutDOM();
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while reading a layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
        }
        if (uli == null) {
            throw new PortalException("Null user layout returned for ownerId=\"" + this.owner.getID() + "\", profileId=\"" + this.profile.getProfileId() + "\", layoutId=\"" + this.profile.getLayoutId() + "\"");
        }
        try {
            if (uli != null) {
                for (LayoutEventListener lel : this.listeners) {
                    lel.layoutLoaded();
                }
            }
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered contacting layout listeners of layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
        }
    }

    @Override
    public synchronized void saveUserLayout() throws PortalException {
        Document uld = this.getUserLayoutDOM();
        if (uld == null) {
            throw new PortalException("UserLayout has not been initialized for " + this.owner.getAttribute("username") + ".");
        }
        IUserLayoutStore layoutStore = this.getLayoutStore();
        if (layoutStore == null) {
            throw new PortalException("Store implementation has not been set for " + this.owner.getAttribute("username") + ".");
        }
        try {
            layoutStore.setUserLayout(this.owner, this.profile, uld, this.channelsAdded);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while saving layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
        }
        try {
            for (LayoutEventListener lel : this.listeners) {
                lel.layoutSaved();
            }
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered contacting layout listeners of layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
        }
    }

    @Override
    public IUserLayoutNodeDescription getNode(String nodeId) throws PortalException {
        if (nodeId == null) {
            return null;
        }
        Document uld = this.getUserLayoutDOM();
        if (uld == null) {
            throw new PortalException("UserLayout has not been initialized for " + this.owner.getAttribute("username") + ".");
        }
        Element element = uld.getElementById(nodeId);
        if (element == null) {
            throw new PortalException("Element with ID=\"" + nodeId + "\" doesn't exist for " + this.owner.getAttribute("username") + ".");
        }
        IUserLayoutNodeDescription desc = this.createNodeDescription(element);
        if (nodeId.startsWith("u") && desc instanceof ChannelDescription) {
            FragmentChannelInfo info = this.store.getFragmentChannelInfo(nodeId);
            ((ChannelDescription)desc).setFragmentChannelInfo(info);
        }
        return desc;
    }

    @Override
    public IUserLayoutNodeDescription addNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        boolean isChannel = false;
        IUserLayoutNodeDescription parent = this.getNode(parentId);
        if (this.canAddNode(node, parent, nextSiblingId)) {
            IUserLayoutStore layoutStore = this.getLayoutStore();
            if (layoutStore == null) {
                throw new PortalException("Store implementation has not been set for " + this.owner.getAttribute("username") + ".");
            }
            try {
                if (node instanceof IUserLayoutChannelDescription) {
                    isChannel = true;
                    node.setId(layoutStore.generateNewChannelSubscribeId(this.owner));
                } else {
                    node.setId(layoutStore.generateNewFolderId(this.owner));
                    IFolderLabelPolicy labelPolicy = ContextHolder.getLabelPolicy();
                    if (labelPolicy != null) {
                        labelPolicy.addNodeLabel(node.getId(), parentId, this.getUserLayoutDOM(), this.owner.getID(), this.isFragmentOwner, node.getName());
                    }
                }
            }
            catch (Exception e) {
                throw new PortalException("Exception encountered while generating new user layout node Id for  for " + this.owner.getAttribute("username"), (Throwable)e);
            }
            Document uld = this.getUserLayoutDOM();
            Element childElement = node.getXML(uld);
            Element parentElement = uld.getElementById(parentId);
            if (nextSiblingId == null) {
                parentElement.appendChild(childElement);
            } else {
                Element nextSibling = uld.getElementById(nextSiblingId);
                parentElement.insertBefore(childElement, nextSibling);
            }
            childElement.setIdAttribute("ID", true);
            childElement.setAttribute("ID", node.getId());
            this.updateCacheKey();
            HandlerUtils.createPlfNodeAndPath(childElement, isChannel, this.owner);
            LayoutEvent ev = new LayoutEvent(this, parent, node);
            for (LayoutEventListener lel : this.listeners) {
                if (isChannel) {
                    lel.channelAdded(ev);
                    continue;
                }
                lel.folderAdded(ev);
            }
            return node;
        }
        return null;
    }

    @Override
    public boolean moveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        IUserLayoutNodeDescription parent = this.getNode(parentId);
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        String oldParentNodeId = this.getParentId(nodeId);
        if (this.canMoveNode(node, parent, nextSiblingId)) {
            Document uld = this.getUserLayoutDOM();
            Element childElement = uld.getElementById(nodeId);
            Element parentElement = uld.getElementById(parentId);
            if (nextSiblingId == null) {
                parentElement.appendChild(childElement);
            } else {
                Element nextSibling = uld.getElementById(nextSiblingId);
                parentElement.insertBefore(childElement, nextSibling);
            }
            this.updateCacheKey();
            Element oldParent = uld.getElementById(oldParentNodeId);
            TabColumnPrefsHandler.moveElement(childElement, oldParent, this.owner);
            boolean isChannel = false;
            if (node instanceof IUserLayoutChannelDescription) {
                isChannel = true;
            }
            IUserLayoutNodeDescription oldParentNode = this.getNode(oldParentNodeId);
            LayoutMoveEvent ev = new LayoutMoveEvent(this, parent, node, oldParentNode);
            for (LayoutEventListener lel : this.listeners) {
                if (isChannel) {
                    lel.channelMoved(ev);
                    continue;
                }
                lel.folderMoved(ev);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteNode(String nodeId) throws PortalException {
        if (this.canDeleteNode(nodeId)) {
            IUserLayoutNodeDescription nodeDescription = this.getNode(nodeId);
            String parentNodeId = this.getParentId(nodeId);
            Document uld = this.getUserLayoutDOM();
            Element ilfNode = uld.getElementById(nodeId);
            Node parent = ilfNode.getParentNode();
            if (parent == null) {
                throw new PortalException("Node \"" + nodeId + "\" has a NULL parent for layout of " + this.owner.getAttribute("username") + ".");
            }
            parent.removeChild(ilfNode);
            this.updateCacheKey();
            TabColumnPrefsHandler.deleteNode(ilfNode, (Element)parent, this.owner);
            boolean isChannel = false;
            if (nodeDescription instanceof IUserLayoutChannelDescription) {
                isChannel = true;
            }
            IUserLayoutNodeDescription parentNode = this.getNode(parentNodeId);
            LayoutMoveEvent ev = new LayoutMoveEvent(this, null, nodeDescription, parentNode);
            for (LayoutEventListener lel : this.listeners) {
                if (isChannel) {
                    lel.channelDeleted(ev);
                    continue;
                }
                lel.folderDeleted(ev);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean updateNode(IUserLayoutNodeDescription node) throws PortalException {
        if (this.canUpdateNode(node)) {
            String nodeId = node.getId();
            IUserLayoutNodeDescription oldNode = this.getNode(nodeId);
            if (oldNode instanceof IUserLayoutChannelDescription) {
                IUserLayoutChannelDescription oldChanDesc = (IUserLayoutChannelDescription)oldNode;
                if (!(node instanceof IUserLayoutChannelDescription)) {
                    throw new PortalException("Change channel to folder is not allowed by updateNode() method! Occurred in layout for " + this.owner.getAttribute("username") + ".");
                }
                IUserLayoutChannelDescription newChanDesc = (IUserLayoutChannelDescription)node;
                this.updateChannelNode(nodeId, newChanDesc, oldChanDesc);
                String parentNodeId = this.getParentId(nodeId);
                IUserLayoutNodeDescription parentNode = this.getNode(parentNodeId);
                LayoutEvent ev = new LayoutEvent(this, parentNode, node);
                for (LayoutEventListener lel : this.listeners) {
                    lel.channelUpdated(ev);
                }
            } else {
                IUserLayoutFolderDescription oldFolderDesc = (IUserLayoutFolderDescription)oldNode;
                if (oldFolderDesc.getId().equals(this.getRootFolderId())) {
                    throw new PortalException("Update of root node is not currently allowed!");
                }
                if (node instanceof IUserLayoutFolderDescription) {
                    IUserLayoutFolderDescription newFolderDesc = (IUserLayoutFolderDescription)node;
                    this.updateFolderNode(nodeId, newFolderDesc, oldFolderDesc);
                    String parentNodeId = this.getParentId(nodeId);
                    IUserLayoutNodeDescription parentNode = this.getNode(parentNodeId);
                    LayoutEvent ev = new LayoutEvent(this, parentNode, node);
                    for (LayoutEventListener lel : this.listeners) {
                        lel.folderUpdated(ev);
                    }
                }
            }
            this.updateCacheKey();
            return true;
        }
        return false;
    }

    private void updateFolderNode(String nodeId, IUserLayoutFolderDescription newFolderDesc, IUserLayoutFolderDescription oldFolderDesc) throws PortalException {
        Element ilfNode = this.getUserLayoutDOM().getElementById(nodeId);
        ArrayList<ILayoutProcessingAction> pendingActions = new ArrayList<ILayoutProcessingAction>();
        if (this.isFragmentOwner && (newFolderDesc.isDeleteAllowed() != oldFolderDesc.isDeleteAllowed() || newFolderDesc.isEditAllowed() != oldFolderDesc.isEditAllowed() || newFolderDesc.isAddChildAllowed() != oldFolderDesc.isAddChildAllowed() || newFolderDesc.isMoveAllowed() != oldFolderDesc.isMoveAllowed())) {
            pendingActions.add(new LPAEditRestriction(this.owner, ilfNode, newFolderDesc.isMoveAllowed(), newFolderDesc.isDeleteAllowed(), newFolderDesc.isEditAllowed(), newFolderDesc.isAddChildAllowed()));
        }
        this.updateNodeAttribute(ilfNode, nodeId, "name", newFolderDesc.getName(), oldFolderDesc.getName(), pendingActions);
        for (ILayoutProcessingAction action : pendingActions) {
            action.perform();
        }
    }

    private void updateNodeAttribute(Element ilfNode, String nodeId, String attName, String newVal, String oldVal, List<ILayoutProcessingAction> pendingActions) throws PortalException {
        if (newVal == null && oldVal != null || newVal != null && oldVal == null || newVal != null && oldVal != null && !newVal.equals(oldVal)) {
            boolean isIncorporated = nodeId.startsWith("u");
            if (isIncorporated) {
                FragmentNodeInfo fragNodeInf = this.store.getFragmentNodeInfo(nodeId);
                if (fragNodeInf == null) {
                    pendingActions.add(new LPAChangeAttribute(nodeId, attName, newVal, this.owner, ilfNode, this.isFragmentOwner));
                } else {
                    if (!fragNodeInf.canOverrideAttributes()) {
                        throw new PortalException("Layout element '" + fragNodeInf.getAttributeValue(attName) + "' does not allow overriding attribute '" + attName + "'.");
                    }
                    if (!fragNodeInf.getAttributeValue(attName).equals(newVal)) {
                        pendingActions.add(new LPAChangeAttribute(nodeId, attName, newVal, this.owner, ilfNode, this.isFragmentOwner));
                    } else {
                        pendingActions.add(new LPAResetAttribute(nodeId, attName, fragNodeInf.getAttributeValue(attName), this.owner, ilfNode));
                    }
                }
            } else {
                pendingActions.add(new LPAChangeAttribute(nodeId, attName, newVal, this.owner, ilfNode, this.isFragmentOwner));
            }
        }
    }

    private void updateChannelNode(String nodeId, IUserLayoutChannelDescription newChanDesc, IUserLayoutChannelDescription oldChanDesc) throws PortalException {
        String name;
        Element ilfNode = this.getUserLayoutDOM().getElementById(nodeId);
        ArrayList<ILayoutProcessingAction> pendingActions = new ArrayList<ILayoutProcessingAction>();
        boolean isIncorporated = nodeId.startsWith("u");
        if (this.isFragmentOwner && (newChanDesc.isDeleteAllowed() != oldChanDesc.isDeleteAllowed() || newChanDesc.isEditAllowed() != oldChanDesc.isEditAllowed() || newChanDesc.isMoveAllowed() != oldChanDesc.isMoveAllowed())) {
            pendingActions.add(new LPAEditRestriction(this.owner, ilfNode, newChanDesc.isMoveAllowed(), newChanDesc.isDeleteAllowed(), newChanDesc.isEditAllowed(), newChanDesc.isAddChildAllowed()));
        }
        FragmentChannelInfo fragChanInf = null;
        Map pubParms = this.getPublishedChannelParametersMap(newChanDesc.getChannelPublishId());
        if (isIncorporated) {
            fragChanInf = this.store.getFragmentChannelInfo(nodeId);
        }
        HashMap oldParms = new HashMap(oldChanDesc.getParameterMap());
        for (Map.Entry e : newChanDesc.getParameterMap().entrySet()) {
            name = (String)e.getKey();
            String newVal = (String)e.getValue();
            String oldVal = (String)oldParms.remove(name);
            if (oldVal == null) {
                pendingActions.add(new LPAAddParameter(nodeId, name, newVal, this.owner, ilfNode));
                continue;
            }
            if (oldVal.equals(newVal)) continue;
            if (!oldChanDesc.canOverrideParameter(name)) {
                throw new PortalException("This instance of " + oldChanDesc.getTitle() + " does not allow overriding parameter " + name);
            }
            if (isIncorporated) {
                String fragValue = fragChanInf.getParameterValue(name);
                if (fragValue == null) {
                    IChannelParameter cp = (IChannelParameter)pubParms.get(name);
                    if (cp != null && cp.getValue().equals(newVal)) {
                        pendingActions.add(new LPARemoveParameter(nodeId, name, this.owner, ilfNode));
                        continue;
                    }
                    pendingActions.add(new LPAChangeParameter(nodeId, name, newVal, this.owner, ilfNode));
                    continue;
                }
                if (!fragValue.equals(newVal)) {
                    pendingActions.add(new LPAChangeParameter(nodeId, name, newVal, this.owner, ilfNode));
                    continue;
                }
                pendingActions.add(new LPAResetParameter(nodeId, name, fragValue, this.owner, ilfNode));
                continue;
            }
            IChannelParameter cp = (IChannelParameter)pubParms.get(name);
            if (cp != null && cp.getValue().equals(newVal)) {
                pendingActions.add(new LPARemoveParameter(nodeId, name, this.owner, ilfNode));
                continue;
            }
            pendingActions.add(new LPAChangeParameter(nodeId, name, newVal, this.owner, ilfNode));
        }
        for (Map.Entry e : oldParms.entrySet()) {
            name = (String)e.getKey();
            pendingActions.add(new LPARemoveParameter(nodeId, name, this.owner, ilfNode));
        }
        for (ILayoutProcessingAction action : pendingActions) {
            action.perform();
        }
    }

    private Map getPublishedChannelParametersMap(String channelPublishId) throws PortalException {
        try {
            IChannelRegistryStore crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
            int pubId = Integer.parseInt(channelPublishId);
            IChannelDefinition def = crs.getChannelDefinition(pubId);
            return def.getParametersAsUnmodifiableMap();
        }
        catch (Exception e) {
            throw new PortalException("Unable to acquire channel definition.", (Throwable)e);
        }
    }

    @Override
    public boolean canAddNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.canAddNode(node, this.getNode(parentId), nextSiblingId);
    }

    protected boolean canAddNode(IUserLayoutNodeDescription node, IUserLayoutNodeDescription parent, String nextSiblingId) throws PortalException {
        if (nextSiblingId != null && !nextSiblingId.equals("")) {
            IUserLayoutNodeDescription sibling = this.getNode(nextSiblingId);
            if (sibling == null) {
                throw new PortalException("Unable to find a sibling node with id=\"" + nextSiblingId + "\".  Occurred " + "in layout for " + this.owner.getAttribute("username") + ".");
            }
            if (!parent.getId().equals(this.getParentId(nextSiblingId))) {
                throw new PortalException("Given sibling (\"" + nextSiblingId + "\") is not a child of a given parentId (\"" + parent.getId() + "\"). Occurred " + "in layout for " + this.owner.getAttribute("username") + ".");
            }
        }
        if (parent == null || !node.isMoveAllowed()) {
            return false;
        }
        if (parent instanceof IUserLayoutFolderDescription && !((IUserLayoutFolderDescription)parent).isAddChildAllowed()) {
            return false;
        }
        if (nextSiblingId == null || nextSiblingId.equals("")) {
            return true;
        }
        Enumeration<String> sibIds = this.getVisibleChildIds(parent.getId());
        ArrayList<String> sibs = Collections.list(sibIds);
        if (sibs.size() == 0) {
            return true;
        }
        for (int idx = sibs.size() - 1; idx >= 0; --idx) {
            IUserLayoutNodeDescription prev = this.getNode((String)sibs.get(idx));
            if (!MovementRules.canHopLeft(node, prev)) {
                return false;
            }
            if (!prev.getId().equals(nextSiblingId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canMoveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        return this.canMoveNode(this.getNode(nodeId), this.getNode(parentId), nextSiblingId);
    }

    protected boolean canMoveNode(IUserLayoutNodeDescription node, IUserLayoutNodeDescription parent, String nextSiblingId) throws PortalException {
        if (!this.getParentId(node.getId()).equals(parent.getId())) {
            return node.isMoveAllowed() && this.canAddNode(node, parent, nextSiblingId);
        }
        Document uld = this.getUserLayoutDOM();
        Element parentE = uld.getElementById(parent.getId());
        int idx = 0;
        int nodeIdx = -1;
        int sibIdx = -1;
        for (Element child = (Element)parentE.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            String id = child.getAttribute("ID");
            if (id.equals(node.getId())) {
                nodeIdx = idx;
            }
            if (id.equals(nextSiblingId)) {
                sibIdx = idx;
            }
            ++idx;
        }
        if (nodeIdx == -1 || nextSiblingId != null && sibIdx == -1) {
            return false;
        }
        if (nodeIdx < sibIdx || sibIdx == -1) {
            return this.canMoveRight(node.getId(), nextSiblingId);
        }
        return this.canMoveLeft(node.getId(), nextSiblingId);
    }

    private boolean canMoveRight(String nodeId, String targetNextSibId) throws PortalException {
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        Enumeration<String> sibIds = this.getVisibleChildIds(this.getParentId(nodeId));
        ArrayList<String> sibs = Collections.list(sibIds);
        for (int idx = sibs.indexOf(nodeId) + 1; idx > 0 && idx < sibs.size(); ++idx) {
            String nextSibId = (String)sibs.get(idx);
            IUserLayoutNodeDescription next = this.getNode(nextSibId);
            if (nextSibId != null && next.getId().equals(targetNextSibId)) {
                return true;
            }
            if (MovementRules.canHopRight(node, next)) continue;
            return false;
        }
        return targetNextSibId == null;
    }

    private boolean canMoveLeft(String nodeId, String targetNextSibId) throws PortalException {
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        Enumeration<String> sibIds = this.getVisibleChildIds(this.getParentId(nodeId));
        ArrayList<String> sibs = Collections.list(sibIds);
        for (int idx = sibs.indexOf(nodeId) - 1; idx >= 0; --idx) {
            String prevSibId = (String)sibs.get(idx);
            IUserLayoutNodeDescription prev = this.getNode(prevSibId);
            if (!MovementRules.canHopLeft(node, prev)) {
                return false;
            }
            if (targetNextSibId == null || !prev.getId().equals(targetNextSibId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDeleteNode(String nodeId) throws PortalException {
        return this.canDeleteNode(this.getNode(nodeId));
    }

    protected boolean canDeleteNode(IUserLayoutNodeDescription node) throws PortalException {
        if (node == null) {
            return false;
        }
        return node.isDeleteAllowed();
    }

    public boolean canUpdateNode(String nodeId) throws PortalException {
        return this.canUpdateNode(this.getNode(nodeId));
    }

    @Override
    public boolean canUpdateNode(IUserLayoutNodeDescription node) {
        if (node == null) {
            return false;
        }
        return this.isFragmentOwner || node.isEditAllowed() || node instanceof IUserLayoutChannelDescription;
    }

    @Override
    public void markAddTargets(IUserLayoutNodeDescription node) {
        throw new UnsupportedOperationException("Use an appropriate processor for adding targets.");
    }

    @Override
    public void markMoveTargets(String nodeId) throws PortalException {
        throw new UnsupportedOperationException("Use an appropriate processor for adding targets.");
    }

    @Override
    public String getParentId(String nodeId) throws PortalException {
        Document uld = this.getUserLayoutDOM();
        Element nelement = uld.getElementById(nodeId);
        if (nelement != null) {
            Node parent = nelement.getParentNode();
            if (parent != null) {
                if (parent.getNodeType() != 1) {
                    throw new PortalException("Node with id=\"" + nodeId + "\" is attached to something other then an element node.");
                }
                Element e = (Element)parent;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist. Occurred in layout for " + this.owner.getAttribute("username") + ".");
    }

    @Override
    public String getNextSiblingId(String nodeId) throws PortalException {
        Document uld = this.getUserLayoutDOM();
        Element nelement = uld.getElementById(nodeId);
        if (nelement != null) {
            Node nsibling;
            for (nsibling = nelement.getNextSibling(); nsibling != null && nsibling.getNodeType() != 1; nsibling = nsibling.getNextSibling()) {
            }
            if (nsibling != null) {
                Element e = (Element)nsibling;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist. Occurred " + "in layout for " + this.owner.getAttribute("username") + ".");
    }

    @Override
    public String getPreviousSiblingId(String nodeId) throws PortalException {
        Document uld = this.getUserLayoutDOM();
        Element nelement = uld.getElementById(nodeId);
        if (nelement != null) {
            Node nsibling;
            for (nsibling = nelement.getPreviousSibling(); nsibling != null && nsibling.getNodeType() != 1; nsibling = nsibling.getNextSibling()) {
            }
            if (nsibling != null) {
                Element e = (Element)nsibling;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist. Occurred in layout for " + this.owner.getAttribute("username") + ".");
    }

    @Override
    public Enumeration<String> getChildIds(String nodeId) throws PortalException {
        return this.getChildIds(nodeId, false);
    }

    private Enumeration<String> getVisibleChildIds(String nodeId) throws PortalException {
        return this.getChildIds(nodeId, true);
    }

    private Enumeration<String> getChildIds(String nodeId, boolean visibleOnly) throws PortalException {
        Vector<String> v = new Vector<String>();
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        if (node instanceof IUserLayoutFolderDescription) {
            Document uld = this.getUserLayoutDOM();
            Element felement = uld.getElementById(nodeId);
            for (Node n = felement.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element e;
                if (n.getNodeType() != 1 || visibleOnly && (!visibleOnly || !((Element)n).getAttribute("hidden").equals("false")) || (e = (Element)n).getAttribute("ID") == null) continue;
                v.add(e.getAttribute("ID"));
            }
        }
        return v.elements();
    }

    @Override
    public String getCacheKey() {
        String compositeKey = this.getProcessingPipe().getCacheKey() + ":" + this.cacheKey;
        return compositeKey;
    }

    private ProcessingPipe getProcessingPipe() {
        if (this.processingPipe == null) {
            this.loadProcessingPipe();
        }
        return this.processingPipe;
    }

    private void updateCacheKey() {
        this.cacheKey = Long.toString(rnd.nextLong());
    }

    @Override
    public int getLayoutId() {
        return this.profile.getLayoutId();
    }

    @Override
    public String getSubscribeId(String fname) {
        try {
            String expression = "//channel[@fname='" + fname + "']";
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            Element fnameNode = (Element)xpath.evaluate(expression, this.getUserLayoutDOM(), XPathConstants.NODE);
            if (fnameNode != null) {
                return fnameNode.getAttribute("ID");
            }
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)("Encountered exception while trying to identify subscribe channel id for the fname=\"" + fname + "\"" + " in layout of" + this.owner.getAttribute("username") + "."), (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean addLayoutEventListener(LayoutEventListener l) {
        return this.listeners.add(l);
    }

    @Override
    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return this.listeners.remove(l);
    }

    @Override
    public IUserLayout getUserLayout() throws PortalException {
        return new SimpleLayout(String.valueOf(this.profile.getLayoutId()), this.getUserLayoutDOM());
    }

    @Override
    public void setUserLayout(IUserLayout userLayout) throws PortalException {
        Document doc = DocumentFactory.getNewDocument();
        try {
            userLayout.writeTo(doc);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        this.updateCacheKey();
        this.layoutCachingService.cacheLayout(this.owner, this.profile, doc);
    }

    @Override
    public String getRootFolderId() {
        if (this.rootNodeId == null) {
            Document layout = this.getUserLayoutDOM();
            Element rootNode = RootLocator.getRootElement(layout);
            if (rootNode == null || !rootNode.getAttribute("type").equals("root")) {
                LOG.error((Object)("Unable to locate root node in layout of " + this.owner.getAttribute("username") + ". Resetting corrupted layout: " + XML.serializeNode(layout)));
                this.resetLayout((String)null);
                rootNode = RootLocator.getRootElement(this.getUserLayoutDOM());
                if (rootNode == null || !rootNode.getAttribute("type").equals("root")) {
                    throw new PortalException("Corrupted layout detected for " + this.owner.getAttribute("username") + " and resetting layout failed.");
                }
            }
            this.rootNodeId = rootNode.getAttribute("ID");
        }
        return this.rootNodeId;
    }

    @Override
    public int getDepth(String nodeId) throws PortalException {
        return 0;
    }

    @Override
    public IUserLayoutNodeDescription createNodeDescription(int nodeType) throws PortalException {
        if (nodeType == 2) {
            return new UserLayoutFolderDescription();
        }
        return new ChannelDescription();
    }

    @Override
    public void processLayoutParameters(IPerson person, UserPreferences userPrefs, HttpServletRequest req) throws PortalException {
        try {
            this.getProcessingPipe().processParameters(userPrefs, req);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    public boolean resetLayout(String loginId) {
        boolean resetCurrentUserLayout;
        boolean resetSuccess = false;
        boolean bl = resetCurrentUserLayout = null == loginId;
        if (resetCurrentUserLayout || !resetCurrentUserLayout && AdminEvaluator.isAdmin(this.owner)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reset layout requested for user with id " + loginId + "."));
            }
            int portalID = -1;
            IPerson person = null;
            if (resetCurrentUserLayout || loginId.equals(this.owner.getAttribute("username"))) {
                person = this.owner;
                portalID = this.owner.getID();
            } else {
                person = PersonFactory.createPerson();
                person.setAttribute("username", loginId);
                try {
                    IUserIdentityStore userStore = UserIdentityStoreFactory.getUserIdentityStoreImpl();
                    portalID = userStore.getPortalUID(person);
                    person.setID(portalID);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (portalID != -1) {
                resetSuccess = this.resetLayout(person);
            }
        } else {
            LOG.error((Object)("Layout reset requested for user " + loginId + " by " + this.owner.getID() + " who is not an administrative user."));
        }
        return resetSuccess;
    }

    private boolean resetLayout(IPerson person) {
        boolean layoutWasReset = false;
        if (this.store.isFragmentOwner(person)) {
            person.setAttribute("uPortalTemplateUserName", FragmentDefinition.getDefaultLayoutOwnerId());
        }
        IUserIdentityStore userStore = UserIdentityStoreFactory.getUserIdentityStoreImpl();
        try {
            userStore.removePortalUID(person.getID());
            userStore.getPortalUID(person, true);
            IFolderLabelPolicy labelPolicy = ContextHolder.getLabelPolicy();
            if (labelPolicy != null) {
                labelPolicy.purgeFolderLabels(person.getID(), this.isFragmentOwner);
            }
            if (person == this.owner) {
                this.layoutCachingService.removeCachedLayout(person, this.profile);
                this.updateCacheKey();
                this.getUserLayoutDOM();
            }
            layoutWasReset = true;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to reset layout for " + person.getAttribute("username") + "."), (Throwable)e);
        }
        return layoutWasReset;
    }

    public IUserLayoutNodeDescription createNodeDescription(Element node) throws PortalException {
        String type = node.getNodeName();
        if (type.equals("channel")) {
            return new ChannelDescription(node);
        }
        if (type.equals("folder")) {
            return new UserLayoutFolderDescription(node);
        }
        throw new PortalException("Given XML Element is not a channel!");
    }

    public Map getChannelFunctionalNameMap() throws PortalException {
        Document layout = this.getUserLayoutDOM();
        NodeList channelNodes = layout.getElementsByTagName("channel");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < channelNodes.getLength(); ++i) {
            Element chan = (Element)channelNodes.item(i);
            String id = chan.getAttribute("ID");
            String fname = chan.getAttribute("fname");
            if (id.equals("") || fname.equals("")) continue;
            map.put(id, fname);
        }
        return map;
    }

    IPerson getOwner() {
        return this.owner;
    }

    public IFolderLocalNameResolver getFolderNameResolver() {
        return this;
    }

    @Override
    public String getFolderLabel(String nodeId) {
        IFolderLabelPolicy labelPolicy;
        IUserLayoutNodeDescription ndesc = this.getNode(nodeId);
        if (!(ndesc instanceof IUserLayoutFolderDescription)) {
            return null;
        }
        IUserLayoutFolderDescription desc = (IUserLayoutFolderDescription)ndesc;
        boolean editAllowed = desc.isEditAllowed();
        String label = desc.getName();
        String plfId = nodeId;
        if (nodeId.startsWith("u")) {
            Document plf = RDBMDistributedLayoutStore.getPLF(this.owner);
            Element plfNode = plf.getElementById(nodeId);
            plfId = plfNode != null ? plfNode.getAttribute("dlm:plfID") : null;
        }
        if ((labelPolicy = ContextHolder.getLabelPolicy()) != null) {
            label = labelPolicy.getNodeLabel(nodeId, plfId, editAllowed, this.owner.getID(), this.isFragmentOwner, label);
        }
        return label;
    }

    static class ContextHolder {
        ContextHolder() {
        }

        public static IFolderLabelPolicy getLabelPolicy() {
            ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
            if (applicationContext.containsBean(DistributedLayoutManager.FOLDER_LABEL_POLICY)) {
                IFolderLabelPolicy folderLabelPolicy = (IFolderLabelPolicy)applicationContext.getBean(DistributedLayoutManager.FOLDER_LABEL_POLICY, IFolderLabelPolicy.class);
                return folderLabelPolicy;
            }
            return null;
        }
    }
}

