/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.properties.PropertiesManager;

public final class UserLayoutStoreFactory {
    public static final String LAYOUT_STORE_IMPL_PROPERTY = "org.jasig.portal.layout.UserLayoutStoreFactory.implementation";
    private static final Log LOG = LogFactory.getLog(UserLayoutStoreFactory.class);
    private static IUserLayoutStore userLayoutStoreImpl = null;
    private static final Class<? extends IUserLayoutStore> DEFAULT_LAYOUT_STORE = RDBMDistributedLayoutStore.class;

    public static synchronized IUserLayoutStore getUserLayoutStoreImpl() {
        if (userLayoutStoreImpl != null) {
            return userLayoutStoreImpl;
        }
        String className = "unknown";
        try {
            className = PropertiesManager.getProperty(LAYOUT_STORE_IMPL_PROPERTY);
            userLayoutStoreImpl = (IUserLayoutStore)Class.forName(className).newInstance();
            LOG.info((Object)("Instantiated and stored singleton IUserLayoutStore of type " + className));
            return userLayoutStoreImpl;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to instantiate IUserLayoutStore implementation [" + className + "], attempting to fall back on default of " + DEFAULT_LAYOUT_STORE.getName()), (Throwable)e);
            try {
                userLayoutStoreImpl = DEFAULT_LAYOUT_STORE.newInstance();
            }
            catch (Exception e2) {
                LOG.error((Object)("Error insantiating default layout store [" + DEFAULT_LAYOUT_STORE + "]"), (Throwable)e2);
            }
            return userLayoutStoreImpl;
        }
    }
}

