/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.IUserLayoutHelper;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.provider.RestrictedPerson;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public class UserLayoutHelperImpl
extends SimpleJdbcDaoSupport
implements IUserLayoutHelper {
    protected static final String DEFAULT_LAYOUT_FNAME = "default";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IUserIdentityStore userIdentityStore;

    @Required
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    @Override
    public void resetUserLayout(IPersonAttributes personAttributes) {
        RestrictedPerson person = PersonFactory.createRestrictedPerson();
        person.setAttributes(personAttributes.getAttributes());
        int uid = this.userIdentityStore.getPortalUID(person, false);
        person.setID(uid);
        IUserLayoutStore userLayoutStore = UserLayoutStoreFactory.getUserLayoutStoreImpl();
        try {
            UserProfile userProfile = userLayoutStore.getUserProfileByFname(person, DEFAULT_LAYOUT_FNAME);
            userProfile.setLayoutId(0);
            userLayoutStore.updateUserProfile(person, userProfile);
            this.logger.info((Object)("resetUserLayout complete for " + person));
        }
        catch (Exception e) {
            String msg = "Exception caught during resetUserLayout for " + person;
            this.logger.error((Object)msg, (Throwable)e);
            throw new PortalException(msg, (Throwable)e);
        }
    }
}

