/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.lang;

import org.jasig.portal.lang.ThrowableHelper;

public final class TypeConverter {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String toString(boolean value) {
        String outValue = null;
        outValue = value ? TRUE : FALSE;
        return outValue;
    }

    public static final boolean toBoolean(String value) {
        try {
            boolean outValue = false;
            if (TRUE == value || value.equalsIgnoreCase(TRUE)) {
                outValue = true;
            } else if (FALSE == value || value.equalsIgnoreCase(FALSE)) {
                outValue = false;
            } else {
                throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "boolean"}));
            }
            return outValue;
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
    }

    public static final String toString(byte value) {
        return TypeConverter.toString((int)value);
    }

    public static final byte toByte(String value) {
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "byte"}));
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
    }

    public static final String toString(char value) {
        return String.valueOf(new char[]{value});
    }

    public static final char toChar(String value) {
        try {
            return value.charAt(0);
        }
        catch (IndexOutOfBoundsException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "char"}));
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
    }

    public static final String toString(short value) {
        return TypeConverter.toString((int)value);
    }

    public static final short toShort(String value) {
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "short"}));
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
    }

    public static final String toString(int value) {
        return Integer.toString(value);
    }

    public static final int toInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "int"}));
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
    }

    public static final boolean isInt(String value) {
        boolean isInt = true;
        try {
            TypeConverter.toInt(value);
        }
        catch (IllegalArgumentException x) {
            isInt = false;
        }
        return isInt;
    }

    public static final String toString(long value) {
        return Long.toString(value);
    }

    public static final long toLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "long"}));
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
    }

    public static final String toString(float value) {
        return Float.toString(value);
    }

    public static final float toFloat(String value) {
        float floatValue = Float.NaN;
        try {
            floatValue = Float.parseFloat(value);
        }
        catch (NumberFormatException x) {
            if ("Infinity".equals(value)) {
                floatValue = Float.POSITIVE_INFINITY;
            }
            if ("-Infinity".equals(value)) {
                floatValue = Float.NEGATIVE_INFINITY;
            }
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "float"}));
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
        return floatValue;
    }

    public static final String toString(double value) {
        return Double.toString(value);
    }

    public static final double toDouble(String value) {
        double doubleValue = Double.NaN;
        try {
            doubleValue = Double.parseDouble(value);
        }
        catch (NumberFormatException x) {
            if ("Infinity".equals(value)) {
                doubleValue = Double.POSITIVE_INFINITY;
            }
            if ("-Infinity".equals(value)) {
                doubleValue = Double.NEGATIVE_INFINITY;
            }
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_not_parseable", new String[]{value, "double"}));
        }
        catch (NullPointerException x) {
            throw new IllegalArgumentException(ThrowableHelper.getInternationalizedMessage(TypeConverter.class, "error.argument_is_null"));
        }
        return doubleValue;
    }

    public static final String toHexString(byte[] values) {
        char[] buffer = new char[2 * values.length];
        for (int i = 0; i < values.length; ++i) {
            buffer[i << 1] = DIGITS[(values[i] & 0xF0) >> 4];
            buffer[(i << 1) + 1] = DIGITS[values[i] & 0xF];
        }
        return new String(buffer);
    }

    public static final String toHexString(long value) {
        return Long.toHexString(value);
    }

    private TypeConverter() {
    }
}

