/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jndi;

import java.util.Enumeration;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.http.HttpSession;
import org.jasig.portal.PortalException;
import org.jasig.portal.jndi.IJndiManager;
import org.jasig.portal.spring.web.context.support.HttpSessionDestroyedEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.jndi.JndiAccessor;
import org.springframework.jndi.JndiCallback;
import org.springframework.jndi.JndiTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JndiManagerImpl
extends JndiAccessor
implements IJndiManager,
ApplicationListener,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        this.initializePortalContext();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionDestroyedEvent) {
            HttpSession session = ((HttpSessionDestroyedEvent)event).getSession();
            this.destroySessionContext(session);
        }
    }

    @Override
    public void initializeSessionContext(HttpSession session, String userId, String layoutId, Document userLayout) {
        Context sessionIdContext;
        Context usersContext;
        String sessionId = session.getId();
        JndiTemplate jndiTemplate = this.getJndiTemplate();
        try {
            Context sessionsContext = (Context)jndiTemplate.lookup("/sessions", Context.class);
            try {
                sessionsContext.bind(sessionId, (Object)userId);
            }
            catch (NameAlreadyBoundException nabe) {
                sessionsContext.rebind(sessionId, (Object)userId);
            }
        }
        catch (NamingException ne) {
            this.logger.warn((Object)("Unable to obtain /sessions context, no session data will be available in the context for sessionId='" + sessionId + "', userId='" + userId + "', and layoutId='" + layoutId + "'"), (Throwable)ne);
        }
        try {
            usersContext = (Context)jndiTemplate.lookup("/users", Context.class);
        }
        catch (NamingException ne) {
            PortalException portalException = new PortalException("Could not find /users context", (Throwable)ne);
            this.logger.error((Object)portalException.getMessage(), (Throwable)ne);
            throw portalException;
        }
        Context userIdContext = null;
        Context sessionsContext = null;
        Context layoutsContext = null;
        try {
            userIdContext = (Context)usersContext.lookup(userId);
            try {
                layoutsContext = (Context)userIdContext.lookup("layouts");
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("The '/users/" + userId + "/layouts' Context did not exist, even though the '/users/" + userId + "' Context did. It will be created."));
                layoutsContext = userIdContext.createSubcontext("layouts");
            }
            try {
                sessionsContext = (Context)userIdContext.lookup("sessions");
            }
            catch (NamingException ne) {
                this.logger.error((Object)("The Context '/users/" + userId + "/sessions' did not exist, even though the '/users/" + userId + "' Context did. It will be created."));
                sessionsContext = userIdContext.createSubcontext("sessions");
            }
        }
        catch (NamingException ne) {
            try {
                userIdContext = usersContext.createSubcontext(userId);
                layoutsContext = userIdContext.createSubcontext("layouts");
                sessionsContext = userIdContext.createSubcontext("sessions");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created and initialized Contexts for a userId='" + userId + "'"));
                }
            }
            catch (NamingException ne2) {
                PortalException portalException = new PortalException("exception encountered while trying to create  '/users/" + userId + "' and layouts/sessions Contexts", (Throwable)ne2);
                this.logger.error((Object)portalException.getMessage(), (Throwable)ne2);
                throw portalException;
            }
        }
        try {
            sessionIdContext = sessionsContext.createSubcontext(sessionId);
        }
        catch (NameAlreadyBoundException nabe) {
            PortalException portalException = new PortalException("A session context is already bound at '/users/" + userId + "/sessions/" + sessionId + "'", (Throwable)nabe);
            this.logger.error((Object)portalException.getMessage(), (Throwable)nabe);
            throw portalException;
        }
        catch (NamingException ne) {
            PortalException portalException = new PortalException("Excpetion encountered while trying to create Context '/users/" + userId + "/sessions/" + sessionId + "'", (Throwable)ne);
            this.logger.error((Object)portalException.getMessage(), (Throwable)ne);
            throw portalException;
        }
        try {
            sessionIdContext.bind("layoutId", (Object)layoutId);
        }
        catch (NamingException ne) {
            PortalException portalException = new PortalException("Excpetion encountered while trying to bind '" + layoutId + "' to '/users/" + userId + "/sessions/" + sessionId + "/layoutId'", (Throwable)ne);
            this.logger.error((Object)portalException.getMessage(), (Throwable)ne);
            throw portalException;
        }
        try {
            sessionIdContext.createSubcontext("channel-obj");
        }
        catch (NameAlreadyBoundException nabe) {
        }
        catch (NamingException ne) {
            this.logger.warn((Object)("Excpetion encountered while create Context '" + layoutId + "' to '/users/" + userId + "/sessions/" + sessionId + "/channel-obj', this will be ignored."), (Throwable)ne);
        }
        try {
            Context layoutSessionsContext;
            layoutsContext.lookup(layoutId);
            try {
                layoutSessionsContext = (Context)userIdContext.lookup("layouts/" + layoutId + "/sessions");
            }
            catch (NamingException ne) {
                PortalException portalException = new PortalException("Exception occured while looking up Context '/users/" + userId + "/layouts/" + layoutId + "/sessions/' even though Context '/users/" + userId + "/layouts' already existed.", (Throwable)ne);
                this.logger.error((Object)portalException.getMessage(), (Throwable)ne);
                throw portalException;
            }
            try {
                layoutSessionsContext.createSubcontext(sessionId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created Context '/users/" + userId + "/layouts/" + layoutId + "/sessions/" + sessionId + "'"));
                }
            }
            catch (NamingException ne) {
                PortalException portalException = new PortalException("Exception occured while creating Context '/users/" + userId + "/layouts/" + layoutId + "/sessions/" + sessionId + "'", (Throwable)ne);
                this.logger.error((Object)portalException.getMessage(), (Throwable)ne);
                throw portalException;
            }
        }
        catch (NamingException ne) {
            Context layoutIdContext;
            try {
                layoutIdContext = layoutsContext.createSubcontext(layoutId);
                Context layoutSessionsContext = layoutIdContext.createSubcontext("sessions");
                layoutSessionsContext.createSubcontext(sessionId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created Context '/users/" + userId + "/layouts/" + layoutId + "'"));
                }
            }
            catch (NamingException ne2) {
                PortalException portalException = new PortalException("Exception occured while creating the '/users/" + userId + "/layouts/" + layoutId + "' Context.", (Throwable)ne2);
                this.logger.error((Object)portalException.getMessage(), (Throwable)ne2);
                throw portalException;
            }
            try {
                Context channel_idsContext = layoutIdContext.createSubcontext("channel-ids");
                NodeList channelNodes = userLayout.getElementsByTagName("channel");
                for (int channelNodeIndex = 0; channelNodeIndex < channelNodes.getLength(); ++channelNodeIndex) {
                    Node channelNode = channelNodes.item(channelNodeIndex);
                    NamedNodeMap channelAttributes = channelNode.getAttributes();
                    Node fname = channelAttributes.getNamedItem("fname");
                    Node instanceId = channelAttributes.getNamedItem("ID");
                    if (fname == null || instanceId == null) continue;
                    CompositeName cname = new CompositeName(fname.getNodeValue());
                    Enumeration<String> subContextNameEnum = cname.getAll();
                    Context nextContext = channel_idsContext;
                    while (subContextNameEnum.hasMoreElements()) {
                        String subContextName = subContextNameEnum.nextElement();
                        if (subContextNameEnum.hasMoreElements()) {
                            nextContext = nextContext.createSubcontext(subContextName);
                            continue;
                        }
                        nextContext.rebind(subContextName, (Object)instanceId.getNodeValue());
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Bound channel id '" + instanceId.getNodeValue() + "' to '" + nextContext.getNameInNamespace() + "/" + subContextName + "'"));
                    }
                }
            }
            catch (NamingException ne2) {
                PortalException portalException = new PortalException("Exception occured while creating or populating the '/users/" + userId + "/layouts/" + layoutId + "/channel-ids' Context.", (Throwable)ne2);
                this.logger.error((Object)portalException.getMessage(), (Throwable)ne2);
                throw portalException;
            }
        }
        this.logger.info((Object)("JNDI Context configured for sessionId='" + sessionId + "', userId='" + userId + "', and layoutId='" + layoutId + "'"));
    }

    @Override
    public void destroySessionContext(HttpSession session) {
        String layoutId;
        String userId;
        String sessionId;
        block36: {
            Context sessionIdContext;
            Context sessionsContext;
            Context userIdContext;
            Context topSessionsContext;
            Context usersContext;
            JndiTemplate jndiTemplate = this.getJndiTemplate();
            sessionId = session.getId();
            try {
                usersContext = (Context)jndiTemplate.lookup("/users", Context.class);
            }
            catch (NamingException ne) {
                PortalException portalException = new PortalException("Could not find /users context", (Throwable)ne);
                this.logger.error((Object)portalException.getMessage(), (Throwable)ne);
                throw portalException;
            }
            if (usersContext == null) {
                this.logger.warn((Object)("No JNDI Context removed for sessionId='" + sessionId + "'"));
                return;
            }
            try {
                topSessionsContext = (Context)jndiTemplate.lookup("/sessions", Context.class);
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("Could not get /sessions context. No JNDI context will be removed for sessionId='" + sessionId + "'"), (Throwable)ne);
                return;
            }
            try {
                userId = (String)topSessionsContext.lookup(sessionId);
            }
            catch (NamingException ne) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Session '" + sessionId + "' is not registered under /sessions context, returning immediatly."), (Throwable)ne);
                }
                return;
            }
            if (userId == null) {
                this.logger.warn((Object)("Unable to determine userId for a session " + sessionId + " ... giving up on JNDI cleanup."));
                return;
            }
            try {
                topSessionsContext.unbind(sessionId);
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("Problems unbinding '/sessions/" + sessionId + "', continuing with cleanup."), (Throwable)ne);
            }
            try {
                userIdContext = (Context)usersContext.lookup(userId);
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("Context '/users/" + userId + "' doesn't exist. Ending JNDI Cleanup here."), (Throwable)ne);
                return;
            }
            try {
                sessionsContext = (Context)userIdContext.lookup("sessions");
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("Context '/users/" + userId + "/sessions' doesn't exist. Ending JNDI Cleanup here."), (Throwable)ne);
                return;
            }
            try {
                sessionIdContext = (Context)sessionsContext.lookup(sessionId);
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("Context '/users/" + userId + "/sessions/" + sessionId + "' doesn't exist. Ending JNDI Cleanup here."), (Throwable)ne);
                return;
            }
            layoutId = null;
            try {
                layoutId = (String)sessionIdContext.lookup("layoutId");
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("'/users/" + userId + "/sessions/" + sessionId + "/layoutId' is not bound."), (Throwable)ne);
            }
            try {
                sessionsContext.unbind(sessionId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Destroyed Context '/users/" + userId + "/sessions/" + sessionId + "'"));
                }
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("Exception occurred while trying to destroy context  '/users/" + userId + "/sessions/" + sessionId + "', ignoring and continuing with cleanup."), (Throwable)ne);
            }
            try {
                NamingEnumeration<NameClassPair> userSessionsList = userIdContext.list("sessions");
                if (!userSessionsList.hasMore()) {
                    usersContext.unbind(userId);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Destroyed Context '/users/" + userId + "' since the last remaining session has been unbound."));
                    }
                    break block36;
                }
                try {
                    Context layoutsContext = (Context)userIdContext.lookup("layouts");
                    try {
                        Context layoutIdContext = (Context)layoutsContext.lookup(layoutId);
                        try {
                            NamingEnumeration<NameClassPair> layoutSessionsList;
                            Context layoutSessionsContext = (Context)layoutIdContext.lookup("sessions");
                            layoutSessionsContext.unbind(sessionId);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Destroyed Context '/users/" + userId + "/layouts/" + layoutId + "/sessions/" + sessionId + "'"));
                            }
                            if ((layoutSessionsList = layoutIdContext.list("sessions")).hasMore()) break block36;
                            try {
                                layoutsContext.unbind(layoutId);
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug((Object)("Destroyed Context '/users/" + userId + "/layouts/" + layoutId + "' since the last session using it has been unbound."));
                                }
                            }
                            catch (NamingException ne) {
                                this.logger.warn((Object)("Exception while destroying '/users/" + userId + "/layouts/" + layoutId + "', ignoring and continuing with cleanup."), (Throwable)ne);
                            }
                        }
                        catch (NamingException ne) {
                            this.logger.warn((Object)("Exception while looking up  '/users/" + userId + "/layouts/" + layoutId + "/sesions', ignoring and continuing with cleanup."), (Throwable)ne);
                        }
                    }
                    catch (NamingException ne) {
                        this.logger.warn((Object)("Exception while looking up  /users/" + userId + "/layouts/', ignoring and continuing with cleanup."), (Throwable)ne);
                    }
                }
                catch (NamingException ne) {
                    this.logger.warn((Object)("Exception while looking up  /users/" + userId + "/layouts', ignoring and continuing with cleanup."), (Throwable)ne);
                }
            }
            catch (NamingException ne) {
                this.logger.warn((Object)("Error listing  '/users/" + userId + "/sessions/', ignoring and continuing with cleanup."), (Throwable)ne);
            }
        }
        this.logger.info((Object)("JNDI Context removed for sessionId='" + sessionId + "', userId='" + userId + "', and layoutId='" + layoutId + "'"));
    }

    protected void initializePortalContext() throws NamingException {
        JndiTemplate jndiTemplate = this.getJndiTemplate();
        jndiTemplate.execute((JndiCallback)new CreateSubContextCallback("services"));
        jndiTemplate.execute((JndiCallback)new CreateSubContextCallback("users"));
        jndiTemplate.execute((JndiCallback)new CreateSubContextCallback("sessions"));
        this.logger.info((Object)"Initialized portal JNDI context");
    }

    private static class CreateSubContextCallback
    implements JndiCallback {
        private final String subContextName;

        public CreateSubContextCallback(String subContextName) {
            this.subContextName = subContextName;
        }

        public Object doInContext(Context ctx) throws NamingException {
            Context subcontext = ctx.createSubcontext(this.subContextName);
            return subcontext;
        }
    }
}

