/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jmx;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.GuestUserInstance;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.ProblemsTable;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.UserInstance;
import org.jasig.portal.jmx.FrameworkMBean;
import org.jasig.portal.rendering.StaticRenderingPipeline;
import org.jasig.portal.services.Authentication;
import org.jasig.portal.utils.MovingAverageSample;

public class FrameworkMBeanImpl
implements FrameworkMBean {
    @Override
    public Date getStartedAt() {
        return PortalSessionManager.STARTED_AT;
    }

    @Override
    public long getRenderAverage() {
        return this.getLastRender().average;
    }

    @Override
    public long getRenderHighMax() {
        return this.getLastRender().highMax;
    }

    @Override
    public long getRenderLast() {
        return this.getLastRender().lastSample;
    }

    @Override
    public long getRenderMin() {
        return this.getLastRender().min;
    }

    @Override
    public long getRenderMax() {
        return this.getLastRender().max;
    }

    @Override
    public long getRenderTotalRenders() {
        return this.getLastRender().totalSamples;
    }

    public MovingAverageSample getLastRender() {
        return StaticRenderingPipeline.getLastRenderSample();
    }

    @Override
    public String[] getRecentProblems() {
        List<PortalException> rpe = ProblemsTable.getRecentPortalExceptions();
        ArrayList<String> al = new ArrayList<String>(rpe.size());
        for (PortalException pe : rpe) {
            al.add(pe.getMessage());
        }
        return al.toArray(new String[al.size()]);
    }

    @Override
    public long getUserSessionCount() {
        return UserInstance.getUserSessions();
    }

    @Override
    public long getGuestSessionCount() {
        return GuestUserInstance.getGuestSessions();
    }

    public MovingAverageSample getLastDatabase() {
        return RDBMServices.getLastDatabase();
    }

    @Override
    public long getDatabaseAverage() {
        return this.getLastDatabase().average;
    }

    @Override
    public long getDatabaseHighMax() {
        return this.getLastDatabase().highMax;
    }

    @Override
    public long getDatabaseLast() {
        return this.getLastDatabase().lastSample;
    }

    @Override
    public long getDatabaseMin() {
        return this.getLastDatabase().min;
    }

    @Override
    public long getDatabaseMax() {
        return this.getLastDatabase().max;
    }

    @Override
    public long getDatabaseTotalConnections() {
        return this.getLastDatabase().totalSamples;
    }

    @Override
    public int getRDBMActiveConnectionCount() {
        return RDBMServices.getActiveConnectionCount();
    }

    @Override
    public int getRDBMMaxConnectionCount() {
        return RDBMServices.getMaxConnectionCount();
    }

    public MovingAverageSample getLastAuthentication() {
        return Authentication.lastAuthentication;
    }

    @Override
    public long getAuthenticationAverage() {
        return Authentication.lastAuthentication.average;
    }

    @Override
    public long getAuthenticationHighMax() {
        return Authentication.lastAuthentication.highMax;
    }

    @Override
    public long getAuthenticationLast() {
        return Authentication.lastAuthentication.lastSample;
    }

    @Override
    public long getAuthenticationMin() {
        return Authentication.lastAuthentication.min;
    }

    @Override
    public long getAuthenticationMax() {
        return Authentication.lastAuthentication.max;
    }

    @Override
    public long getAuthenticationTotalLogins() {
        return Authentication.lastAuthentication.totalSamples;
    }

    @Override
    public long getThreadCount() {
        return PortalSessionManager.getThreadGroup().activeCount();
    }

    @Override
    public long getChannelRendererActiveThreads() {
        return ChannelManager.getActiveRenderers();
    }

    @Override
    public long getChannelRendererMaxActiveThreads() {
        return ChannelManager.getMaxRenderThreads();
    }
}

