/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletPreferences;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.EmptyResultDataAccessException;

public class PortletEntityPreferenceHandler {
    private IChannelRegistryStore channelRegistryStore;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private DataSource dataSource;

    public IChannelRegistryStore getChannelRegistryStore() {
        return this.channelRegistryStore;
    }

    @Required
    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        Validate.notNull((Object)channelRegistryStore, (String)"channelRegistryStore can not be null");
        this.channelRegistryStore = channelRegistryStore;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        Validate.notNull((Object)portletDefinitionRegistry, (String)"portletDefinitionRegistry can not be null");
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        Validate.notNull((Object)portletEntityRegistry, (String)"portletEntityRegistry can not be null");
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        Validate.notNull((Object)dataSource, (String)"dataSource can not be null");
        this.dataSource = dataSource;
    }

    public Set<IPortletEntity> getEntityPreferences(Integer userId) {
        Set<IPortletEntity> portletEntities = this.portletEntityRegistry.getPortletEntitiesForUser(userId);
        Iterator<IPortletEntity> entityItr = portletEntities.iterator();
        while (entityItr.hasNext()) {
            IPortletEntity portletEntity = entityItr.next();
            IPortletPreferences portletPreferences = portletEntity.getPortletPreferences();
            List<IPortletPreference> preferencesList = portletPreferences.getPortletPreferences();
            if (preferencesList.size() > 0) continue;
            entityItr.remove();
        }
        return portletEntities;
    }

    public void setEntityPreference(String fName, String channelSubscribeId, Integer userId, LinkedHashMap<String, List<String>> preferencesMap) {
        IPortletEntity portletEntity = this.getPortletEntity(fName, channelSubscribeId, userId);
        ArrayList<IPortletPreference> portletPreferencesList = new ArrayList<IPortletPreference>(preferencesMap.size());
        for (Map.Entry<String, List<String>> prefEntry : preferencesMap.entrySet()) {
            String prefName = prefEntry.getKey();
            List<String> prefValues = prefEntry.getValue();
            PortletPreferenceImpl portletPreference = new PortletPreferenceImpl(prefName, false, prefValues.toArray(new String[prefValues.size()]));
            portletPreferencesList.add(portletPreference);
        }
        IPortletPreferences portletPreferences = portletEntity.getPortletPreferences();
        portletPreferences.setPortletPreferences(portletPreferencesList);
        this.portletEntityRegistry.storePortletEntity(portletEntity);
    }

    protected IPortletEntity getPortletEntity(String fName, String channelSubscribeId, int userId) {
        IChannelDefinition channelDefinition;
        try {
            channelDefinition = this.channelRegistryStore.getChannelDefinition(fName);
        }
        catch (Exception e) {
            throw new DataRetrievalFailureException("Failed to retrieve ChannelDefinition for fName='" + fName + "'", (Throwable)e);
        }
        if (channelDefinition == null) {
            throw new EmptyResultDataAccessException("No ChannelDefinition exists for fName='" + fName + "'", 1);
        }
        int channelDefinitionId = channelDefinition.getId();
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getOrCreatePortletDefinition(channelDefinitionId);
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        return this.portletEntityRegistry.getOrCreatePortletEntity(portletDefinitionId, channelSubscribeId, userId);
    }
}

