/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.i18n;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.i18n.ILocaleStore;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;

public class RDBMLocaleStore
implements ILocaleStore {
    private static final Log log = LogFactory.getLog(RDBMLocaleStore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Locale[] getUserLocales(IPerson person) throws Exception {
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        Connection con = RDBMServices.getConnection();
        try {
            String query = "SELECT * FROM UP_USER_LOCALE WHERE USER_ID=? ORDER BY PRIORITY";
            PreparedStatement pstmt = con.prepareStatement(query);
            try {
                pstmt.clearParameters();
                pstmt.setInt(1, person.getID());
                log.debug((Object)query);
                ResultSet rs = pstmt.executeQuery();
                try {
                    while (rs.next()) {
                        String localeString = rs.getString("LOCALE");
                        Locale locale = LocaleManager.parseLocale(localeString);
                        localeList.add(locale);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return localeList.toArray(new Locale[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserLocales(IPerson person, Locale[] locales) throws SQLException {
        Connection con = RDBMServices.getConnection();
        try {
            String delete = "DELETE FROM UP_USER_LOCALE WHERE USER_ID=?";
            PreparedStatement pstmt = con.prepareStatement(delete);
            try {
                pstmt.clearParameters();
                pstmt.setInt(1, person.getID());
                log.debug((Object)delete);
                pstmt.executeUpdate();
            }
            finally {
                pstmt.close();
            }
            String insert = "INSERT INTO UP_USER_LOCALE VALUES (?, ?, ?)";
            pstmt = con.prepareStatement(insert);
            try {
                for (int i = 0; i < locales.length; ++i) {
                    pstmt.clearParameters();
                    pstmt.setInt(1, person.getID());
                    pstmt.setString(2, locales[i].toString());
                    pstmt.setInt(3, i);
                    log.debug((Object)insert);
                    pstmt.executeUpdate();
                }
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }
}

