/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.i18n;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.i18n.LocaleStoreFactory;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocaleManager
implements Serializable {
    private static final Log log = LogFactory.getLog(LocaleManager.class);
    public static final boolean DEFAULT_LOCALE_AWARE = false;
    private IPerson person;
    private static boolean localeAware = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.i18n.LocaleManager.locale_aware", false);
    private static Locale jvmLocale;
    private static Locale[] portalLocales;
    private Locale[] sessionLocales;
    private Locale[] browserLocales;
    private Locale[] userLocales;

    public LocaleManager(IPerson person) {
        this.person = person;
        jvmLocale = Locale.getDefault();
        if (localeAware) {
            portalLocales = this.loadPortalLocales();
            try {
                this.userLocales = LocaleStoreFactory.getLocaleStoreImpl().getUserLocales(person);
            }
            catch (Exception e) {
                log.error((Object)"Error populating userLocals", (Throwable)e);
            }
        }
    }

    public LocaleManager(IPerson person, String acceptLanguage) {
        this(person);
        this.browserLocales = LocaleManager.parseLocales(acceptLanguage);
    }

    public static boolean isLocaleAware() {
        return localeAware;
    }

    public static Locale getJvmLocale() {
        return jvmLocale;
    }

    public static Locale[] getPortalLocales() {
        return portalLocales;
    }

    public Locale[] getBrowserLocales() {
        return this.browserLocales;
    }

    public Locale[] getUserLocales() {
        return this.userLocales;
    }

    public Locale[] getSessionLocales() {
        return this.sessionLocales;
    }

    public static void setJvmLocale(Locale jvmLocale) {
        LocaleManager.jvmLocale = jvmLocale;
    }

    public static void setPortalLocales(Locale[] portalLocales) {
        LocaleManager.portalLocales = portalLocales;
    }

    public void setBrowserLocales(Locale[] browserLocales) {
        this.browserLocales = browserLocales;
    }

    public void setUserLocales(Locale[] userLocales) {
        this.userLocales = userLocales;
        this.sessionLocales = userLocales;
    }

    public void setSessionLocales(Locale[] sessionLocales) {
        this.sessionLocales = sessionLocales;
    }

    private Locale[] loadPortalLocales() {
        String portalLocalesString = PropertiesManager.getProperty("org.jasig.portal.i18n.LocaleManager.portal_locales");
        return LocaleManager.parseLocales(portalLocalesString);
    }

    public Locale[] getLocales() {
        ArrayList locales = new ArrayList();
        this.addToLocaleList(locales, this.sessionLocales);
        this.addToLocaleList(locales, this.userLocales);
        this.addToLocaleList(locales, portalLocales);
        this.addToLocaleList(locales, new Locale[]{jvmLocale});
        return locales.toArray(new Locale[0]);
    }

    private void addToLocaleList(List localeList, Locale[] locales) {
        if (locales != null) {
            for (int i = 0; i < locales.length; ++i) {
                if (locales[i] == null || localeList.contains(locales[i])) continue;
                localeList.add(locales[i]);
            }
        }
    }

    public static Locale[] parseLocales(String localeStringList) {
        Locale[] locales = null;
        if (localeStringList != null) {
            StringTokenizer st = new StringTokenizer(localeStringList, ",");
            locales = new Locale[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String localeString = st.nextToken().trim();
                locales[i] = LocaleManager.parseLocale(localeString);
                ++i;
            }
        }
        return locales;
    }

    public static Locale parseLocale(String localeString) {
        String language = null;
        String country = null;
        String variant = null;
        StringTokenizer st = new StringTokenizer(localeString = CommonUtils.replaceText(localeString, "-", "_"), "_");
        if (st.hasMoreTokens()) {
            language = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            country = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            variant = st.nextToken();
        }
        Locale locale = null;
        if (variant != null) {
            locale = new Locale(language, country, variant);
        } else if (country != null) {
            locale = new Locale(language, country);
        } else if (language != null) {
            locale = new Locale(language, "");
        }
        return locale;
    }

    public static String stringValueOf(Locale[] locales) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            sb.append(locale.toString());
            if (i >= locales.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void persistUserLocales(Locale[] userLocales) throws Exception {
        this.setUserLocales(userLocales);
        LocaleStoreFactory.getLocaleStoreImpl().updateUserLocales(this.person, userLocales);
    }

    public static Document xmlValueOf(Locale[] locales) {
        return LocaleManager.xmlValueOf(locales, null);
    }

    public static Document xmlValueOf(Locale[] locales, Locale selectedLocale) {
        Document doc = DocumentFactory.getNewDocument();
        Element localesE = doc.createElement("locales");
        for (int i = 0; i < locales.length; ++i) {
            Element locE = doc.createElement("locale");
            locE.setAttribute("displayName", locales[i].getDisplayName(locales[0]));
            locE.setAttribute("code", locales[i].toString());
            if (selectedLocale != null && selectedLocale.equals(locales[i])) {
                locE.setAttribute("selected", "true");
            }
            Element languageE = doc.createElement("language");
            languageE.setAttribute("iso2", locales[i].getLanguage());
            try {
                languageE.setAttribute("iso3", locales[i].getISO3Language());
            }
            catch (Exception e) {
                // empty catch block
            }
            languageE.setAttribute("displayName", locales[i].getDisplayLanguage(locales[0]));
            locE.appendChild(languageE);
            Element countryE = doc.createElement("country");
            countryE.setAttribute("iso2", locales[i].getCountry());
            try {
                countryE.setAttribute("iso3", locales[i].getISO3Country());
            }
            catch (Exception e) {
                // empty catch block
            }
            countryE.setAttribute("displayName", locales[i].getDisplayCountry(locales[0]));
            locE.appendChild(countryE);
            Element variantE = doc.createElement("variant");
            variantE.setAttribute("code", locales[i].getVariant());
            variantE.setAttribute("displayName", locales[i].getDisplayVariant(locales[0]));
            locE.appendChild(variantE);
            localesE.appendChild(locE);
        }
        doc.appendChild(localesE);
        return doc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("LocaleManager's locales").append("\n");
        sb.append("-----------------------").append("\n");
        sb.append("Session locales: ");
        if (this.sessionLocales != null) {
            sb.append(LocaleManager.stringValueOf(this.sessionLocales));
        }
        sb.append("\n");
        sb.append("User locales: ");
        if (this.userLocales != null) {
            sb.append(LocaleManager.stringValueOf(this.userLocales));
        }
        sb.append("\n");
        sb.append("Browser locales: ");
        if (this.browserLocales != null) {
            sb.append(LocaleManager.stringValueOf(this.browserLocales));
        }
        sb.append("\n");
        sb.append("Portal locales: ");
        if (portalLocales != null) {
            sb.append(LocaleManager.stringValueOf(portalLocales));
        }
        sb.append("\n");
        sb.append("JVM locale: ");
        if (jvmLocale != null) {
            sb.append(jvmLocale.toString());
        }
        sb.append("\n");
        sb.append("Sorted locales: ");
        Locale[] sortedLocales = this.getLocales();
        if (sortedLocales != null) {
            sb.append(LocaleManager.stringValueOf(sortedLocales));
        }
        sb.append("\n");
        return sb.toString();
    }
}

