/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.support;

import org.apache.commons.lang.Validate;
import org.jasig.portal.UserProfile;
import org.jasig.portal.events.EventType;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.security.IPerson;

public abstract class ChannelLayoutPortalEvent
extends PortalEvent {
    private final UserProfile profile;
    private final IUserLayoutChannelDescription description;
    private final IUserLayoutNodeDescription parentNode;

    public ChannelLayoutPortalEvent(Object source, IPerson person, UserProfile profile, IUserLayoutChannelDescription description, IUserLayoutNodeDescription parentNode, EventType eventType) {
        super(source, person, eventType);
        Validate.notNull((Object)description, (String)"IUserLayoutChannelDescription can not be null");
        this.profile = profile;
        this.description = description;
        this.parentNode = parentNode;
    }

    public final UserProfile getProfile() {
        return this.profile;
    }

    public final IUserLayoutChannelDescription getChannelDescription() {
        return this.description;
    }

    public final IUserLayoutNodeDescription getParentDescription() {
        return this.parentNode;
    }

    public final String getTargetFolderId() {
        return this.parentNode != null ? this.parentNode.getId() : "ft1";
    }

    public void setTargetFolderId(String id) {
    }

    public final String getChannelDefinitionId() {
        return this.description.getChannelPublishId();
    }

    public void setChannelDefinitionId(String id) {
    }

    public final String getChannelSubscribeId() {
        return this.description.getChannelSubscribeId();
    }

    public void setChannelSubscribeId(String id) {
    }

    public final int getProfileId() {
        return this.profile.getProfileId();
    }

    public void setProfileId(int id) {
    }

    protected String getChannelDescriptionString() {
        IUserLayoutChannelDescription channelDescription = this.getChannelDescription();
        if (channelDescription == null) {
            return "[transient channel]";
        }
        return "[" + channelDescription.getName() + ", " + channelDescription.getChannelPublishId() + ", " + channelDescription.getChannelSubscribeId() + "]";
    }

    protected String getParentDescriptionString() {
        IUserLayoutNodeDescription parentDescription = this.getParentDescription();
        if (parentDescription == null) {
            return "[transient parent]";
        }
        return "[" + parentDescription.getId() + "," + parentDescription.getName() + "]";
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " for Channel " + this.getChannelDescriptionString() + " in layout " + this.getProfile().getLayoutId() + " under node " + this.getParentDescriptionString() + " for " + this.getDisplayName() + " at " + this.getTimestampAsDate();
    }
}

