/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.events.EventHandler;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.security.IPerson;

public abstract class AbstractLimitedSupportEventHandler
implements EventHandler {
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean supportGuest = true;
    private Set<String> supportedUserNames;
    private Set<String> ignoredUserNames;
    private Set<Class<? extends PortalEvent>> supportedEvents;
    private boolean explicitMatching = false;
    private boolean requireAll = true;

    @Override
    public final boolean supports(PortalEvent event) {
        IPerson person = event.getPerson();
        if (this.supportGuest || !person.isGuest()) {
            if (!this.requireAll) {
                return true;
            }
        } else if (this.requireAll) {
            return false;
        }
        String userName = person.getUserName();
        if (this.supportedUserNames == null || this.supportedUserNames.contains(userName)) {
            if (!this.requireAll) {
                return true;
            }
        } else if (this.requireAll) {
            return false;
        }
        if (this.ignoredUserNames == null || !this.ignoredUserNames.contains(userName)) {
            if (!this.requireAll) {
                return true;
            }
        } else if (this.requireAll) {
            return false;
        }
        if (this.supportedEvents == null) {
            return true;
        }
        Class<?> eventType = ((Object)((Object)event)).getClass();
        if (this.explicitMatching) {
            return this.supportedEvents.contains(eventType);
        }
        for (Class<? extends PortalEvent> includedType : this.supportedEvents) {
            if (!includedType.isAssignableFrom(eventType)) continue;
            return true;
        }
        return false;
    }

    public Collection<Class<? extends PortalEvent>> getSupportedEvents() {
        return this.supportedEvents;
    }

    public void setSupportedEvents(Collection<Class<? extends PortalEvent>> supportedEvents) {
        this.supportedEvents = supportedEvents == null ? null : new HashSet<Class<? extends PortalEvent>>(supportedEvents);
    }

    public boolean isExplicitMatching() {
        return this.explicitMatching;
    }

    public void setExplicitMatching(boolean explicitMatching) {
        this.explicitMatching = explicitMatching;
    }

    public Collection<String> getSupportedUserNames() {
        return this.supportedUserNames;
    }

    public void setSupportedUserNames(Collection<String> supportedUserNames) {
        this.supportedUserNames = supportedUserNames == null ? null : new HashSet<String>(supportedUserNames);
    }

    public Collection<String> getIgnoredUserNames() {
        return this.ignoredUserNames;
    }

    public void setIgnoredUserNames(Collection<String> ignoredUserNames) {
        this.ignoredUserNames = ignoredUserNames == null ? null : new HashSet<String>(ignoredUserNames);
    }

    public boolean isSupportGuest() {
        return this.supportGuest;
    }

    public void setSupportGuest(boolean supportGuest) {
        this.supportGuest = supportGuest;
    }

    public boolean isRequireAll() {
        return this.requireAll;
    }

    public void setRequireAll(boolean requireAll) {
        this.requireAll = requireAll;
    }
}

