/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.IEntityLockService;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.concurrency.locking.EntityLockImpl;
import org.jasig.portal.concurrency.locking.IEntityLockStore;
import org.jasig.portal.concurrency.locking.MemoryEntityLockStore;
import org.jasig.portal.concurrency.locking.RDBMEntityLockStore;
import org.jasig.portal.properties.PropertiesManager;

public class ReferenceEntityLockService
implements IEntityLockService {
    private static final Log log = LogFactory.getLog(ReferenceEntityLockService.class);
    private static IEntityLockService singleton = null;
    private IEntityLockStore lockStore = null;
    private boolean multiServer = false;
    private int defaultLockPeriod = 300;
    private int lockToleranceMillis = 5000;

    public ReferenceEntityLockService() throws LockingException {
        this.initialize();
    }

    @Override
    public void convert(IEntityLock lock, int newType) throws LockingException {
        this.convert(lock, newType, this.defaultLockPeriod);
    }

    @Override
    public void convert(IEntityLock lock, int newType, int newDuration) throws LockingException {
        if (lock.getLockType() == newType) {
            throw new LockingException("Could not convert " + lock + " : old and new lock TYPEs are the same.");
        }
        if (!this.isValidLockType(newType)) {
            throw new LockingException("Could not convert " + lock + " : lock TYPE " + newType + " is invalid.");
        }
        if (!this.isValid(lock)) {
            throw new LockingException("Could not convert " + lock + " : lock is invalid.");
        }
        if (newType == 1 && this.retrieveLocks(lock.getEntityType(), lock.getEntityKey(), null).length > 1) {
            throw new LockingException("Could not convert " + lock + " : another lock already exists.");
        }
        if (newType == 0) {
            // empty if block
        }
        Date newExpiration = this.getNewExpiration(newDuration);
        this.getLockStore().update(lock, newExpiration, new Integer(newType));
        ((EntityLockImpl)lock).setLockType(newType);
        ((EntityLockImpl)lock).setExpirationTime(newExpiration);
    }

    @Override
    public boolean existsInStore(IEntityLock lock) throws LockingException {
        Class entityType = lock.getEntityType();
        String key = lock.getEntityKey();
        Integer lockType = new Integer(lock.getLockType());
        Date expiration = lock.getExpirationTime();
        String owner = lock.getLockOwner();
        IEntityLock[] lockArray = this.getLockStore().find(entityType, key, lockType, expiration, owner);
        return lockArray.length > 0;
    }

    private int getDefaultLockPeriod() {
        return this.defaultLockPeriod;
    }

    private IEntityLockStore getLockStore() {
        return this.lockStore;
    }

    private int getLockToleranceMillis() {
        return this.lockToleranceMillis;
    }

    private Date getNewExpiration(int durationSecs) {
        return new Date(System.currentTimeMillis() + (long)(durationSecs * 1000));
    }

    private void initialize() throws LockingException {
        String eMsg = null;
        try {
            this.multiServer = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.concurrency.multiServer", false);
            this.lockStore = this.multiServer ? RDBMEntityLockStore.singleton() : MemoryEntityLockStore.singleton();
        }
        catch (Exception e) {
            eMsg = "ReferenceEntityLockingService.initialize(): Failed to instantiate entity lock store. " + e;
            log.error((Object)eMsg);
            throw new LockingException(eMsg);
        }
        try {
            int lockDuration = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.IEntityLockService.defaultLockDuration");
            this.setDefaultLockPeriod(lockDuration);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.multiServer) {
            try {
                int lockTolerance = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.clockTolerance");
                this.setLockToleranceMillis(lockTolerance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isLocked(Class entityType, String entityKey) throws LockingException {
        return this.isLocked(entityType, entityKey, null);
    }

    private boolean isLocked(Class entityType, String entityKey, Integer lockType) throws LockingException {
        IEntityLock[] locks = this.retrieveLocks(entityType, entityKey, lockType);
        return locks.length > 0;
    }

    private boolean isMultiServer() {
        return this.multiServer;
    }

    private boolean isUnexpired(IEntityLock lock) {
        return lock.getExpirationTime().getTime() > System.currentTimeMillis();
    }

    @Override
    public boolean isValid(IEntityLock lock) throws LockingException {
        return this.isUnexpired(lock) && this.existsInStore(lock);
    }

    private boolean isValidLockType(int lockType) {
        return lockType == 0 || lockType == 1;
    }

    @Override
    public IEntityLock newLock(Class entityType, String entityKey, int lockType, String owner) throws LockingException {
        return this.newLock(entityType, entityKey, lockType, owner, this.defaultLockPeriod);
    }

    @Override
    public IEntityLock newLock(Class entityType, String entityKey, int lockType, String owner, int durationSecs) throws LockingException {
        int expirationSecs = durationSecs;
        Date expires = this.getNewExpiration(expirationSecs);
        EntityLockImpl newLock = new EntityLockImpl(entityType, entityKey, lockType, expires, owner, this);
        IEntityLock[] locks = this.retrieveLocks(entityType, entityKey, null);
        if (lockType == 1) {
            if (locks.length > 0) {
                throw new LockingException("Could not create lock: entity already locked.");
            }
            this.getLockStore().add(newLock);
            locks = this.retrieveLocks(entityType, entityKey, null);
            if (locks.length > 1) {
                this.release(newLock);
                throw new LockingException("Could not create lock: entity already locked.");
            }
        } else {
            for (int i = 0; i < locks.length; ++i) {
                if (locks[i].getLockType() == 1) {
                    throw new LockingException("Could not create lock: entity already write locked.");
                }
                if (!locks[i].equals(newLock)) continue;
                expires = this.getNewExpiration(++expirationSecs);
                newLock = new EntityLockImpl(entityType, entityKey, lockType, expires, owner, this);
            }
            this.getLockStore().add(newLock);
        }
        return newLock;
    }

    @Override
    public IEntityLock newLock(EntityIdentifier entityID, int lockType, String owner) throws LockingException {
        return this.newLock(entityID.getType(), entityID.getKey(), lockType, owner, this.defaultLockPeriod);
    }

    @Override
    public IEntityLock newLock(EntityIdentifier entityID, int lockType, String owner, int durationSecs) throws LockingException {
        return this.newLock(entityID.getType(), entityID.getKey(), lockType, owner, durationSecs);
    }

    @Override
    public void release(IEntityLock lock) throws LockingException {
        this.getLockStore().delete(lock);
        ((EntityLockImpl)lock).setExpirationTime(new Date(0L));
    }

    @Override
    public void renew(IEntityLock lock) throws LockingException {
        this.renew(lock, this.defaultLockPeriod);
    }

    @Override
    public void renew(IEntityLock lock, int duration) throws LockingException {
        if (!this.isValid(lock)) {
            throw new LockingException("Could not renew " + lock + " : lock is invalid.");
        }
        Date newExpiration = this.getNewExpiration(duration);
        this.getLockStore().update(lock, newExpiration);
        ((EntityLockImpl)lock).setExpirationTime(newExpiration);
    }

    private IEntityLock[] retrieveLocks(Class entityType, String entityKey, Integer lockType) throws LockingException {
        Date expiration = this.multiServer ? new Date(System.currentTimeMillis() - (long)this.getLockToleranceMillis()) : new Date();
        return this.getLockStore().findUnexpired(expiration, entityType, entityKey, lockType, null);
    }

    private void setDefaultLockPeriod(int newDefaultLockPeriod) {
        this.defaultLockPeriod = newDefaultLockPeriod;
    }

    private void setLockToleranceMillis(int newLockToleranceMillis) {
        this.lockToleranceMillis = newLockToleranceMillis;
    }

    private void setMultiServer(boolean newMultiServer) {
        this.multiServer = newMultiServer;
    }

    public static synchronized IEntityLockService singleton() throws LockingException {
        if (singleton == null) {
            singleton = new ReferenceEntityLockService();
        }
        return singleton;
    }
}

