/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.locking;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.concurrency.locking.EntityLockImpl;
import org.jasig.portal.concurrency.locking.IEntityLockStore;

public class RDBMEntityLockStore
implements IEntityLockStore {
    private static final Log log = LogFactory.getLog(RDBMEntityLockStore.class);
    private static IEntityLockStore singleton;
    private static String LOCK_TABLE;
    private static String ENTITY_TYPE_COLUMN;
    private static String ENTITY_KEY_COLUMN;
    private static String EXPIRATION_TIME_COLUMN;
    private static String LOCK_OWNER_COLUMN;
    private static String LOCK_TYPE_COLUMN;
    private static String EQ;
    private static String GT;
    private static String LT;
    private static String QUOTE;
    private static String allLockColumns;
    private static String addSql;
    private static String deleteLockSql;
    private static String updateSql;
    private static boolean timestampHasMillis;

    public RDBMEntityLockStore() throws LockingException {
        this.initialize();
    }

    @Override
    public void add(IEntityLock lock) throws LockingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            this.primDeleteExpired(new Date(), lock.getEntityType(), lock.getEntityKey(), conn);
            this.primAdd(lock, conn);
        }
        catch (SQLException sqle) {
            throw new LockingException("Problem creating " + lock, (Throwable)sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    @Override
    public void delete(IEntityLock lock) throws LockingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            this.primDelete(lock, conn);
        }
        catch (SQLException sqle) {
            throw new LockingException("Problem deleting " + lock, (Throwable)sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() throws LockingException {
        Connection conn = null;
        Statement stmnt = null;
        try {
            String sql = "DELETE FROM " + LOCK_TABLE;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMEntityLockStore.deleteAll(): " + sql));
            }
            conn = RDBMServices.getConnection();
            try {
                stmnt = conn.createStatement();
                int rc = stmnt.executeUpdate(sql);
                if (log.isDebugEnabled()) {
                    String msg = "Deleted " + rc + " locks.";
                    log.debug((Object)("RDBMEntityLockStore.deleteAll(): " + msg));
                }
            }
            finally {
                if (stmnt != null) {
                    stmnt.close();
                }
            }
        }
        catch (SQLException sqle) {
            try {
                throw new LockingException("Problem deleting locks", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                RDBMServices.releaseConnection(conn);
                throw throwable;
            }
        }
        RDBMServices.releaseConnection(conn);
    }

    @Override
    public void deleteExpired(Date expiration) throws LockingException {
        this.deleteExpired(expiration, null, null);
    }

    public void deleteExpired(Date expiration, Class entityType, String entityKey) throws LockingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            this.primDeleteExpired(expiration, entityType, entityKey, conn);
        }
        catch (SQLException sqle) {
            throw new LockingException("Problem deleting expired locks", (Throwable)sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    public void deleteExpired(IEntityLock lock) throws LockingException {
        this.deleteExpired(new Date(), lock.getEntityType(), lock.getEntityKey());
    }

    @Override
    public IEntityLock[] find(Class entityType, String entityKey, Integer lockType, Date expiration, String lockOwner) throws LockingException {
        return this.select(entityType, entityKey, lockType, expiration, lockOwner);
    }

    @Override
    public IEntityLock[] findUnexpired(Date expiration, Class entityType, String entityKey, Integer lockType, String lockOwner) throws LockingException {
        Timestamp ts = new Timestamp(expiration.getTime());
        return this.selectUnexpired(ts, entityType, entityKey, lockType, lockOwner);
    }

    private static String getAddSql() {
        if (addSql == null) {
            addSql = "INSERT INTO " + LOCK_TABLE + "(" + RDBMEntityLockStore.getAllLockColumns() + ") VALUES (?, ?, ?, ?, ?)";
        }
        return addSql;
    }

    private static String getAllLockColumns() {
        if (allLockColumns == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(ENTITY_TYPE_COLUMN);
            buff.append(", ");
            buff.append(ENTITY_KEY_COLUMN);
            buff.append(", ");
            buff.append(LOCK_TYPE_COLUMN);
            buff.append(", ");
            buff.append(EXPIRATION_TIME_COLUMN);
            buff.append(", ");
            buff.append(LOCK_OWNER_COLUMN);
            allLockColumns = buff.toString();
        }
        return allLockColumns;
    }

    private static String getDeleteLockSql() {
        if (deleteLockSql == null) {
            deleteLockSql = "DELETE FROM " + LOCK_TABLE + " WHERE " + ENTITY_TYPE_COLUMN + EQ + "?" + " AND " + ENTITY_KEY_COLUMN + EQ + "?" + " AND " + EXPIRATION_TIME_COLUMN + EQ + "?" + " AND " + LOCK_TYPE_COLUMN + EQ + "?" + " AND " + LOCK_OWNER_COLUMN + EQ + "?";
        }
        return deleteLockSql;
    }

    private static String getSelectSql() {
        return "SELECT " + RDBMEntityLockStore.getAllLockColumns() + " FROM " + LOCK_TABLE;
    }

    private static String getUpdateSql() {
        if (updateSql == null) {
            updateSql = "UPDATE " + LOCK_TABLE + " SET " + EXPIRATION_TIME_COLUMN + EQ + "?, " + LOCK_TYPE_COLUMN + EQ + "?" + " WHERE " + ENTITY_TYPE_COLUMN + EQ + "?" + " AND " + ENTITY_KEY_COLUMN + EQ + "?" + " AND " + LOCK_OWNER_COLUMN + EQ + "?" + " AND " + EXPIRATION_TIME_COLUMN + EQ + "?" + " AND " + LOCK_TYPE_COLUMN + EQ + "?";
        }
        return updateSql;
    }

    private void initialize() throws LockingException {
        Date expiration = new Date(System.currentTimeMillis() - 3600000L);
        this.deleteExpired(expiration, null, null);
    }

    private IEntityLock instanceFromResultSet(ResultSet rs) throws SQLException, LockingException {
        Integer entityTypeID = new Integer(rs.getInt(1));
        Class entityType = EntityTypes.getEntityType(entityTypeID);
        String key = rs.getString(2);
        int lockType = rs.getInt(3);
        Timestamp ts = rs.getTimestamp(4);
        String lockOwner = rs.getString(5);
        return this.newInstance(entityType, key, lockType, ts, lockOwner);
    }

    private IEntityLock newInstance(Class entityType, String entityKey, int lockType, Date expirationTime, String lockOwner) throws LockingException {
        return new EntityLockImpl(entityType, entityKey, lockType, expirationTime, lockOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primAdd(IEntityLock lock, Connection conn) throws SQLException, LockingException {
        Integer typeID = EntityTypes.getEntityTypeID(lock.getEntityType());
        String key = lock.getEntityKey();
        int lockType = lock.getLockType();
        Timestamp ts = new Timestamp(lock.getExpirationTime().getTime());
        String owner = lock.getLockOwner();
        try {
            PreparedStatement ps = conn.prepareStatement(RDBMEntityLockStore.getAddSql());
            try {
                int rc;
                ps.setInt(1, typeID);
                ps.setString(2, key);
                ps.setInt(3, lockType);
                ps.setTimestamp(4, ts);
                ps.setString(5, owner);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityLockStore.primAdd(): " + ps));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    String errString = "Problem adding " + lock;
                    log.error((Object)errString);
                    throw new LockingException(errString);
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primDelete(IEntityLock lock, Connection conn) throws LockingException, SQLException {
        Integer typeID = EntityTypes.getEntityTypeID(lock.getEntityType());
        String key = lock.getEntityKey();
        int lockType = lock.getLockType();
        Timestamp ts = new Timestamp(lock.getExpirationTime().getTime());
        String owner = lock.getLockOwner();
        try {
            PreparedStatement ps = conn.prepareStatement(RDBMEntityLockStore.getDeleteLockSql());
            try {
                ps.setInt(1, typeID);
                ps.setString(2, key);
                ps.setTimestamp(3, ts);
                ps.setInt(4, lockType);
                ps.setString(5, owner);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityLockStore.primDelete(): " + ps));
                }
                int rc = ps.executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityLockStore.primDelete(): deleted " + rc + " lock(s)."));
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw sqle;
        }
    }

    private void primDeleteExpired(Date expiration, Class entityType, String entityKey, Connection conn) throws LockingException, SQLException {
        Statement stmnt = null;
        Timestamp ts = new Timestamp(expiration.getTime());
        StringBuffer buff = new StringBuffer(100);
        buff.append("DELETE FROM " + LOCK_TABLE + " WHERE " + EXPIRATION_TIME_COLUMN + LT);
        buff.append(RDBMEntityLockStore.printTimestamp(ts));
        if (entityType != null) {
            Integer typeID = EntityTypes.getEntityTypeID(entityType);
            buff.append(" AND " + ENTITY_TYPE_COLUMN + EQ + typeID);
        }
        if (entityKey != null) {
            buff.append(" AND " + ENTITY_KEY_COLUMN + EQ + RDBMEntityLockStore.sqlQuote(entityKey));
        }
        String sql = buff.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("RDBMEntityLockStore.deleteExpired(): " + sql));
        }
        try {
            stmnt = conn.createStatement();
            int rc = stmnt.executeUpdate(sql);
            if (log.isDebugEnabled()) {
                String msg = "Deleted " + rc + " expired locks.";
                log.debug((Object)("RDBMEntityLockStore.deleteExpired(): " + msg));
            }
        }
        catch (SQLException sqle) {
            throw new LockingException("Problem deleting expired locks", (Throwable)sqle);
        }
        finally {
            if (stmnt != null) {
                stmnt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntityLock[] primSelect(String sql) throws LockingException {
        Connection conn = null;
        Statement stmnt = null;
        ResultSet rs = null;
        ArrayList<IEntityLock> locks = new ArrayList<IEntityLock>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("RDBMEntityLockStore.primSelect(): " + sql));
        }
        try {
            conn = RDBMServices.getConnection();
            stmnt = conn.createStatement();
            try {
                rs = stmnt.executeQuery(sql);
                try {
                    while (rs.next()) {
                        locks.add(this.instanceFromResultSet(rs));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw new LockingException("Problem retrieving EntityLocks", (Throwable)sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return locks.toArray(new IEntityLock[locks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primUpdate(IEntityLock lock, Date newExpiration, Integer newType, Connection conn) throws SQLException, LockingException {
        Integer typeID = EntityTypes.getEntityTypeID(lock.getEntityType());
        String key = lock.getEntityKey();
        int oldLockType = lock.getLockType();
        int newLockType = newType == null ? oldLockType : newType;
        Timestamp oldTs = new Timestamp(lock.getExpirationTime().getTime());
        Timestamp newTs = new Timestamp(newExpiration.getTime());
        String owner = lock.getLockOwner();
        try {
            PreparedStatement ps = conn.prepareStatement(RDBMEntityLockStore.getUpdateSql());
            try {
                int rc;
                ps.setTimestamp(1, newTs);
                ps.setInt(2, newLockType);
                ps.setInt(3, typeID);
                ps.setString(4, key);
                ps.setString(5, owner);
                ps.setTimestamp(6, oldTs);
                ps.setInt(7, oldLockType);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMEntityLockStore.primUpdate(): " + ps));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    String errString = "Problem updating " + lock;
                    log.error((Object)errString);
                    throw new LockingException(errString);
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw sqle;
        }
    }

    private IEntityLock[] select(Class entityType, String entityKey, Integer lockType, Date expiration, String lockOwner) throws LockingException {
        StringBuffer sqlQuery = new StringBuffer(RDBMEntityLockStore.getSelectSql() + " WHERE 1 = 1");
        if (entityType != null) {
            Integer typeID = EntityTypes.getEntityTypeID(entityType);
            sqlQuery.append(" AND " + ENTITY_TYPE_COLUMN + EQ + typeID);
        }
        if (entityKey != null) {
            sqlQuery.append(" AND " + ENTITY_KEY_COLUMN + EQ + RDBMEntityLockStore.sqlQuote(entityKey));
        }
        if (lockType != null) {
            sqlQuery.append(" AND " + LOCK_TYPE_COLUMN + EQ + lockType);
        }
        if (expiration != null) {
            Timestamp ts = new Timestamp(expiration.getTime());
            sqlQuery.append(" AND " + EXPIRATION_TIME_COLUMN + EQ + RDBMEntityLockStore.printTimestamp(ts));
        }
        if (lockOwner != null) {
            sqlQuery.append(" AND " + LOCK_OWNER_COLUMN + EQ + RDBMEntityLockStore.sqlQuote(lockOwner));
        }
        return this.primSelect(sqlQuery.toString());
    }

    private IEntityLock[] selectUnexpired(Timestamp ts, Class entityType, String entityKey, Integer lockType, String lockOwner) throws LockingException {
        StringBuffer sqlQuery = new StringBuffer(RDBMEntityLockStore.getSelectSql());
        sqlQuery.append(" WHERE " + EXPIRATION_TIME_COLUMN + GT + RDBMEntityLockStore.printTimestamp(ts));
        if (entityType != null) {
            Integer typeID = EntityTypes.getEntityTypeID(entityType);
            sqlQuery.append(" AND " + ENTITY_TYPE_COLUMN + EQ + typeID);
        }
        if (entityKey != null) {
            sqlQuery.append(" AND " + ENTITY_KEY_COLUMN + EQ + RDBMEntityLockStore.sqlQuote(entityKey));
        }
        if (lockType != null) {
            sqlQuery.append(" AND " + LOCK_TYPE_COLUMN + EQ + lockType);
        }
        if (lockOwner != null) {
            sqlQuery.append(" AND " + LOCK_OWNER_COLUMN + EQ + RDBMEntityLockStore.sqlQuote(lockOwner));
        }
        return this.primSelect(sqlQuery.toString());
    }

    public static synchronized IEntityLockStore singleton() throws LockingException {
        if (singleton == null) {
            singleton = new RDBMEntityLockStore();
        }
        return singleton;
    }

    private static String sqlQuote(Object o) {
        return QUOTE + o + QUOTE;
    }

    @Override
    public void update(IEntityLock lock, Date newExpiration) throws LockingException {
        this.update(lock, newExpiration, null);
    }

    @Override
    public void update(IEntityLock lock, Date newExpiration, Integer newLockType) throws LockingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            if (newLockType != null) {
                this.primDeleteExpired(new Date(), lock.getEntityType(), lock.getEntityKey(), conn);
            }
            this.primUpdate(lock, newExpiration, newLockType, conn);
        }
        catch (SQLException sqle) {
            throw new LockingException("Problem updating " + lock, (Throwable)sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    private static long getTimestampMillis(Timestamp ts) {
        if (timestampHasMillis) {
            return ts.getTime();
        }
        return ts.getTime() + (long)(ts.getNanos() / 1000000);
    }

    private static String printTimestamp(Timestamp ts) {
        return RDBMServices.getDbMetaData().sqlTimeStamp(RDBMEntityLockStore.getTimestampMillis(ts));
    }

    static {
        LOCK_TABLE = "UP_ENTITY_LOCK";
        ENTITY_TYPE_COLUMN = "ENTITY_TYPE_ID";
        ENTITY_KEY_COLUMN = "ENTITY_KEY";
        EXPIRATION_TIME_COLUMN = "EXPIRATION_TIME";
        LOCK_OWNER_COLUMN = "LOCK_OWNER";
        LOCK_TYPE_COLUMN = "LOCK_TYPE";
        EQ = " = ";
        GT = " > ";
        LT = " < ";
        QUOTE = "'";
        Date testDate = new Date();
        Timestamp testTimestamp = new Timestamp(testDate.getTime());
        timestampHasMillis = testDate.getTime() == testTimestamp.getTime();
    }
}

