/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.Validate;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityCache;
import org.jasig.portal.concurrency.caching.AbstractEntityCachingService;
import org.jasig.portal.concurrency.caching.MapBackedEntityCache;
import org.jasig.portal.utils.cache.CacheFactory;
import org.jasig.portal.utils.threading.MapCachingDoubleCheckedCreator;
import org.springframework.beans.factory.annotation.Required;

public class CacheFactoryEntityCachingService
extends AbstractEntityCachingService {
    private final EntityCacheCreator entityCacheCreator = new EntityCacheCreator();
    private CacheFactory cacheFactory;

    public CacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    @Required
    public void setCacheFactory(CacheFactory cacheFactory) {
        Validate.notNull((Object)cacheFactory, (String)"cacheFactory can not be null");
        this.cacheFactory = cacheFactory;
    }

    @Override
    protected IEntityCache getCache(Class<? extends IBasicEntity> entityType) throws CachingException {
        return (IEntityCache)this.entityCacheCreator.get(entityType);
    }

    private class EntityCacheCreator
    extends MapCachingDoubleCheckedCreator<String, IEntityCache> {
        public EntityCacheCreator() {
            super(new ReferenceMap(0, 1));
        }

        @Override
        protected String getKey(Object ... args) {
            Class entityType = (Class)args[0];
            return entityType.getName();
        }

        @Override
        protected IEntityCache createInternal(String typeName, Object ... args) {
            Map<Serializable, IBasicEntity> cacheMap = CacheFactoryEntityCachingService.this.cacheFactory.getCache(typeName);
            Class entityType = (Class)args[0];
            return new MapBackedEntityCache(cacheMap, entityType);
        }
    }
}

