/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.webproxy;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.channels.webproxy.CWebProxyURLFilter;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.LocalConnectionContext;
import org.jasig.portal.utils.AbsoluteURLFilter;
import org.jasig.portal.utils.CookieCutter;
import org.jasig.portal.utils.DTDResolver;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.jasig.portal.utils.cache.CacheFactoryLocator;
import org.jasig.portal.utils.uri.IUriScrutinizer;
import org.jasig.portal.utils.uri.PrefixUriScrutinizer;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;
import org.xml.sax.ContentHandler;

@Deprecated
public class CWebProxy
implements IChannel,
ICacheable,
IMimeResponse {
    private static final Log log = LogFactory.getLog(CWebProxy.class);
    private static final Log accessLog = LogFactory.getLog((String)(CWebProxy.class + ".access"));
    public static final String ALLOW_URI_PREFIXES_PARAM = "cw_allow_uri_prefixes";
    public static final String BLOCK_URI_PREFIXES_PARAM = "cw_block_uri_prefixes";
    public static final String RESTRICT_STATIC_XMLURI_PREFIXES_PARAM = "cw_restrict_xmlUri_inStaticData";
    private static final MediaManager MEDIAMANAGER = MediaManager.getMediaManager();
    static final String systemCacheId = "org.jasig.portal.channels.webproxy.CWebProxy";
    static PrintWriter devNull;
    protected ChannelState chanState;
    private static Map<Serializable, Object> contentCache;
    private static final ThreadLocal perThreadTidy;

    @Override
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        String connContext;
        String allowUriPrefixesParam = sd.getParameter(ALLOW_URI_PREFIXES_PARAM);
        String denyUriPrefixesParam = sd.getParameter(BLOCK_URI_PREFIXES_PARAM);
        PrefixUriScrutinizer uriScrutinizer = PrefixUriScrutinizer.instanceFromParameters(allowUriPrefixesParam, denyUriPrefixesParam);
        ChannelState state = new ChannelState(uriScrutinizer);
        String scrutinizeXmlUriAsStaticDataString = sd.getParameter(RESTRICT_STATIC_XMLURI_PREFIXES_PARAM);
        boolean scrutinizeXmlUriAsStaticData = "true".equals(scrutinizeXmlUriAsStaticDataString);
        String xmlUriParam = sd.getParameter("cw_xml");
        if (scrutinizeXmlUriAsStaticData) {
            state.setXmlUri(xmlUriParam);
        } else {
            state.xmlUri = xmlUriParam;
        }
        state.iperson = sd.getPerson();
        state.publishId = sd.getChannelPublishId();
        state.person = sd.getParameter("cw_person");
        String personAllow = sd.getParameter("cw_personAllow");
        if (personAllow != null && !personAllow.trim().equals("")) {
            state.personAllow = personAllow;
        }
        if (state.personAllow != null && !state.personAllow.trim().equals("!*")) {
            state.personAllow_set = new HashSet();
            StringTokenizer st = new StringTokenizer(state.personAllow, ",");
            if (st != null) {
                while (st.hasMoreElements()) {
                    String pName = st.nextToken();
                    if (pName == null || (pName = pName.trim()).equals("")) continue;
                    state.personAllow_set.add(pName);
                }
            }
        }
        state.sslUri = sd.getParameter("cw_ssl");
        state.xslTitle = sd.getParameter("cw_xslTitle");
        state.xslUri = sd.getParameter("cw_xsl");
        state.fullxmlUri = sd.getParameter("cw_xml");
        state.passThrough = sd.getParameter("cw_passThrough");
        state.tidy = sd.getParameter("cw_tidy");
        state.infoUri = sd.getParameter("cw_info");
        state.helpUri = sd.getParameter("cw_help");
        state.editUri = sd.getParameter("cw_edit");
        state.key = state.xmlUri;
        String cacheMode = sd.getParameter("cw_cacheDefaultMode");
        if (cacheMode != null && !cacheMode.trim().equals("")) {
            state.cacheDefaultMode = cacheMode;
        }
        if ((cacheMode = sd.getParameter("cw_cacheMode")) != null && !cacheMode.trim().equals("")) {
            state.cacheMode = cacheMode;
        } else {
            state.cacheMode = state.cacheDefaultMode;
        }
        String cacheTimeout = sd.getParameter("cw_cacheDefaultTimeout");
        if (cacheTimeout != null && !cacheTimeout.trim().equals("")) {
            state.cacheDefaultTimeout = Long.parseLong(cacheTimeout);
        }
        if ((cacheTimeout = sd.getParameter("cw_cacheTimeout")) != null && !cacheTimeout.trim().equals("")) {
            state.cacheTimeout = Long.parseLong(cacheTimeout);
        } else {
            state.cacheTimeout = state.cacheDefaultTimeout;
        }
        cacheMode = sd.getParameter("cw_cacheGlobalMode");
        if (cacheMode != null) {
            if ("true".equals(cacheMode = cacheMode.trim().toLowerCase())) {
                state.cacheGlobalMode = true;
            } else if ("false".equals(cacheMode)) {
                state.cacheGlobalMode = false;
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Invalid channel [" + sd.getChannelPublishId() + ":" + state.fullxmlUri + "] parameter cw_cacheGlobalMode value [" + cacheMode + "]. Valid values are true|false. Defaulting to [" + state.cacheGlobalMode + "]."));
            }
        }
        if ((connContext = sd.getParameter("upc_localConnContext")) != null && !connContext.trim().equals("")) {
            try {
                state.localConnContext = (LocalConnectionContext)Class.forName(connContext).newInstance();
                state.localConnContext.init(sd);
            }
            catch (Exception e) {
                log.error((Object)"CWebProxy: Cannot initialize LocalConnectionContext: ", (Throwable)e);
            }
        }
        this.chanState = state;
    }

    protected static final String appendReqParams(String xmlUri, String reqParameters) {
        if (reqParameters == null) {
            return xmlUri;
        }
        int fragmentIndex = xmlUri.indexOf(35);
        StringBuffer sb = new StringBuffer();
        sb.append(fragmentIndex >= 0 ? xmlUri.substring(0, fragmentIndex) : xmlUri);
        sb.append(xmlUri.indexOf(63) == -1 ? "?" : "&");
        sb.append(reqParameters);
        if (fragmentIndex >= 0) {
            sb.append(xmlUri.substring(fragmentIndex));
        }
        return sb.toString();
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) {
        ChannelState state = this.chanState;
        if (state == null) {
            log.debug((Object)"CWebProxy:setRuntimeData() : no entry in state");
        } else {
            state.runtimeData = rd;
            if (rd.isEmpty() && state.refresh != -1) {
                if (state.buttonxmlUri != null) {
                    state.key = state.buttonxmlUri;
                    state.fullxmlUri = state.buttonxmlUri;
                    state.refresh = 0;
                } else {
                    if (state.refresh == 0) {
                        state.key = state.fullxmlUri;
                    }
                    state.fullxmlUri = state.xmlUri;
                    if (state.person != null && state.personAllow_set != null) {
                        StringBuffer newXML = new StringBuffer();
                        String appendchar = "";
                        this.addPersonAttributeParameters(state, newXML, appendchar);
                        state.reqParameters = newXML.toString();
                        if (!state.runtimeData.getHttpRequestMethod().equals("POST")) {
                            if (state.reqParameters != null && !state.reqParameters.trim().equals("")) {
                                appendchar = state.xmlUri.indexOf(63) == -1 ? "?" : "&";
                                state.fullxmlUri = state.fullxmlUri + appendchar + state.reqParameters;
                            }
                            state.reqParameters = null;
                        }
                    }
                    state.refresh = 1;
                }
            } else {
                String cacheMode;
                String cacheTimeout;
                String passThrough;
                String xslTitle;
                state.refresh = 0;
                String xmlUri = state.runtimeData.getParameter("cw_xml");
                if (xmlUri != null) {
                    state.setXmlUri(xmlUri);
                    state.buttonxmlUri = null;
                }
                if ((xslTitle = state.runtimeData.getParameter("cw_xslTitle")) != null) {
                    state.xslTitle = xslTitle;
                }
                if ((passThrough = state.runtimeData.getParameter("cw_passThrough")) != null) {
                    state.passThrough = passThrough;
                }
                if ((cacheTimeout = state.runtimeData.getParameter("cw_cacheDefaultTimeout")) != null) {
                    state.cacheDefaultTimeout = Long.parseLong(cacheTimeout);
                }
                if ((cacheTimeout = state.runtimeData.getParameter("cw_cacheTimeout")) != null) {
                    state.cacheTimeout = Long.parseLong(cacheTimeout);
                } else {
                    state.cacheTimeout = state.cacheDefaultTimeout;
                }
                String cacheDefaultMode = state.runtimeData.getParameter("cw_cacheDefaultMode");
                if (cacheDefaultMode != null) {
                    state.cacheDefaultMode = cacheDefaultMode;
                }
                if ((cacheMode = state.runtimeData.getParameter("cw_cacheMode")) != null) {
                    state.cacheMode = cacheMode;
                } else {
                    state.cacheMode = state.cacheDefaultMode;
                }
                String reset = state.runtimeData.getParameter("cw_reset");
                if (reset != null && reset.equalsIgnoreCase("return")) {
                    state.buttonxmlUri = null;
                }
                if (state.buttonxmlUri != null) {
                    state.fullxmlUri = state.buttonxmlUri;
                } else {
                    StringBuffer newXML = new StringBuffer();
                    String appendchar = "";
                    if (state.person != null && state.personAllow_set != null) {
                        this.addPersonAttributeParameters(state, newXML, appendchar);
                    }
                    if (state.passThrough != null && !state.passThrough.equalsIgnoreCase("none") && (state.passThrough.equalsIgnoreCase("all") || state.passThrough.equalsIgnoreCase("application") || rd.getParameter("cw_inChannelLink") != null)) {
                        String keywords = rd.getKeywords();
                        if (keywords != null) {
                            if (appendchar.equals("&")) {
                                newXML.append("&keywords=" + keywords);
                            } else {
                                newXML.append(keywords);
                            }
                        } else {
                            Enumeration e = rd.getParameterNames();
                            if (e != null) {
                                while (e.hasMoreElements()) {
                                    String pName = (String)e.nextElement();
                                    if (pName.startsWith("cw_") || pName.startsWith("upc_") || pName.trim().equals("")) continue;
                                    String[] value_array = rd.getParameterValues(pName);
                                    int i = 0;
                                    while (i < value_array.length) {
                                        newXML.append(appendchar);
                                        appendchar = "&";
                                        newXML.append(pName);
                                        newXML.append("=");
                                        try {
                                            newXML.append(URLEncoder.encode(value_array[i++].trim(), "UTF-8"));
                                        }
                                        catch (UnsupportedEncodingException e1) {
                                            throw new RuntimeException(e1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    state.reqParameters = newXML.toString();
                    state.fullxmlUri = state.xmlUri;
                    if (!state.runtimeData.getHttpRequestMethod().equals("POST") && state.reqParameters != null && !state.reqParameters.trim().equals("")) {
                        state.fullxmlUri = CWebProxy.appendReqParams(state.xmlUri, state.reqParameters);
                    }
                }
                if (!state.runtimeData.getHttpRequestMethod().equals("POST")) {
                    state.key = state.fullxmlUri;
                } else {
                    state.key = String.valueOf(new Date().getTime());
                }
            }
        }
    }

    public void addPersonAttributeParameters(ChannelState state, StringBuffer newXML, String appendchar) {
        StringTokenizer st = new StringTokenizer(state.person, ",");
        if (st != null) {
            while (st.hasMoreElements()) {
                String pName = st.nextToken();
                if (pName == null || pName.trim().equals("")) continue;
                if (state.personAllow.trim().equals("*") || state.personAllow_set.contains(pName)) {
                    newXML.append(appendchar);
                    appendchar = "&";
                    newXML.append(pName);
                    newXML.append("=");
                    String pVal = (String)state.iperson.getAttribute(pName);
                    if (pVal == null) continue;
                    try {
                        newXML.append(URLEncoder.encode(pVal, "UTF-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("CWebProxy: request to pass " + pName + " denied."));
            }
        }
    }

    @Override
    public void receiveEvent(PortalEvent ev) {
        ChannelState state = this.chanState;
        if (state == null) {
            log.debug((Object)"CWebProxy:receiveEvent() : no entry in state");
        } else {
            int evnum = ev.getEventNumber();
            switch (evnum) {
                case 3: {
                    if (state.editUri == null) break;
                    state.buttonxmlUri = state.editUri;
                    break;
                }
                case 4: {
                    if (state.helpUri == null) break;
                    state.buttonxmlUri = state.helpUri;
                    break;
                }
                case 5: {
                    if (state.infoUri == null) break;
                    state.buttonxmlUri = state.infoUri;
                    break;
                }
            }
        }
    }

    @Override
    public ChannelRuntimeProperties getRuntimeProperties() {
        ChannelRuntimeProperties rp = new ChannelRuntimeProperties();
        if (this.chanState == null) {
            rp.setWillRender(false);
            log.debug((Object)"CWebProxy:getRuntimeProperties() : no entry in state");
        }
        return rp;
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        ChannelState state = this.chanState;
        if (state == null) {
            log.debug((Object)"CWebProxy:renderXML() : no entry in state");
        } else {
            String accept;
            boolean cacheit;
            Document xml = null;
            String tidiedXml = null;
            Object o = null;
            boolean bl = cacheit = state.cacheGlobalMode && !"none".equalsIgnoreCase(state.cacheMode) && !"post".equalsIgnoreCase(state.runtimeData.getHttpRequestMethod()) && state.fullxmlUri.indexOf(63) < 0 && state.localConnContext == null;
            if (cacheit) {
                o = state.getCacheContent(state.fullxmlUri);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Global cache hit [" + (o != null) + "] for channel: " + state.fullxmlUri));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Global cache not enabled for channel: " + state.fullxmlUri));
            }
            if (o == null) {
                try {
                    if (state.tidy != null && state.tidy.equals("on")) {
                        tidiedXml = this.getTidiedXml(state.fullxmlUri, state);
                        o = tidiedXml;
                    } else {
                        xml = this.getXml(state.fullxmlUri, state);
                        o = xml;
                    }
                }
                catch (Exception e) {
                    throw new GeneralRenderingException("Problem retrieving contents of " + state.fullxmlUri + ".  Please restart channel. ", e, false, true);
                }
                if (cacheit) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Global cache store for channel: " + state.fullxmlUri));
                    }
                    state.setCacheContent(state.fullxmlUri, o);
                }
            } else if (o instanceof String) {
                tidiedXml = (String)o;
            } else {
                xml = (Document)o;
            }
            state.runtimeData.put("baseActionURL", state.runtimeData.getBaseActionURL());
            state.runtimeData.put("downloadActionURL", state.runtimeData.getBaseWorkerURL("download"));
            if (state.xmlUri != null) {
                state.runtimeData.put("cw_xml", state.xmlUri);
            }
            if (state.sslUri != null) {
                state.runtimeData.put("cw_ssl", state.sslUri);
            }
            if (state.xslTitle != null) {
                state.runtimeData.put("cw_xslTitle", state.xslTitle);
            }
            if (state.xslUri != null) {
                state.runtimeData.put("cw_xsl", state.xslUri);
            }
            if (state.passThrough != null) {
                state.runtimeData.put("cw_passThrough", state.passThrough);
            }
            if (state.tidy != null) {
                state.runtimeData.put("cw_tidy", state.tidy);
            }
            if (state.infoUri != null) {
                state.runtimeData.put("cw_info", state.infoUri);
            }
            if (state.helpUri != null) {
                state.runtimeData.put("cw_help", state.helpUri);
            }
            if (state.editUri != null) {
                state.runtimeData.put("cw_edit", state.editUri);
            }
            if (state.person != null) {
                state.runtimeData.put("cw_person", state.person);
            }
            if (state.personAllow != null) {
                state.runtimeData.put("cw_personAllow", state.personAllow);
            }
            XSLT xslt = XSLT.getTransformer(this, state.runtimeData.getLocales());
            if (tidiedXml != null) {
                xslt.setXML(tidiedXml);
            } else {
                xslt.setXML(xml);
            }
            if (state.xslUri != null && !state.xslUri.trim().equals("")) {
                xslt.setXSL(state.xslUri);
            } else {
                xslt.setXSL(state.sslUri, state.xslTitle, state.runtimeData.getBrowserInfo());
            }
            MediaManager mm = MEDIAMANAGER;
            String media = mm.getMedia(state.runtimeData.getBrowserInfo());
            String mimeType = mm.getReturnMimeType(media);
            if ("unknown".equals(mimeType) && (accept = state.runtimeData.getBrowserInfo().getHeader("accept")) != null && accept.indexOf("text/html") != -1) {
                mimeType = "text/html";
            }
            CWebProxyURLFilter filter2 = CWebProxyURLFilter.newCWebProxyURLFilter(mimeType, state.runtimeData, out);
            if (state.xmlUri != null && state.xmlUri.indexOf("://") != -1) {
                AbsoluteURLFilter filter1 = AbsoluteURLFilter.newAbsoluteURLFilter(mimeType, state.xmlUri, filter2);
                xslt.setTarget(filter1);
            } else {
                xslt.setTarget(filter2);
            }
            xslt.setStylesheetParameters(state.runtimeData);
            xslt.transform();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getXml(String uri, ChannelState state) throws Exception {
        long start = System.currentTimeMillis();
        int status = 0;
        Document doc = null;
        try {
            URLConnection urlConnect = this.getConnection(uri, state);
            if (urlConnect instanceof HttpURLConnection) {
                status = ((HttpURLConnection)urlConnect).getResponseCode();
            }
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            DTDResolver dtdResolver = new DTDResolver();
            docBuilder.setEntityResolver(dtdResolver);
            InputStream is = null;
            try {
                is = urlConnect.getInputStream();
                doc = docBuilder.parse(is);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            long elapsedTimeMillis = System.currentTimeMillis() - start;
            this.logAccess(uri, state, status, elapsedTimeMillis);
        }
        return doc;
    }

    private void logAccess(String uri, ChannelState state, int status, long elapsedTimeMillis) {
        int index = uri.indexOf("?");
        if (index >= 0) {
            uri = uri.substring(0, index);
        }
        uri = uri.trim().replaceAll(" ", "%20");
        accessLog.info((Object)("logAccess: " + state.publishId + " " + state.iperson.getAttribute("username") + " " + uri + " " + status + " " + (float)elapsedTimeMillis / 1000.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTidiedXml(String uri, ChannelState state) throws Exception {
        long start = System.currentTimeMillis();
        String tidiedXml = null;
        int status = 0;
        try {
            int i;
            URLConnection urlConnect = this.getConnection(uri, state);
            if (urlConnect instanceof HttpURLConnection) {
                status = ((HttpURLConnection)urlConnect).getResponseCode();
            }
            String encoding = null;
            String ct = urlConnect.getContentType();
            if (ct != null && (i = ct.indexOf("charset=")) != -1) {
                encoding = ct.substring(i + 8).trim();
                if ((i = encoding.indexOf(";")) != -1) {
                    encoding = encoding.substring(0, i).trim();
                }
                if (encoding.indexOf("\"") != -1) {
                    encoding = encoding.substring(1, encoding.length() + 1);
                }
            }
            Tidy tidy = (Tidy)perThreadTidy.get();
            if (encoding != null) {
                if (encoding.toLowerCase().equals("iso-8859-1")) {
                    tidy.setCharEncoding(2);
                } else if (encoding.toLowerCase().equals("iso-2022-jp")) {
                    tidy.setCharEncoding(4);
                } else {
                    tidy.setCharEncoding(3);
                }
            } else {
                tidy.setCharEncoding(3);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
            BufferedOutputStream out = new BufferedOutputStream(stream);
            tidy.parse(urlConnect.getInputStream(), (OutputStream)out);
            tidiedXml = stream.toString();
            stream.close();
            out.close();
            if (tidy.getParseErrors() > 0) {
                throw new GeneralRenderingException("Unable to convert input document to XHTML");
            }
        }
        finally {
            long elapsedTimeMillis = System.currentTimeMillis() - start;
            this.logAccess(uri, state, status, elapsedTimeMillis);
        }
        return tidiedXml;
    }

    private URLConnection getConnection(String uri, ChannelState state) throws Exception {
        uri = uri.trim().replaceAll(" ", "%20");
        URL url = state.localConnContext != null ? ResourceLoader.getResourceAsURL(this.getClass(), state.localConnContext.getDescriptor(uri, state.runtimeData)) : ResourceLoader.getResourceAsURL(this.getClass(), uri);
        String domain = url.getHost().trim();
        String path = url.getPath();
        if (path.indexOf("/") != -1 && path.lastIndexOf("/") != 0) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        String port = Integer.toString(url.getPort());
        URLConnection urlConnect = url.openConnection();
        String protocol = url.getProtocol();
        if ((protocol.equals("http") || protocol.equals("https")) && domain != null && path != null) {
            HttpURLConnection httpUrlConnect = (HttpURLConnection)urlConnect;
            httpUrlConnect.setInstanceFollowRedirects(false);
            if (state.cookieCutter.cookiesExist()) {
                state.cookieCutter.sendCookieHeader(httpUrlConnect, domain, path, port);
            }
            if (state.runtimeData.getHttpRequestMethod().equals("POST") && state.reqParameters != null && !state.reqParameters.trim().equals("")) {
                httpUrlConnect.setRequestMethod("POST");
                httpUrlConnect.setAllowUserInteraction(false);
                httpUrlConnect.setDoOutput(true);
            }
            if (state.localConnContext != null) {
                try {
                    state.localConnContext.sendLocalData(httpUrlConnect, state.runtimeData);
                }
                catch (Exception e) {
                    log.error((Object)("CWebProxy: Unable to send data through " + state.runtimeData.getParameter("upc_localConnContext")), (Throwable)e);
                }
            }
            if (state.runtimeData.getHttpRequestMethod().equals("POST") && state.reqParameters != null && !state.reqParameters.trim().equals("")) {
                PrintWriter post = new PrintWriter(httpUrlConnect.getOutputStream());
                post.print(state.reqParameters);
                post.flush();
                post.close();
                state.reqParameters = null;
            }
            state.cookieCutter.storeCookieHeader(httpUrlConnect, domain, path, port);
            int status = httpUrlConnect.getResponseCode();
            String location = httpUrlConnect.getHeaderField("Location");
            switch (status) {
                case 404: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 404: Not Found");
                }
                case 403: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 403: Forbidden");
                }
                case 500: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 500: Internal Server Error");
                }
                case 204: {
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 204: No Content");
                }
                case 302: {
                    httpUrlConnect.disconnect();
                    httpUrlConnect = (HttpURLConnection)this.getConnection(location, state);
                    break;
                }
                case 303: {
                    httpUrlConnect.disconnect();
                    httpUrlConnect = (HttpURLConnection)this.getConnection(location, state);
                    break;
                }
                case 301: {
                    if (state.runtimeData.getHttpRequestMethod().equals("GET")) {
                        httpUrlConnect.disconnect();
                        httpUrlConnect = (HttpURLConnection)this.getConnection(location, state);
                        break;
                    }
                    throw new ResourceMissingException(httpUrlConnect.getURL().toExternalForm(), "", "HTTP Status-Code 301: POST Redirection currently not supported");
                }
            }
            return httpUrlConnect;
        }
        return urlConnect;
    }

    @Override
    public ChannelCacheKey generateKey() {
        ChannelState state = this.chanState;
        if (state == null) {
            log.debug((Object)"CWebProxy:generateKey() : no entry in state");
            return null;
        }
        if (state.cacheMode.equalsIgnoreCase("none")) {
            return null;
        }
        ChannelCacheKey k = new ChannelCacheKey();
        StringBuffer sbKey = new StringBuffer(1024);
        k.setKeyScope(0);
        sbKey.append("sslUri:").append(state.sslUri).append(", ");
        String xslUriForKey = state.xslUri;
        try {
            if (xslUriForKey == null) {
                String sslUri = ResourceLoader.getResourceAsURLString(this.getClass(), state.sslUri);
                xslUriForKey = XSLT.getStylesheetURI(sslUri, state.runtimeData.getBrowserInfo());
            }
        }
        catch (Exception e) {
            xslUriForKey = "Not attainable: " + e;
        }
        sbKey.append("xslUri:").append(xslUriForKey).append(", ");
        sbKey.append("key:").append(state.key).append(", ");
        sbKey.append("passThrough:").append(state.passThrough).append(", ");
        sbKey.append("tidy:").append(state.tidy).append(", ");
        sbKey.append("person:").append(state.person);
        k.setKey(sbKey.toString());
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    static PrintWriter getErrout() throws FileNotFoundException {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            return new PrintWriter(new FileOutputStream("nul"));
        }
        return new PrintWriter(new FileOutputStream("/dev/null"));
    }

    @Override
    public boolean isCacheValid(Object validity) {
        if (!(validity instanceof Long)) {
            return false;
        }
        ChannelState state = this.chanState;
        if (state == null) {
            log.debug((Object)"CWebProxy:isCacheValid() : no entry in state");
            return false;
        }
        if (System.currentTimeMillis() - (Long)validity > state.cacheTimeout * 1000L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Framework cache timeout: " + state.fullxmlUri));
            }
            return false;
        }
        if (state.getCacheContentLoaded() > (Long)validity) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Global cache timeout: >cacheContentLoaded: " + state.getCacheContentLoaded() + " >validity: " + validity + " >currentTime: " + System.currentTimeMillis() + " >url: " + state.fullxmlUri));
            }
            return false;
        }
        return true;
    }

    @Override
    public String getContentType() {
        return this.chanState.connHolder.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream rs = this.chanState.connHolder.getInputStream();
        this.chanState.connHolder = null;
        return rs;
    }

    @Override
    public void downloadData(OutputStream out) throws IOException {
        throw new IOException("CWebProxy: downloadData method not supported - use getInputStream only");
    }

    @Override
    public String getName() {
        return "proxyDL";
    }

    @Override
    public Map getHeaders() {
        ChannelState state = this.chanState;
        try {
            state.connHolder = this.getConnection(state.fullxmlUri, state);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        HashMap<String, String> rhdrs = new HashMap<String, String>();
        int i = 0;
        while (state.connHolder.getHeaderFieldKey(i) != null) {
            rhdrs.put(state.connHolder.getHeaderFieldKey(i), state.connHolder.getHeaderField(i));
            ++i;
        }
        return rhdrs;
    }

    @Override
    public void reportDownloadError(Exception e) {
        log.error((Object)e.getMessage(), (Throwable)e);
    }

    static {
        try {
            devNull = CWebProxy.getErrout();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        contentCache = CacheFactoryLocator.getCacheFactory().getCache("org.jasig.portal.channels.CONTENT_CACHE");
        perThreadTidy = new ThreadLocal(){

            protected Object initialValue() {
                Tidy tidy = new Tidy();
                tidy.setXHTML(true);
                tidy.setDocType("omit");
                tidy.setQuiet(true);
                tidy.setShowWarnings(false);
                tidy.setNumEntities(true);
                tidy.setWord2000(true);
                tidy.setErrout(devNull);
                return tidy;
            }
        };
    }

    protected class ChannelState {
        private String publishId;
        private IPerson iperson;
        private String person;
        private String personAllow;
        private HashSet personAllow_set;
        private String fullxmlUri;
        private String buttonxmlUri;
        private String xmlUri;
        private String key;
        private String passThrough;
        private String tidy;
        private String sslUri;
        private String xslTitle;
        private String xslUri;
        private String infoUri;
        private String helpUri;
        private String editUri;
        private String cacheDefaultMode;
        private String cacheMode;
        private String reqParameters;
        private long cacheDefaultTimeout;
        private long cacheTimeout;
        private ChannelRuntimeData runtimeData;
        private CookieCutter cookieCutter;
        private URLConnection connHolder;
        private LocalConnectionContext localConnContext;
        private int refresh;
        private boolean cacheGlobalMode;
        private long cacheContentLoaded;
        private final IUriScrutinizer uriScrutinizer;

        public ChannelState(IUriScrutinizer uriScrutinizerArg) {
            if (uriScrutinizerArg == null) {
                throw new IllegalArgumentException("Cannot instantiate CWebProxy ChannelState with a null URI srutinizer.");
            }
            this.uriScrutinizer = uriScrutinizerArg;
            this.sslUri = null;
            this.passThrough = null;
            this.key = null;
            this.xmlUri = null;
            this.buttonxmlUri = null;
            this.fullxmlUri = null;
            this.tidy = null;
            this.editUri = null;
            this.helpUri = null;
            this.infoUri = null;
            this.xslUri = null;
            this.xslTitle = null;
            this.cacheMode = null;
            this.iperson = null;
            this.publishId = null;
            this.refresh = -1;
            this.cacheTimeout = this.cacheDefaultTimeout = PropertiesManager.getPropertyAsLong("org.jasig.portal.channels.webproxy.CWebProxy.cache_default_timeout");
            this.cacheMode = this.cacheDefaultMode = PropertiesManager.getProperty("org.jasig.portal.channels.webproxy.CWebProxy.cache_default_mode");
            this.personAllow = PropertiesManager.getProperty("org.jasig.portal.channels.webproxy.CWebProxy.person_allow");
            this.cacheGlobalMode = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.channels.webproxy.CWebProxy.cache_global_mode", false);
            this.runtimeData = null;
            this.cookieCutter = new CookieCutter();
            this.localConnContext = null;
        }

        public void setXmlUri(String uriArg) {
            if (uriArg != null && !"".equals(uriArg)) {
                try {
                    URL resourceUrl = ResourceLoader.getResourceAsURL(this.getClass(), uriArg);
                    uriArg = resourceUrl.toExternalForm();
                }
                catch (ResourceMissingException rme) {
                    IllegalArgumentException iae = new IllegalArgumentException("Resource [" + uriArg + "] missing.");
                    iae.initCause(rme);
                    throw iae;
                }
                try {
                    this.uriScrutinizer.scrutinize(new URI(uriArg));
                    this.xmlUri = uriArg;
                }
                catch (URISyntaxException e) {
                    IllegalArgumentException iae = new IllegalArgumentException("Value [" + uriArg + "]had bad URI syntax.");
                    iae.initCause(e);
                    throw iae;
                }
            }
        }

        public void setXmlUriNotRestricted(String uri) {
            this.xmlUri = uri;
        }

        public synchronized void setCacheContent(String key, Object data) {
            contentCache.put(key, data);
            this.cacheContentLoaded = System.currentTimeMillis() - 2000L;
        }

        public synchronized Object getCacheContent(String key) {
            return contentCache.get(key);
        }

        public synchronized long getCacheContentLoaded() {
            return this.cacheContentLoaded;
        }

        public IPerson getIPerson() {
            return this.iperson;
        }
    }
}

