/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.portlet;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.channels.portlet.ISpringPortletChannel;
import org.jasig.portal.channels.portlet.InconsistentPortletModelException;
import org.jasig.portal.channels.portlet.PortletDispatchException;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.rendering.PortletRenderResult;
import org.jasig.portal.portlet.url.IPortletRequestParameterManager;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.portlet.url.RequestType;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.url.processing.RequestParameterProcessingIncompleteException;
import org.springframework.beans.factory.annotation.Required;

@Deprecated
public class SpringPortletChannelImpl
implements ISpringPortletChannel {
    protected static final String PORTLET_WINDOW_ID_PARAM = SpringPortletChannelImpl.class.getName() + ".portletWindowId";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletRequestParameterManager portletRequestParameterManager;
    private IPortletRenderer portletRenderer;

    public IPortletRenderer getPortletRenderer() {
        return this.portletRenderer;
    }

    public void setPortletRenderer(IPortletRenderer portletRenderer) {
        this.portletRenderer = portletRenderer;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        Validate.notNull((Object)portletDefinitionRegistry);
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        Validate.notNull((Object)portletWindowRegistry);
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletRequestParameterManager getPortletRequestParameterManager() {
        return this.portletRequestParameterManager;
    }

    @Required
    public void setPortletRequestParameterManager(IPortletRequestParameterManager portletRequestParameterManager) {
        Validate.notNull((Object)portletRequestParameterManager);
        this.portletRequestParameterManager = portletRequestParameterManager;
    }

    protected String getWindowInstanceId(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures) {
        return this.getWindowInstanceId(channelStaticData, portalControlStructures, null);
    }

    protected String getWindowInstanceId(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData) {
        return channelStaticData.getChannelSubscribeId();
    }

    protected void setPortletWidnowId(ChannelStaticData channelStaticData, IPortletWindowId portletWindowId) {
        channelStaticData.put(PORTLET_WINDOW_ID_PARAM, portletWindowId);
    }

    protected IPortletWindowId getPortletWindowId(ChannelStaticData channelStaticData) {
        return this.getPortletWindowId(channelStaticData, null, null);
    }

    protected IPortletWindowId getPortletWindowId(ChannelStaticData channelStaticData, ChannelRuntimeData channelRuntimeData, PortalControlStructures pcs) {
        HttpServletRequest httpServletRequest;
        IPortletWindowId targetedPortletWindowId;
        if (channelRuntimeData != null && pcs != null && channelRuntimeData.isTargeted() && (targetedPortletWindowId = this.portletRequestParameterManager.getTargetedPortletWindowId(httpServletRequest = pcs.getHttpServletRequest())) != null) {
            String channelSubscribeId = channelStaticData.getChannelSubscribeId();
            IPerson person = channelStaticData.getPerson();
            IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(channelSubscribeId, person.getID());
            IPortletEntity targetParentPortletEntity = this.portletWindowRegistry.getParentPortletEntity(httpServletRequest, targetedPortletWindowId);
            if (portletEntity.getPortletEntityId().equals(targetParentPortletEntity.getPortletEntityId())) {
                return targetedPortletWindowId;
            }
            this.logger.warn((Object)("Portlet window " + targetedPortletWindowId + " as target but window ID is not for the correct entity " + portletEntity));
        }
        return (IPortletWindowId)channelStaticData.get(PORTLET_WINDOW_ID_PARAM);
    }

    @Override
    public void initSession(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures) {
        String channelPublishId = channelStaticData.getChannelPublishId();
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(Integer.parseInt(channelPublishId));
        if (portletDefinition == null) {
            throw new InconsistentPortletModelException("No IPortletDefinition exists for channelPublishId: " + channelPublishId, null);
        }
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        String channelSubscribeId = channelStaticData.getChannelSubscribeId();
        IPerson person = channelStaticData.getPerson();
        IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(portletDefinitionId, channelSubscribeId, person.getID());
        HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
        HttpServletResponse httpServletResponse = portalControlStructures.getHttpServletResponse();
        IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData);
        try {
            portletWindowId = this.portletRenderer.doInit(portletEntity, portletWindowId, httpServletRequest, httpServletResponse);
            this.setPortletWidnowId(channelStaticData, portletWindowId);
        }
        catch (PortletDispatchException e) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
            throw new PortletDispatchException("Exception executing portlet initialization: " + this.getChannelLogInfo(channelStaticData, portletWindow), portletWindow, e);
        }
    }

    @Override
    public void action(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData) {
        IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData, channelRuntimeData, portalControlStructures);
        HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
        HttpServletResponse httpServletResponse = portalControlStructures.getHttpServletResponse();
        try {
            this.portletRenderer.doAction(portletWindowId, httpServletRequest, httpServletResponse);
        }
        catch (PortletDispatchException e) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
            throw new PortletDispatchException("Exception portlet ActionRequest: " + this.getChannelLogInfo(channelStaticData, portletWindow), portletWindow, e);
        }
    }

    @Override
    public ChannelCacheKey generateKey(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData) {
        HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
        IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData, channelRuntimeData, portalControlStructures);
        LinkedHashMap<String, String> key = new LinkedHashMap<String, String>();
        key.put(IPortletWindowId.class.getName(), portletWindowId.getStringId());
        key.put("remoteUser", httpServletRequest.getRemoteUser());
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            key.put("HttpSession.id", session.getId());
        }
        ChannelCacheKey cacheKey = new ChannelCacheKey();
        cacheKey.setKeyScope(0);
        cacheKey.setKey(((Object)key).toString());
        cacheKey.setKeyValidity(System.currentTimeMillis());
        return cacheKey;
    }

    @Override
    public boolean isCacheValid(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData, Object validity) {
        long now;
        PortletDD portletDescriptor;
        if (channelRuntimeData.isTargeted()) {
            return false;
        }
        HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
        IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData, channelRuntimeData, portalControlStructures);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        PortletUrl portletUrl = this.portletRequestParameterManager.getPortletRequestInfo(httpServletRequest, portletWindowId);
        if (portletUrl != null) {
            return false;
        }
        try {
            portletDescriptor = this.getPortletDD(httpServletRequest, portletWindowId);
        }
        catch (PortletContainerException pce) {
            this.logger.warn((Object)("Could not retrieve PortletDD for portlet window '" + portletWindowId + "' to determine caching configuration. Marking content cache invalid and continuing."), (Throwable)pce);
            return false;
        }
        if (portletDescriptor == null) {
            this.logger.warn((Object)("Could not retrieve PortletDD for portlet window '" + portletWindow + "' to determine caching configuration. Marking content cache invalid and continuing."));
            return false;
        }
        int descriptorExpirationCache = portletDescriptor.getExpirationCache();
        if (descriptorExpirationCache == Integer.MIN_VALUE) {
            return false;
        }
        Integer windowExpirationCache = portletWindow.getExpirationCache();
        int expirationCache = windowExpirationCache != null ? windowExpirationCache : descriptorExpirationCache;
        if (expirationCache == 0) {
            return false;
        }
        if (expirationCache == -1) {
            return true;
        }
        if (validity == null) {
            return false;
        }
        long lastRenderTime = (Long)validity;
        return lastRenderTime + (long)(expirationCache * 1000) >= (now = System.currentTimeMillis());
    }

    protected PortletDD getPortletDD(HttpServletRequest httpServletRequest, IPortletWindowId portletWindowId) throws PortletContainerException {
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(httpServletRequest, portletWindowId);
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        return this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinition.getPortletDefinitionId());
    }

    @Override
    public void render(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData, PrintWriter printWriter) {
        PortletRenderResult renderResult;
        HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
        HttpServletResponse httpServletResponse = portalControlStructures.getHttpServletResponse();
        IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData, channelRuntimeData, portalControlStructures);
        try {
            renderResult = this.portletRenderer.doRender(portletWindowId, httpServletRequest, httpServletResponse, printWriter);
        }
        catch (PortletDispatchException e) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
            throw new PortletDispatchException("Exception executing portlet RenderRequest: " + this.getChannelLogInfo(channelStaticData, portletWindow), portletWindow, e);
        }
        channelRuntimeData.put(IPortletAdaptor.ATTRIBUTE__PORTLET_TITLE, renderResult);
    }

    @Override
    public String getTitle(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData) {
        PortletRenderResult renderResult = (PortletRenderResult)channelRuntimeData.get(IPortletAdaptor.ATTRIBUTE__PORTLET_TITLE);
        if (renderResult != null) {
            return renderResult.getTitle();
        }
        return null;
    }

    @Override
    public void portalEvent(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, PortalEvent portalEvent) {
        switch (portalEvent.getEventNumber()) {
            case 2: {
                String channelSubscribeId = channelStaticData.getChannelSubscribeId();
                IPerson person = channelStaticData.getPerson();
                IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(channelSubscribeId, person.getID());
                this.portletEntityRegistry.deletePortletEntity(portletEntity);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                PortletUrl portletUrl;
                HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
                IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData);
                IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
                IPortletWindowId targetedPortletWindowId = null;
                try {
                    targetedPortletWindowId = this.portletRequestParameterManager.getTargetedPortletWindowId(httpServletRequest);
                }
                catch (RequestParameterProcessingIncompleteException rppie) {
                    // empty catch block
                }
                if (targetedPortletWindowId == null || !portletWindowId.equals(targetedPortletWindowId)) {
                    portletUrl = this.portletRequestParameterManager.getPortletRequestInfo(httpServletRequest, portletWindowId);
                    if (portletUrl == null) {
                        portletUrl = new PortletUrl(portletWindowId);
                    }
                    portletUrl.setRequestType(RequestType.RENDER);
                    this.portletRequestParameterManager.setAdditionalPortletUrl(httpServletRequest, portletUrl);
                } else {
                    portletUrl = this.portletRequestParameterManager.getPortletRequestInfo(httpServletRequest, targetedPortletWindowId);
                }
                switch (portalEvent.getEventNumber()) {
                    case 6: {
                        break;
                    }
                    case 7: {
                        portletUrl.setWindowState(WindowState.MINIMIZED);
                        break;
                    }
                    case 9: {
                        portletUrl.setWindowState(WindowState.NORMAL);
                        break;
                    }
                    case 8: {
                        portletUrl.setWindowState(WindowState.MAXIMIZED);
                        break;
                    }
                    case 3: {
                        portletUrl.setPortletMode(PortletMode.EDIT);
                        break;
                    }
                    case 4: {
                        portletUrl.setPortletMode(PortletMode.HELP);
                        break;
                    }
                    case 5: {
                        portletUrl.setPortletMode(IPortletAdaptor.ABOUT);
                    }
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.logger.info((Object)("Don't know how to handle event of type: " + portalEvent.getEventName() + "(" + portalEvent.getEventNumber() + ")"));
            }
        }
    }

    @Override
    public void prepareForRefresh(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData) {
        HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
        IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData, channelRuntimeData, portalControlStructures);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        portletWindow.setRequestParameters(null);
    }

    @Override
    public void prepareForReset(ChannelStaticData channelStaticData, PortalControlStructures portalControlStructures, ChannelRuntimeData channelRuntimeData) {
        HttpServletRequest httpServletRequest = portalControlStructures.getHttpServletRequest();
        HttpServletResponse httpServletResponse = portalControlStructures.getHttpServletResponse();
        IPortletWindowId portletWindowId = this.getPortletWindowId(channelStaticData, channelRuntimeData, portalControlStructures);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        portletWindow.setPortletMode(PortletMode.VIEW);
        portletWindow.setRequestParameters(null);
        portletWindow.setExpirationCache(null);
        try {
            this.portletRenderer.doReset(portletWindowId, httpServletRequest, httpServletResponse);
        }
        catch (PortletDispatchException e) {
            portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
            throw new PortletDispatchException("Exception executing portlet reset: " + this.getChannelLogInfo(channelStaticData, portletWindow), portletWindow, e);
        }
    }

    protected String getChannelLogInfo(ChannelStaticData channelStaticData, IPortletWindow portletWindow) {
        IPerson person = channelStaticData.getPerson();
        return "[channelPublishId=" + channelStaticData.getChannelPublishId() + ", " + "channelSubscribeId=" + channelStaticData.getChannelSubscribeId() + ", " + "portletApplicationId=" + portletWindow.getContextPath() + ", " + "portletName=" + portletWindow.getPortletName() + ", " + "user=" + person.getAttribute("username") + "]";
    }
}

