/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.permissionsmanager;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IPermissible;
import org.jasig.portal.channels.permissionsmanager.PermissionsSessionData;
import org.jasig.portal.channels.permissionsmanager.RDBMPermissibleRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.utils.DocumentFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public class PermissionsXML {
    private static final Log log = LogFactory.getLog(PermissionsXML.class);

    protected PermissionsXML() {
    }

    public static Document getViewDoc(PermissionsSessionData session) {
        return PermissionsXML.getViewDoc(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getViewDoc(PermissionsSessionData session, boolean forceRefresh) {
        PermissionsSessionData permissionsSessionData = session;
        synchronized (permissionsSessionData) {
            if (session.XML == null || forceRefresh) {
                Document rDoc;
                session.XML = rDoc = DocumentFactory.getNewDocument();
                session.owners = new IPermissible[0];
                try {
                    Element root = rDoc.createElement("CPermissionsManager");
                    rDoc.appendChild(root);
                    if (session.staticData.get("prmOwners") != null) {
                        log.debug((Object)"PermissionsXML.getViewDoc(): using specified owners");
                        session.owners = (IPermissible[])session.staticData.get("prmOwners");
                    } else {
                        log.debug((Object)"PermissionsXML.getViewDoc(): using DB owners");
                        session.owners = RDBMPermissibleRegistry.getAllPermissible();
                    }
                    for (int i = 0; i < session.owners.length; ++i) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("PermissionsXML.getViewDoc(): Configuring element for owner " + session.owners[i].getOwnerName()));
                        }
                        Element owner = rDoc.createElement("owner");
                        owner.setAttribute("name", session.owners[i].getOwnerName());
                        owner.setAttribute("token", session.owners[i].getOwnerToken());
                        owner.setAttribute("ipermissible", session.owners[i].getClass().getName());
                        String[] activities = session.owners[i].getActivityTokens();
                        for (int j = 0; j < activities.length; ++j) {
                            Element act = rDoc.createElement("activity");
                            act.setAttribute("token", activities[j]);
                            act.setAttribute("name", session.owners[i].getActivityName(activities[j]));
                            owner.appendChild(act);
                        }
                        String[] targets = session.owners[i].getTargetTokens();
                        for (int k = 0; k < targets.length; ++k) {
                            PermissionsXML.addTargetToOwnerElement(session.owners[i], owner, targets[k]);
                        }
                        root.appendChild(owner);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error getting the view doc for session " + session), (Throwable)e);
                }
            }
        }
        return session.XML;
    }

    public static Element addTargetToOwnerElement(IPermissible owner, Element ownerEl, String target) {
        Element tgt = ownerEl.getOwnerDocument().createElement("target");
        tgt.setAttribute("token", target);
        tgt.setAttribute("name", owner.getTargetName(target));
        ownerEl.appendChild(tgt);
        return tgt;
    }

    public static void setSelected(PermissionsSessionData session, String ipermissible, String type, String token, boolean selected) {
        Element owner;
        if (log.isDebugEnabled()) {
            log.debug((Object)("PermissionsXML.setSelected(): processing " + ipermissible + " / " + type + " / " + token + " / " + selected));
        }
        Element s = owner = PermissionsXML.getOwner(session, ipermissible);
        String otoken = owner.getAttribute("token");
        if (!type.equals("owner")) {
            int i;
            NodeList nl = owner.getElementsByTagName(type);
            boolean found = false;
            for (i = 0; i < nl.getLength(); ++i) {
                Element x = (Element)nl.item(i);
                if (!x.getAttribute("token").equals(token)) continue;
                s = x;
                found = true;
                break;
            }
            if (!found && type.equals("target")) {
                for (i = 0; i < session.owners.length; ++i) {
                    if (!session.owners[i].getOwnerToken().equals(otoken)) continue;
                    s = PermissionsXML.addTargetToOwnerElement(session.owners[i], owner, token);
                    break;
                }
            }
        }
        String value = "false";
        if (selected) {
            value = "true";
        }
        s.setAttribute("selected", value);
    }

    public static void populatePrincipals(PermissionsSessionData session) {
        if (session.principals != null) {
            Document rDoc = session.XML == null ? PermissionsXML.getViewDoc(session) : session.XML;
            Element root = rDoc.getDocumentElement();
            IPermissible[] owners = session.staticData.get("prmOwners") != null ? (IPermissible[])session.staticData.get("prmOwners") : RDBMPermissibleRegistry.getAllPermissible();
            ArrayList<String> ownerKeys = new ArrayList<String>();
            for (int x = 0; x < owners.length; ++x) {
                ownerKeys.add(owners[x].getOwnerToken());
            }
            IAuthorizationPrincipal[] aps = session.principals;
            for (int m = 0; m < aps.length; ++m) {
                try {
                    Element ppl = rDoc.createElement("principal");
                    ppl.setAttribute("token", aps[m].getPrincipalString());
                    ppl.setAttribute("type", aps[m].getType().getName());
                    String name = aps[m].getKey();
                    try {
                        name = EntityNameFinderService.instance().getNameFinder(aps[m].getType()).getName(name);
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    ppl.setAttribute("name", name);
                    IPermission[] pms = aps[m].getAllPermissions();
                    for (int n = 0; n < pms.length; ++n) {
                        if (!ownerKeys.contains(pms[n].getOwner())) continue;
                        Element perm = rDoc.createElement("permission");
                        perm.setAttribute("owner", pms[n].getOwner());
                        perm.setAttribute("principal", pms[n].getPrincipal());
                        perm.setAttribute("activity", pms[n].getActivity());
                        perm.setAttribute("type", pms[n].getType());
                        perm.setAttribute("target", pms[n].getTarget());
                        if (pms[n].getEffective() != null) {
                            perm.setAttribute("effective", pms[n].getEffective().toString());
                        }
                        if (pms[n].getExpires() != null) {
                            perm.setAttribute("expires", pms[n].getExpires().toString());
                        }
                        ppl.appendChild(perm);
                    }
                    root.appendChild(ppl);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public static void autoSelectSingleChoice(PermissionsSessionData session, String tagname) {
        boolean allsingle = true;
        Element docRoot = PermissionsXML.getViewDoc(session).getDocumentElement();
        NodeList nl = docRoot.getElementsByTagName("owner");
        for (int l = 0; l < nl.getLength(); ++l) {
            Element o = (Element)nl.item(l);
            if (o.getAttribute("selected") == null || !o.getAttribute("selected").equals("true")) continue;
            NodeList cl = o.getElementsByTagName(tagname);
            if (cl.getLength() == 1) {
                ((Element)cl.item(0)).setAttribute("selected", "true");
                continue;
            }
            allsingle = false;
        }
        if (allsingle) {
            if (tagname.equals("activity")) {
                session.gotActivities = true;
            }
            if (tagname.equals("target")) {
                session.gotTargets = true;
            }
        }
    }

    public static String[] getSelectedTargets(PermissionsSessionData session, Element owner) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PermissionsXML.getSelectedTargets(): processing for " + owner.getAttribute("name")));
        }
        ArrayList<String> targets = new ArrayList<String>();
        Element o = owner;
        if (o != null) {
            NodeList tl = o.getElementsByTagName("target");
            for (int i = 0; i < tl.getLength(); ++i) {
                Element target = (Element)tl.item(i);
                if (target.getAttribute("selected") == null || !target.getAttribute("selected").equals("true")) continue;
                targets.add(target.getAttribute("token"));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("PermissionsXML.getSelectedTargets(): adding " + target.getAttribute("token")));
            }
        }
        return targets.toArray(new String[0]);
    }

    public static String[] getSelectedActivities(PermissionsSessionData session, Element owner) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PermissionsXML.getSelectedActivities(): processing for " + owner.getAttribute("name")));
        }
        ArrayList<String> activities = new ArrayList<String>();
        Element o = owner;
        if (o != null) {
            NodeList al = o.getElementsByTagName("activity");
            for (int i = 0; i < al.getLength(); ++i) {
                Element activity = (Element)al.item(i);
                if (activity.getAttribute("selected") == null || !activity.getAttribute("selected").equals("true")) continue;
                activities.add(activity.getAttribute("token"));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("PermissionsXML.getSelectedActivities(): adding " + activity.getAttribute("token")));
            }
        }
        return activities.toArray(new String[0]);
    }

    public static Element[] getSelectedOwners(PermissionsSessionData session) {
        ArrayList<Element> owners = new ArrayList<Element>();
        Document doc = PermissionsXML.getViewDoc(session);
        NodeList ol = doc.getElementsByTagName("owner");
        for (int i = 0; i < ol.getLength(); ++i) {
            Element owner = (Element)ol.item(i);
            if (owner.getAttribute("selected") == null || !owner.getAttribute("selected").equals("true")) continue;
            owners.add(owner);
        }
        return owners.toArray(new Element[0]);
    }

    public static Element getOwner(PermissionsSessionData session, String ipermissible) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PermissionsXML.getOwner(): looking for owner of class " + ipermissible));
        }
        Document doc = PermissionsXML.getViewDoc(session);
        Element ro = null;
        NodeList ol = doc.getElementsByTagName("owner");
        for (int i = 0; i < ol.getLength(); ++i) {
            Element o = (Element)ol.item(i);
            if (!o.getAttribute("ipermissible").equals(ipermissible)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("PermissionsXML.getOwner(): found owner of class " + ipermissible + " and token " + o.getAttribute("token")));
            }
            ro = o;
            break;
        }
        return ro;
    }
}

