/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.jsp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.channels.jsp.DeploymentSpec;
import org.jasig.portal.properties.PropertiesManager;

@Deprecated
public class Deployer {
    private static final Log LOG = LogFactory.getLog(Deployer.class);
    public static final String CLASSES_DEPLOY_DIR_PROP = "org.jasig.portal.channels.jsp.Deployer.context.relative.classesPath";
    public static final String JSP_DEPLOY_DIR_PROP = "org.jasig.portal.channels.jsp.Deployer.context.relative.jspPath";
    private String mCarFilePath;
    private String mClassFilePath;
    private String mClassName;
    private boolean mDeploy;
    private boolean mPurgeOldResources;
    private boolean mDeployedAsCar;
    private static String cClassesDirPath = null;
    private static String cJspDirPath = null;
    private File mCarFile = null;

    void deployResources(String classname) throws PortalException {
        this.mClassName = classname;
        this.determineDeploymentNeeds();
        if (this.mDeploy) {
            this.extractNewResources();
        }
    }

    private void extractNewResources() throws PortalException {
        this.getClassesPath();
        this.getJspPath();
        JarFile jar = this.getCar();
        ArrayList<String> resources = new ArrayList<String>();
        this.purgePreviousResourcesForCar();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry z = entries.nextElement();
            String resource = z.getName();
            if (!resource.endsWith(".jsp") && !resource.endsWith(".jspf") && !resource.endsWith(".jsf") && !resource.endsWith(".class") && !resource.endsWith(".properties")) continue;
            this.extractResource(z, jar);
            resources.add(resource);
        }
        DeploymentSpec.getInstance().addDeploymentFor(this.mCarFilePath, resources);
    }

    private void purgePreviousResourcesForCar() throws PortalException {
        List oldResources = DeploymentSpec.getInstance().removeEntriesFor(this.mCarFilePath);
        if (this.mPurgeOldResources) {
            for (String resource : oldResources) {
                String filePath = this.mClassFilePath + "/" + resource;
                File theFile = new File(filePath);
                if (!theFile.exists()) continue;
                theFile.delete();
            }
        }
    }

    private void extractResource(ZipEntry z, JarFile jar) throws PortalException {
        File destination = this.getOutputFileFor(z);
        FileOutputStream out = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to open '" + destination.getAbsolutePath() + "' for extracting a CAR resource."));
            }
            out = new FileOutputStream(destination);
        }
        catch (Exception e) {
            throw new PortalException("Unable to open file '" + destination.getAbsolutePath() + "'.", (Throwable)e);
        }
        byte[] bytes = new byte[4096];
        try {
            InputStream in = jar.getInputStream(z);
            int bytesRead = in.read(bytes);
            while (bytesRead != -1) {
                ((OutputStream)out).write(bytes, 0, bytesRead);
                bytesRead = in.read(bytes);
            }
            in.close();
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new PortalException("Unable to extract content of '" + z.getName() + "' in CAR '" + jar.getName() + "'.", (Throwable)e);
        }
    }

    private File getOutputFileFor(ZipEntry z) throws PortalException {
        int lastSeparator = z.getName().lastIndexOf(47);
        String fullName = "";
        String strDirPath = cClassesDirPath;
        if (z.getName().endsWith(".jsp") || z.getName().endsWith(".jspf") || z.getName().endsWith(".jsf")) {
            strDirPath = cJspDirPath;
        }
        fullName = strDirPath + "/" + z.getName();
        String filePath = null;
        filePath = lastSeparator == -1 ? strDirPath : strDirPath + "/" + z.getName().substring(0, lastSeparator);
        File dirPath = new File(filePath);
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to open '" + fullName + "' for extracting a CAR resource."));
            }
            return new File(fullName);
        }
        catch (Exception e) {
            throw new PortalException("Unable to open file '" + filePath + "'.", (Throwable)e);
        }
    }

    private JarFile getCar() throws PortalException {
        JarFile jar;
        File car = this.getCarFile();
        String carFileFullPath = car.getAbsolutePath();
        try {
            jar = new JarFile(car);
        }
        catch (IOException e) {
            throw new PortalException("Unable to open CAR '" + carFileFullPath + "'." + e);
        }
        return jar;
    }

    private File getCarFile() throws PortalException {
        if (this.mCarFile == null) {
            CarResources cRes = CarResources.getInstance();
            URL classUrl = cRes.findResource(this.mClassFilePath);
            if (classUrl == null) {
                throw new PortalException("Unable to locate CAR containing compiled controller class file '" + this.mClassFilePath + "'.");
            }
            String carPath = classUrl.toExternalForm();
            carPath = carPath.substring("jar:file:".length());
            carPath = carPath.substring(0, carPath.indexOf(33));
            this.mCarFile = new File(carPath);
            if (!this.mCarFile.exists()) {
                throw new PortalException("Unable to locate CAR '" + carPath + "'. Resources can't be deployed.");
            }
        }
        return this.mCarFile;
    }

    private String getClassesPath() throws PortalException {
        if (cClassesDirPath == null) {
            cClassesDirPath = this.getRealPath(CLASSES_DEPLOY_DIR_PROP);
        }
        return cClassesDirPath;
    }

    private String getRealPath(String relativePath) {
        String realPath;
        ServletContext ctx = PortalSessionManager.getInstance().getServletContext();
        String ctxRelativePath = PropertiesManager.getProperty(relativePath, "/WEB-INF/classes");
        if (ctxRelativePath.endsWith("/") || ctxRelativePath.endsWith("\\")) {
            ctxRelativePath = ctxRelativePath.substring(0, ctxRelativePath.length() - 1);
        }
        if ((realPath = ctx.getRealPath(ctxRelativePath)) == null) {
            throw new PortalException("Unable to locate directory " + ctxRelativePath);
        }
        return realPath;
    }

    private String getJspPath() throws PortalException {
        if (cJspDirPath == null) {
            cJspDirPath = this.getRealPath(JSP_DEPLOY_DIR_PROP);
        }
        return cJspDirPath;
    }

    private void determineDeploymentNeeds() throws PortalException {
        boolean carIsNewer;
        this.mClassFilePath = this.mClassName.replace('.', '/') + ".class";
        CarResources cRes = CarResources.getInstance();
        this.mCarFilePath = cRes.getContainingCarPath(this.mClassFilePath);
        boolean classInCar = this.mCarFilePath != null;
        boolean classInDir = this.classInDir();
        boolean depldInDir = DeploymentSpec.getInstance().isDeployInfoAvailableFor(this.mClassFilePath);
        boolean bl = carIsNewer = depldInDir && this.isCarNewer();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("classInCar: " + classInCar + " classInDir: " + classInDir + " depldInDir: " + depldInDir + " carIsNewer: " + carIsNewer));
        }
        if (!classInDir && classInCar && !depldInDir) {
            this.mDeployedAsCar = true;
            this.mPurgeOldResources = false;
            this.mDeploy = true;
        } else if (classInDir && !classInCar && !depldInDir) {
            this.mDeployedAsCar = false;
            this.mPurgeOldResources = false;
            this.mDeploy = false;
        } else if (classInDir && classInCar && !depldInDir) {
            this.mDeployedAsCar = true;
            this.mPurgeOldResources = false;
            this.mDeploy = true;
        } else if (!classInDir && classInCar && depldInDir || classInDir && !classInCar && depldInDir && carIsNewer || classInDir && classInCar && depldInDir && carIsNewer || !classInDir && classInCar && depldInDir && !carIsNewer) {
            this.mDeployedAsCar = true;
            this.mPurgeOldResources = true;
            this.mDeploy = true;
        } else if (classInDir && classInCar && depldInDir && !carIsNewer) {
            this.mDeployedAsCar = true;
            this.mPurgeOldResources = false;
            this.mDeploy = false;
        }
    }

    private boolean classInDir() throws PortalException {
        CarResources cRes = CarResources.getInstance();
        ClassLoader cLdr = cRes.getClassLoader();
        URL classUrl = cLdr.getResource(this.mClassFilePath);
        if (classUrl == null) {
            throw new PortalException("Class file, '" + this.mClassFilePath + "' not found on classpath.");
        }
        String classUrlPath = classUrl.toExternalForm();
        return classUrlPath.startsWith("file:");
    }

    private boolean isCarNewer() throws PortalException {
        long depDate = DeploymentSpec.getInstance().getTimeOfDeploymentForResource(this.mClassFilePath);
        File car = this.getCarFile();
        long carModDate = car.lastModified();
        return carModDate > depDate;
    }

    boolean isDeployedInCar() {
        return this.mDeployedAsCar;
    }
}

