/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.jsp;

import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.ICharacterChannel;
import org.jasig.portal.IDirectResponse;
import org.jasig.portal.IPrivileged;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.jsp.Deployer;
import org.jasig.portal.channels.jsp.HttpRequestFacade;
import org.jasig.portal.channels.jsp.HttpResponseFacade;
import org.jasig.portal.channels.jsp.IController;
import org.jasig.portal.channels.jsp.MediaResolver;
import org.jasig.portal.properties.PropertiesManager;

@Deprecated
public class Channel
extends BaseChannel
implements ICacheable,
ICharacterChannel,
IPrivilegedChannel,
IDirectResponse {
    private static final Log LOG = LogFactory.getLog(Channel.class);
    private static final String SINGLE_THREAD_CFG_PROPERTY = Channel.class.getName() + ".serializeJspRendering";
    private static final boolean cSerializeJspRendering = Channel.loadRenderingCfg();
    private static final String PREFS_PREFIX = "JSP.";
    protected String mControllerClassname = null;
    private Map mObjects;
    private Properties mJspMap = new Properties();
    private HttpServletResponse mResponse;
    private HttpServletRequest mRequest;
    private static Set mLoaded = new HashSet();
    private static Map mDeploymentApproach = new HashMap();
    protected IController mController;
    private HttpSession mSession = null;
    private static String CONTROLLER_KEY = "controllerClass";
    public static final Object CAR_DEPLOYMENT = new Object();
    public static final Object TRADITIONAL_DEPLOYMENT = new Object();
    private String cJspContextPath = null;

    private static boolean loadRenderingCfg() {
        boolean serialize = PropertiesManager.getPropertyAsBoolean(SINGLE_THREAD_CFG_PROPERTY, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Serializing JSP Request Rendering: " + serialize));
        }
        return serialize;
    }

    @Override
    public ChannelCacheKey generateKey() {
        if (this.mController != null) {
            return this.mController.generateKey();
        }
        return null;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        if (this.mController != null) {
            return this.mController.isCacheValid(validity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderCharacters(PrintWriter pw) throws PortalException {
        if (this.mController == null) {
            return;
        }
        String jspId = this.mController.getJspToRender();
        if (jspId == null) {
            throw new PortalException("No JSP id returned by controller.");
        }
        String jsp = this.mJspMap.getProperty(jspId);
        boolean relativeToController = false;
        if (jsp == null) {
            throw new PortalException("No mapping available for JSP id '" + jspId + "'.");
        }
        if (!jsp.startsWith("/")) {
            relativeToController = true;
            jsp = this.mController.getClass().getPackage().getName().replace('.', '/') + "/" + jsp;
        }
        String prefix = "";
        if (relativeToController || mDeploymentApproach.get(this.mControllerClassname) == CAR_DEPLOYMENT) {
            prefix = this.getJspContextPath();
        }
        HttpRequestFacade reqF = new HttpRequestFacade(this.mRequest);
        HttpResponseFacade respF = new HttpResponseFacade(this.mResponse);
        if (this.mObjects != null) {
            for (Map.Entry entry : this.mObjects.entrySet()) {
                reqF.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.mControllerClassname != null) {
            reqF.setAttribute("baseMediaUrl", this.runtimeData.getBaseMediaURL(this.mControllerClassname));
            reqF.setAttribute("baseActionUrl", this.runtimeData.getBaseActionURL(true));
            reqF.setAttribute("userLocale", this.runtimeData.getLocales()[0]);
        }
        String jspPath = prefix + jsp;
        if (cSerializeJspRendering) {
            HttpServletRequest httpServletRequest = this.mRequest;
            synchronized (httpServletRequest) {
                this.renderJsp(jspPath, reqF, respF);
            }
        } else {
            this.renderJsp(jspPath, reqF, respF);
        }
        if (!respF.isSuccessful()) {
            throw new PortalException("A problem occurred rendering JSP '" + jspPath + "'. Response Error Code: " + respF.getErrorCode() + (respF.getErrorMessage() != null ? ", Response Error Message '" + respF.getErrorMessage() + "'" : ""));
        }
        pw.print(respF.getCharacters());
    }

    private void renderJsp(String jspPath, HttpRequestFacade reqF, HttpResponseFacade respF) {
        RequestDispatcher dispatch = this.mRequest.getRequestDispatcher(jspPath);
        if (LOG.isDebugEnabled()) {
            if (dispatch == null) {
                LOG.debug((Object)("\n\n Jsp Channel Type with:\n- controller: '" + this.mController.getClass().getName() + "'\n" + "-     called: getRequestDispatcher()'\n" + "-         on:" + this.mRequest.getClass().getName() + ".'\n" + "-   hashcode: " + this.mRequest.hashCode() + "\n" + "-    passing: " + jspPath + "'\n" + "-   received: NULL"));
                LOG.debug((Object)"\n-       FROM:\n", new Throwable("STACK"));
            } else {
                LOG.debug((Object)("\n\n Jsp Channel Type with:\n- controller: '" + this.mController.getClass().getName() + "'\n" + "-     called: getRequestDispatcher()'\n" + "-         on:" + this.mRequest.getClass().getName() + ".'\n" + "-   hashcode: " + this.mRequest.hashCode() + "\n" + "-    passing: " + jspPath + "'\n" + "-   received: " + dispatch.getClass().getName() + "."));
                LOG.debug((Object)"\n-       FROM:\n", new Throwable("STACK"));
            }
        }
        if (dispatch == null) {
            throw new PortalException("Unable to delegate to JSP '" + jspPath + "'. " + this.mRequest.getClass().getName() + ".getRequestDispatch('" + jspPath + "') returned NULL.");
        }
        try {
            dispatch.forward((ServletRequest)reqF, (ServletResponse)respF);
        }
        catch (IllegalStateException e) {
            throw new PortalException("A problem occurred rendering JSP '" + jspPath + "'", (Throwable)e);
        }
        catch (ServletException e) {
            throw new PortalException("A problem occurred rendering JSP '" + jspPath + "'", (Throwable)e);
        }
        catch (Exception e) {
            throw new PortalException("A problem occurred rendering JSP '" + jspPath + "'", (Throwable)e);
        }
    }

    private String getJspContextPath() {
        if (this.cJspContextPath == null) {
            String ctxRelativePath = PropertiesManager.getProperty("org.jasig.portal.channels.jsp.Deployer.context.relative.jspPath", "/WEB-INF/classes");
            if (!ctxRelativePath.endsWith("/") && !ctxRelativePath.endsWith("\\")) {
                ctxRelativePath = ctxRelativePath + File.separatorChar;
            }
            this.cJspContextPath = ctxRelativePath;
        }
        return this.cJspContextPath;
    }

    @Override
    public void receiveEvent(PortalEvent ev) {
        if (this.mController != null) {
            this.mController.receiveEvent(ev);
        }
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("JSP Channel received setRuntimeData [" + rd + "]"));
        }
        if (this.mController != null) {
            super.setRuntimeData(new MediaResolver(rd));
            this.mObjects = this.mController.processRuntimeData(this.runtimeData, this.mSession);
        } else {
            super.setRuntimeData(rd);
        }
        Locale locale = this.runtimeData.getLocales()[0];
        this.mRequest.setAttribute("javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        this.mRequest.setAttribute("javax.servlet.jsp.jstl.fmt.locale.request", (Object)locale);
    }

    @Override
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        super.setStaticData(sd);
        this.getController();
        if (this.mController != null) {
            Enumeration allKeys = sd.keys();
            while (allKeys.hasMoreElements()) {
                String p = (String)allKeys.nextElement();
                if (!p.startsWith(PREFS_PREFIX)) continue;
                String name = p.substring(PREFS_PREFIX.length());
                String value = sd.getParameter(p);
                sd.setParameter(name, value);
                sd.remove(p);
            }
            this.mController.setStaticData(sd);
            this.loadJspMap();
        }
    }

    private void loadJspMap() {
        Map jsps = this.mController.getJspMap();
        if (null == jsps) {
            return;
        }
        for (Map.Entry entry : jsps.entrySet()) {
            String key = (String)entry.getKey();
            this.mJspMap.put(key, entry.getValue());
        }
    }

    private void getController() throws PortalException {
        if (this.mControllerClassname == null) {
            this.mControllerClassname = this.staticData.getParameter(CONTROLLER_KEY);
        }
        if (this.mControllerClassname == null) {
            throw new PortalException("No implementation of org.jasig.portal.channels.jsp.IController specified on ChannelStaticData.");
        }
        this.syncDeploymentOfResources(this.mControllerClassname);
        if (this.mControllerClassname == null) {
            throw new PortalException("No '" + CONTROLLER_KEY + "' specified.");
        }
        Class<?> c = null;
        Object obj = null;
        try {
            CarResources cRes = CarResources.getInstance();
            ClassLoader cl = cRes.getClassLoader();
            c = cl.loadClass(this.mControllerClassname);
        }
        catch (Exception e) {
            throw new PortalException("Class '" + this.mControllerClassname + "' specified in parameter '" + CONTROLLER_KEY + "' could not be loaded.", (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new PortalException("Class '" + this.mControllerClassname + "' specified in parameter '" + CONTROLLER_KEY + "' could not be loaded.", (Throwable)e);
        }
        try {
            obj = c.newInstance();
        }
        catch (Exception e) {
            throw new PortalException("Unable to instantiate class '" + this.mControllerClassname + "' specified in parameter '" + CONTROLLER_KEY + "'.", (Throwable)e);
        }
        try {
            this.mController = obj;
        }
        catch (ClassCastException cce) {
            throw new PortalException("Class '" + this.mControllerClassname + "' specified in parameter '" + CONTROLLER_KEY + "' does not implement " + IController.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void syncDeploymentOfResources(String classname) {
        String resource = classname.replace('.', '/') + ".class";
        CarResources cRes = CarResources.getInstance();
        String car = cRes.getContainingCarPath(resource);
        if (car == null) {
            mDeploymentApproach.put(classname, TRADITIONAL_DEPLOYMENT);
            return;
        }
        if (mLoaded.contains(car)) return;
        Class<Channel> clazz = Channel.class;
        synchronized (Channel.class) {
            if (mLoaded.contains(car)) return;
            Deployer deployer = new Deployer();
            deployer.deployResources(classname);
            mDeploymentApproach.put(classname, deployer.isDeployedInCar() ? CAR_DEPLOYMENT : TRADITIONAL_DEPLOYMENT);
            mLoaded.add(car);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setPortalControlStructures(PortalControlStructures pcs) throws PortalException {
        this.mSession = pcs.getHttpSession();
        this.mRequest = pcs.getHttpServletRequest();
        this.mResponse = pcs.getHttpServletResponse();
        if (this.mController != null && this.mController instanceof IPrivileged) {
            ((IPrivileged)((Object)this.mController)).setPortalControlStructures(pcs);
        }
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        if (this.mController == null || !(this.mController instanceof IDirectResponse)) {
            throw new UnsupportedOperationException("JSP Controller " + this.mControllerClassname + " does not implement " + IDirectResponse.class.getName() + ".");
        }
        ((IDirectResponse)((Object)this.mController)).setResponse(response);
    }
}

