/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.IPermissible;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerUnrestrictedSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerConstants;
import org.jasig.portal.channels.groupsmanager.GroupsManagerWrapperFactory;
import org.jasig.portal.channels.groupsmanager.IGroupsManagerWrapper;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.permissions.GroupsManagerAdminPermissions;
import org.jasig.portal.channels.groupsmanager.permissions.GroupsManagerDefaultPermissions;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.services.EntityPropertyRegistry;
import org.jasig.portal.services.GroupService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class GroupsManagerXML
implements GroupsManagerConstants {
    private static final Log log = LogFactory.getLog(GroupsManagerXML.class);
    private static int UID = 0;

    public static Document getGroupsManagerXml(CGroupsManagerSessionData sessionData) {
        Document viewDoc;
        sessionData.model = viewDoc = GroupsManagerXML.getNewDocument();
        Element viewRoot = viewDoc.createElement("CGroupsManager");
        viewDoc.appendChild(viewRoot);
        Utility.logMessage("DEBUG", "GroupsManagerXML::getGroupsManagerXML(): sessionData.isAdminUser = " + sessionData.isAdminUser);
        if (sessionData.gmPermissions == null) {
            sessionData.gmPermissions = sessionData.isAdminUser ? GroupsManagerAdminPermissions.getInstance() : GroupsManagerDefaultPermissions.getInstance();
        }
        Element etRoot = GroupsManagerXML.getEntityTypesXml(viewDoc);
        viewRoot.appendChild(etRoot);
        Element rootGroupsElem = GroupsManagerXML.createElement("group", viewDoc, true);
        rootGroupsElem.setAttribute("id", "0");
        rootGroupsElem.setAttribute("expanded", "true");
        Element rdfElem = GroupsManagerXML.createRdfElement(null, viewDoc);
        rootGroupsElem.appendChild(rdfElem);
        viewRoot.appendChild(rootGroupsElem);
        try {
            HashMap entTypes = GroupsManagerXML.getEntityTypes();
            CGroupsManagerUnrestrictedSessionData unrsd = sessionData.getUnrestrictedData();
            for (Object key : entTypes.keySet()) {
                Class entType = (Class)entTypes.get(key);
                IEntityGroup rootGrp = GroupService.getRootGroup(entType);
                Element rootGroupElement = GroupsManagerXML.getGroupMemberXml(rootGrp, true, null, unrsd);
                rootGroupElement.setAttribute("editable", String.valueOf(rootGrp.isEditable()));
                rootGroupsElem.appendChild(rootGroupElement);
            }
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "GroupsManagerXML::getGroupsManagerXML(): ERROR" + e, e);
        }
        return viewDoc;
    }

    public static Element createElement(String name, Document xmlDoc, boolean setGrpDefault) {
        Element grpRoot = xmlDoc.createElement(name);
        grpRoot.setAttribute("selected", "false");
        if (setGrpDefault) {
            grpRoot.setAttribute("id", "");
            grpRoot.setAttribute("expanded", "false");
        }
        return grpRoot;
    }

    public static Element createRdfElement(IEntityGroup entGrp, Document xmlDoc) {
        String entCreator;
        String entDesc;
        String entName;
        if (entGrp == null) {
            entName = "Root Groups";
            entDesc = "Set of Entity Types that have a root group.";
            entCreator = "Default";
        } else {
            entName = entGrp.getName();
            entDesc = entGrp.getDescription();
            if (entDesc == null) {
                entDesc = new String();
            }
            entCreator = GroupsManagerXML.getEntityName("org.jasig.portal.security.IPerson", entGrp.getCreatorID());
        }
        Element rdfElem = xmlDoc.createElement("rdf:RDF");
        rdfElem.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        rdfElem.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Utility.logMessage("DEBUG", "GroupsManagerXML::createRdfElement(): CREATING ELEMENT RDF DESCRIPTION");
        Element rdfDesc = xmlDoc.createElement("rdf:Description");
        Utility.logMessage("DEBUG", "GroupsManagerXML::createRdfElement(): CREATING ELEMENT DCTITLE");
        Element dcTitle = xmlDoc.createElement("dc:title");
        dcTitle.appendChild(xmlDoc.createTextNode(entName));
        rdfDesc.appendChild(dcTitle);
        Utility.logMessage("DEBUG", "GroupsManagerXML::createRdfElement(): CREATING ELEMENT dcDESCRIPTION");
        Element dcDescription = xmlDoc.createElement("dc:description");
        dcDescription.appendChild(xmlDoc.createTextNode(entDesc));
        rdfDesc.appendChild(dcDescription);
        Utility.logMessage("DEBUG", "GroupsManagerXML::createRdfElement(): CREATING ELEMENT dcCREATOR");
        Element dcCreator = xmlDoc.createElement("dc:creator");
        Utility.logMessage("DEBUG", "GroupsManagerXML::createRdfElement(): APPENDING TO dcCREATOR");
        dcCreator.appendChild(xmlDoc.createTextNode(entCreator));
        Utility.logMessage("DEBUG", "GroupsManagerXML::createRdfElement(): APPENDING TO RDFDESC");
        rdfDesc.appendChild(dcCreator);
        Utility.logMessage("DEBUG", "GroupsManagerXML::createRdfElement(): APPENDING TO RDF");
        rdfElem.appendChild(rdfDesc);
        return rdfElem;
    }

    public static void createPermissions(CGroupsManagerSessionData sessionData, IEntityGroup childEntGrp) throws Exception {
        IPermission prm;
        ChannelStaticData staticData = sessionData.staticData;
        Document model = sessionData.model;
        ArrayList<IPermission> perms = new ArrayList<IPermission>();
        IUpdatingPermissionManager upm = AuthorizationService.instance().newUpdatingPermissionManager("org.jasig.portal.channels.groupsmanager.CGroupsManager");
        IAuthorizationPrincipal ap = staticData.getAuthorizationPrincipal();
        Utility.logMessage("DEBUG", "GroupManagerXML::createPermissions(): The IAuthorizationPrincipal: " + ap);
        String[] activities = ((IPermissible)Class.forName("org.jasig.portal.channels.groupsmanager.CGroupsManager").newInstance()).getActivityTokens();
        for (int a = 0; a < activities.length; ++a) {
            prm = upm.newPermission(ap);
            prm.setActivity(activities[a]);
            prm.setTarget(childEntGrp.getKey());
            prm.setType("GRANT");
            perms.add(prm);
        }
        upm.addPermissions(perms.toArray(new IPermission[perms.size()]));
        NodeList principals = model.getDocumentElement().getElementsByTagName("principal");
        Element princElem = (Element)principals.item(0);
        for (int p = 0; p < perms.size(); ++p) {
            prm = (IPermission)perms.get(p);
            Element permElem = GroupsManagerXML.getPermissionXml(model, prm.getPrincipal(), prm.getActivity(), prm.getType(), prm.getTarget());
            princElem.appendChild(permElem);
        }
    }

    public static void expandGroupElementXML(Element expandedElem, CGroupsManagerUnrestrictedSessionData sd) {
        boolean hasMembers = expandedElem.getAttribute("hasMembers").equals("true");
        Utility.logMessage("DEBUG", "ExpandGroup::execute(): Expanded element has Members = " + hasMembers);
        if (hasMembers) {
            expandedElem.setAttribute("expanded", "true");
            Utility.logMessage("DEBUG", "ExpandGroup::execute(): About to retrieve children");
            IEntityGroup entGrp = !GroupsManagerXML.isPersistentGroup(expandedElem) ? null : GroupsManagerXML.retrieveGroup(expandedElem.getAttribute("key"));
            GroupsManagerXML.getGroupMemberXml(entGrp, true, expandedElem, sd);
        }
    }

    public static Element getAuthorizationXml(ChannelStaticData sd, Element apRoot, Document xmlDoc) {
        IAuthorizationPrincipal ap = sd.getAuthorizationPrincipal();
        String princTagname = "principal";
        if (ap != null && apRoot == null) {
            apRoot = xmlDoc.createElement(princTagname);
            apRoot.setAttribute("token", ap.getPrincipalString());
            apRoot.setAttribute("type", ap.getType().getName());
            String name = ap.getKey();
            try {
                name = EntityNameFinderService.instance().getNameFinder(ap.getType()).getName(name);
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", e.toString(), e);
            }
            apRoot.setAttribute("name", name);
        }
        if (ap == null) {
            Utility.logMessage("WARN", "GroupsManagerXML::getAuthorizationXml: Authorizationprincipal was null; proceeding with empty permissions");
        } else {
            try {
                IPermission[] perms = ap.getAllPermissions("org.jasig.portal.channels.groupsmanager.CGroupsManager", null, null);
                for (int yy = 0; yy < perms.length; ++yy) {
                    Element prm = GroupsManagerXML.getPermissionXml(xmlDoc, perms[yy].getPrincipal(), perms[yy].getActivity(), perms[yy].getType(), perms[yy].getTarget());
                    apRoot.appendChild(prm);
                }
            }
            catch (AuthorizationException ae) {
                Utility.logMessage("ERROR", "GroupsManagerXML::getAuthorzationXml: authorization exception " + ae.getMessage(), ae);
            }
        }
        return apRoot;
    }

    public static Element getElementById(Document aDoc, String id) {
        ArrayList<Element> elems = new ArrayList<Element>();
        Element elem = null;
        Element retElem = null;
        String tagname = "entity";
        boolean isDone = false;
        while (!isDone) {
            NodeList nList = aDoc.getElementsByTagName(tagname);
            for (int i = 0; i < nList.getLength(); ++i) {
                elem = (Element)nList.item(i);
                if (!elem.getAttribute("id").equals(id)) continue;
                elems.add(elem);
            }
            if (tagname.equals("entity")) {
                tagname = "group";
            } else {
                isDone = true;
            }
            if (elems.size() != 1) {
                if (elems.size() <= 1) continue;
                log.error((Object)("GroupsManagerXML::getElementById:  More than one element found for Id: " + id));
                continue;
            }
            retElem = (Element)elems.iterator().next();
        }
        return retElem;
    }

    public static Element getElementByTagNameAndId(Document aDoc, String tagname, String id) {
        Element elem = null;
        Element selElem = null;
        NodeList nList = aDoc.getElementsByTagName(tagname);
        for (int i = 0; i < nList.getLength(); ++i) {
            elem = (Element)nList.item(i);
            if (!elem.getAttribute("id").equals(id)) continue;
            selElem = elem;
            break;
        }
        return selElem;
    }

    public static String getElementValueForTagName(Element anElem, String tagname) {
        Utility.logMessage("DEBUG", "GroupsManagerXML:getElementValueForTagName(): retrieve element value for tagname: " + tagname);
        String retValue = null;
        NodeList nList = anElem.getElementsByTagName(tagname);
        if (nList.getLength() > 0) {
            retValue = nList.item(0).getFirstChild().getNodeValue();
        }
        retValue = retValue != null ? retValue : "";
        Utility.logMessage("DEBUG", "GroupsManagerXML:getElementValueForTagName(): tagname " + tagname + " = " + retValue);
        return retValue;
    }

    public static String getEntityName(Class typClass, String aKey) {
        String entName = "";
        long time1 = Calendar.getInstance().getTime().getTime();
        long time2 = 0L;
        Utility.logMessage("DEBUG", "GroupsManagerXML.getEntityName(Class,String): Retrieving entity for entityType: " + typClass.getName() + " key: " + aKey);
        try {
            entName = EntityNameFinderService.instance().getNameFinder(typClass).getName(aKey);
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "GroupsManagerXML.getEntityName(Class,String): ERROR retrieving entity " + e, e);
        }
        time2 = Calendar.getInstance().getTime().getTime();
        String msg = "GroupsManagerXML.getEntityName(Class,String) timer: " + String.valueOf(time2 - time1) + " ms total";
        Utility.logMessage("DEBUG", msg);
        Utility.logMessage("DEBUG", "GroupsManagerXML.getEntityName(Class,String): typClass/aKey/entName = " + typClass + "/" + aKey + "/" + entName);
        return entName;
    }

    public static String getEntityName(String className, String aKey) {
        String entName = "";
        Utility.logMessage("DEBUG", "GroupsManagerXML.getEntityName(String,String): Retrieving entity for entityType: " + className + " key: " + aKey);
        try {
            entName = GroupsManagerXML.getEntityName(Class.forName(className), aKey);
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "GroupsManagerXML.getEntityName(String,String): ERROR retrieving entity " + e, e);
        }
        return entName;
    }

    public static HashMap getEntityTypes() {
        HashMap<String, Class> entTypes = new HashMap<String, Class>(5);
        Iterator entTypesItr = EntityTypes.singleton().getAllEntityTypes();
        while (entTypesItr.hasNext()) {
            Class entType = (Class)entTypesItr.next();
            String entClassName = entType.getName();
            String entName = EntityTypes.singleton().getDescriptiveNameForType(entType);
            try {
                if (GroupService.getRootGroup(entType) != null) {
                    entTypes.put(entName, entType);
                    Utility.logMessage("DEBUG", "GroupsManagerXML::getEntityTypes Added : " + entName + " -- " + entClassName);
                    continue;
                }
                Utility.logMessage("DEBUG", "GroupsManagerXML::getEntityTypes Did NOT Add : " + entName + " -- " + entClassName);
            }
            catch (Exception e) {
                Utility.logMessage("DEBUG", "GroupsManagerXML::getEntityTypes: " + entName + " -- " + entClassName + " does not have a root group.. NOT ADDED");
            }
        }
        return entTypes;
    }

    public static Element getEntityTypesXml(Document xmlDoc) {
        Element etRoot = xmlDoc.createElement("entityTypes");
        HashMap entTypes = GroupsManagerXML.getEntityTypes();
        for (Object key : entTypes.keySet()) {
            String entType = ((Class)entTypes.get(key)).getName();
            Element etElem = xmlDoc.createElement("entityType");
            etElem.setAttribute("name", (String)key);
            etElem.setAttribute("type", entType);
            etRoot.appendChild(etElem);
        }
        return etRoot;
    }

    public static Element getExpandedElementForTagNameAndKey(Document aDoc, String tagname, String key) {
        Iterator nodeItr = GroupsManagerXML.getNodesByTagNameAndKey(aDoc, tagname, key);
        Element curElem = null;
        Element expElem = null;
        while (nodeItr.hasNext()) {
            curElem = (Element)nodeItr.next();
            if (!curElem.getAttribute("expanded").equals("true")) continue;
            expElem = curElem;
            break;
        }
        return expElem;
    }

    public static Element getGroupMemberXml(IGroupMember gm, boolean isContextExpanded, Element anElem, CGroupsManagerUnrestrictedSessionData sd) {
        IGroupsManagerWrapper rap;
        Document aDoc = sd.model;
        if (gm == null) {
            return null;
        }
        Element rootElem = anElem;
        String tagname = "entity";
        if (gm.isGroup()) {
            tagname = "group";
            rootElem = rootElem != null ? rootElem : GroupsManagerXML.createElement("group", aDoc, false);
            rootElem.setAttribute("expanded", String.valueOf(isContextExpanded));
        }
        if ((rap = GroupsManagerXML.getWrapper(tagname)) != null) {
            rootElem = rap.getXml(gm, rootElem, sd);
        }
        return rootElem;
    }

    public static Document getNewDocument() {
        Document aDoc = null;
        Utility.logMessage("DEBUG", "GroupsManagerXML::getNewDocument(): About to get new Document");
        try {
            aDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            Utility.logMessage("ERROR", "GroupsManagerXML::getNewDocument(): Unable to get new Document\n" + pce, pce);
        }
        return aDoc;
    }

    public static synchronized String getNextUid() {
        Utility.logMessage("DEBUG", "GroupsManagerXML::getNextUid(): Start");
        if (UID > 2147483600) {
            UID = 0;
        }
        return String.valueOf(++UID);
    }

    public static Iterator getNodesById(Document aDoc, String id) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        Element elem = GroupsManagerXML.getElementById(aDoc, id);
        nodes.add(elem);
        return nodes.iterator();
    }

    public static Iterator getNodesByTagNameAndKey(Document aDoc, String tagname, String key) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Element elem = null;
        NodeList nList = aDoc.getElementsByTagName(tagname);
        for (int i = 0; i < nList.getLength(); ++i) {
            elem = (Element)nList.item(i);
            if (!elem.getAttribute("key").equals(key)) continue;
            nodes.add(nList.item(i));
        }
        Utility.logMessage("DEBUG", "GroupsManagerXML::getNodesByTagNameAndKey: Number of nodes found for tagname " + tagname + " and Key: " + key + " is: " + nodes.size());
        return nodes.iterator();
    }

    public static Iterator getNodesByTagNameAndKey(Element anElem, String tagname, String key) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Element elem = null;
        NodeList nList = anElem.getElementsByTagName(tagname);
        for (int i = 0; i < nList.getLength(); ++i) {
            elem = (Element)nList.item(i);
            if (!elem.getAttribute("key").equals(key)) continue;
            nodes.add(nList.item(i));
        }
        Utility.logMessage("DEBUG", "GroupsManagerXML::getNodesByTagNameAndKey: Number of nodes found for tagname " + tagname + " and Key: " + key + " is: " + nodes.size());
        return nodes.iterator();
    }

    public static Element getPermissionXml(Document xmlDoc, String prmPrincipal, String prmActivity, String prmType, String prmTarget) {
        Element prm = xmlDoc.createElement("permission");
        prm.setAttribute("principal", prmPrincipal);
        prm.setAttribute("activity", prmActivity);
        prm.setAttribute("type", prmType);
        prm.setAttribute("target", prmTarget);
        return prm;
    }

    public static IGroupsManagerWrapper getWrapper(String type) {
        String tagname = type.equals("entity") || type.equals("org.jasig.portal.security.IPerson") ? "entity" : "group";
        IGroupsManagerWrapper rap = GroupsManagerWrapperFactory.get(tagname);
        return rap;
    }

    public static boolean isPersistentGroup(Element anElem) {
        boolean rval = true;
        if (anElem == null) {
            throw new IllegalArgumentException("anElem may not be null");
        }
        if (!Utility.areEqual(anElem.getNodeName(), "group") || Utility.areEqual(anElem.getAttribute("searchResults"), "true") || anElem.getAttribute("id").equals("0")) {
            rval = false;
        }
        return rval;
    }

    public static void refreshAllNodes(CGroupsManagerUnrestrictedSessionData sd, IEntityGroup entGrp) {
        Document model = sd.model;
        String updKey = entGrp.getKey();
        Utility.logMessage("DEBUG", "GroupsManagerXML::refreshAllNodes(): About to refresh all nodes for IEntityGroup: " + updKey);
        Iterator updatedNodes = GroupsManagerXML.getNodesByTagNameAndKey(model, "group", updKey);
        Utility.logMessage("DEBUG", "GroupsManagerXML::refreshAllNodes(): About to gather all elements for key: " + updKey);
        while (updatedNodes.hasNext()) {
            Node updNode = (Node)updatedNodes.next();
            Element updElem = (Element)updNode;
            GroupsManagerXML.refreshElement(updElem, entGrp);
        }
    }

    public static void refreshAllNodesIfRequired(CGroupsManagerUnrestrictedSessionData sd, Element anElem) {
        if (!GroupsManagerXML.isPersistentGroup(anElem)) {
            return;
        }
        try {
            if (GroupsManagerXML.refreshRequired(anElem, null)) {
                Utility.logMessage("Debug", "GroupsManagerXML::refreshAllNodesIfRequired(): Element needs refreshing : " + anElem);
                GroupsManagerXML.refreshAllNodes(sd, GroupsManagerXML.retrieveGroup(anElem.getAttribute("key")));
            }
        }
        catch (Exception e) {
            Utility.logMessage("INFO", "GroupsManagerXML::refreshAllNodesIfRequired(): Unable to refresh all elements for IEntityGroup represented by element: " + anElem);
            Utility.logMessage("INFO", e.toString(), e);
        }
    }

    public static void refreshAllNodesRecursivelyIfRequired(CGroupsManagerUnrestrictedSessionData sd, Element parentElem) {
        if (parentElem == null) {
            Utility.logMessage("INFO", "GroupsManagerXML::refreshAllNodesRecursivelyIfRequired(): parentElem is null");
            return;
        }
        boolean isParentElementExpanded = Utility.areEqual(parentElem.getAttribute("expanded"), "true");
        GroupsManagerXML.refreshAllNodesIfRequired(sd, parentElem);
        if (isParentElementExpanded) {
            Element parentNode = parentElem;
            NodeList childNodes = parentNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                Element childElem = (Element)childNode;
                String childType = childElem.getAttribute("type");
                if (!Utility.notEmpty(childType)) continue;
                GroupsManagerXML.refreshAllNodesIfRequired(sd, childElem);
            }
            GroupsManagerXML.expandGroupElementXML(parentElem, sd);
        }
    }

    public static void refreshElement(Element updElem, IEntityGroup entGrp) {
        Node descNode;
        if (!GroupsManagerXML.isPersistentGroup(updElem)) {
            return;
        }
        IEntityGroup updEntGrp = entGrp != null ? entGrp : GroupsManagerXML.retrieveGroup(updElem.getAttribute("key"));
        Utility.printElement(updElem, "Element before update------");
        NodeList nList = updElem.getElementsByTagName("dc:title");
        if (nList.getLength() > 0) {
            Node titleNode = nList.item(0);
            titleNode.getFirstChild().setNodeValue(entGrp.getName());
        }
        if ((nList = updElem.getElementsByTagName("dc:description")).getLength() > 0) {
            descNode = nList.item(0);
            descNode.getFirstChild().setNodeValue(entGrp.getDescription());
        }
        if ((nList = updElem.getElementsByTagName("dc:creator")).getLength() > 0) {
            descNode = nList.item(0);
            String crtName = GroupsManagerXML.getEntityName(updEntGrp.getLeafType(), updEntGrp.getCreatorID());
            descNode.getFirstChild().setNodeValue(crtName);
        }
        Utility.printElement(updElem, "Element after update++++++");
    }

    public static boolean refreshRequired(Element chkElem, IEntityGroup entGrp) {
        if (!GroupsManagerXML.isPersistentGroup(chkElem)) {
            return false;
        }
        IEntityGroup chkEntGrp = entGrp != null ? entGrp : GroupsManagerXML.retrieveGroup(chkElem.getAttribute("key"));
        Utility.logMessage("DEBUG", "GroupsManagerXML::refreshRequired(): About to check if element needs to be refreshed for Element ID: " + chkElem.getAttribute("id") + " Key: " + chkElem.getAttribute("key"));
        String elemValue = GroupsManagerXML.getElementValueForTagName(chkElem, "dc:title");
        if (!Utility.areEqual(elemValue, chkEntGrp.getName())) {
            Utility.logMessage("DEBUG", "GroupsManagerXML::refreshRequired(): Name has changed!!");
            return true;
        }
        elemValue = GroupsManagerXML.getElementValueForTagName(chkElem, "dc:description");
        if (!Utility.areEqual(elemValue, chkEntGrp.getDescription())) {
            Utility.logMessage("DEBUG", "GroupsManagerXML::refreshRequired(): Description has changed!!");
            return true;
        }
        return false;
    }

    public static IEntity retrieveEntity(String aKey, String aType) {
        IEntity ent = null;
        try {
            Class<?> iEntityClass = Class.forName(aType);
            ent = GroupService.getEntity(aKey, iEntityClass);
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "EntityWrapper.retrieveEntity(): ERROR retrieving entity " + e, e);
        }
        return ent;
    }

    public static IEntityGroup retrieveGroup(String aKey) {
        Utility.logMessage("DEBUG", "GroupsManagerXML::retrieveGroup(): About to search for Group: " + aKey);
        IEntityGroup grp = null;
        try {
            if (aKey != null) {
                grp = GroupService.findGroup(aKey);
            }
        }
        catch (Throwable th) {
            Utility.logMessage("ERROR", "GroupsManagerXML::retrieveGroup(): Could not retrieve Group Member (" + aKey + "): \n" + th, th);
        }
        return grp;
    }

    public static IGroupMember retrieveGroupMemberForElementId(Document aDoc, String id) {
        Element gmElem = GroupsManagerXML.getElementById(aDoc, id);
        if (gmElem == null || Utility.areEqual(gmElem.getNodeName(), "group") && !GroupsManagerXML.isPersistentGroup(gmElem)) {
            Utility.logMessage("INFO", "GroupsManagerXML::retrieveGroupMemberForElementId(): Unable to retrieve the element with id = " + id);
            return null;
        }
        Utility.logMessage("DEBUG", "GroupsManagerXML::retrieveGroupMemberForElementId(): The child type = " + gmElem.getTagName());
        IGroupMember gm = GroupsManagerXML.retrieveGroupMemberForElement(gmElem);
        return gm;
    }

    public static IGroupMember retrieveGroupMemberForElement(Element gmElem) {
        String gmKey = gmElem.getAttribute("key");
        Utility.logMessage("DEBUG", "GroupsManagerXML::retrieveGroupMemberForElement(): About to retrieve group member (" + gmElem.getTagName() + " for key: " + gmKey);
        IGroupMember gm = gmElem.getTagName().equals("group") ? GroupsManagerXML.retrieveGroup(gmKey) : GroupsManagerXML.retrieveEntity(gmKey, gmElem.getAttribute("type"));
        return gm;
    }

    public static String getTagName(IGroupMember gm) {
        String tagname = gm.isGroup() ? "group" : "entity";
        return tagname;
    }

    public static void removeElementsForTagName(Element anElem, String tagname) {
        Utility.printElement(anElem, "BEFORE properties are removed.");
        NodeList nList = anElem.getElementsByTagName(tagname);
        if (nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                if (nList.item(i).getParentNode() != anElem) continue;
                anElem.removeChild(nList.item(i));
            }
        }
    }

    public static void removePropertyElements(Document model, IGroupMember gm, boolean clearCache) {
        Iterator nodeItr = GroupsManagerXML.getNodesByTagNameAndKey(model, GroupsManagerXML.getTagName(gm), gm.getKey());
        while (nodeItr.hasNext()) {
            Element curElem = (Element)nodeItr.next();
            GroupsManagerXML.removeElementsForTagName(curElem, "properties");
        }
        if (clearCache) {
            GroupsManagerXML.clearPropertiesCache(gm);
        }
    }

    public static void clearPropertiesCache(IGroupMember gm) {
        EntityPropertyRegistry.instance().clearCache(gm.getUnderlyingEntityIdentifier());
    }
}

