/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.IPermissible;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerCommandFactory;
import org.jasig.portal.channels.groupsmanager.GroupsManagerConstants;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.IGroupsManagerCommand;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

@Deprecated
public class CGroupsManager
implements IChannel,
GroupsManagerConstants,
IPermissible,
ICacheable {
    protected static final String sslLocation = "CGroupsManager.ssl";
    protected static HashMap activities = null;
    protected HashMap targets = null;
    private CGroupsManagerSessionData sessionData;

    public CGroupsManager() {
        this.init();
    }

    protected synchronized void init() {
        Utility.logMessage("DEBUG", this.getClass().getName() + "::init(): this = " + this);
        if (activities == null) {
            activities = new HashMap();
            try {
                activities.put("CREATE", "Create a group in this context");
                activities.put("VIEW", "View this group");
                activities.put("UPDATE", "Rename this group");
                activities.put("DELETE", "Delete this group");
                activities.put("SELECT", "Select this group");
                activities.put("ADD/REMOVE", "Manage this group's members");
                activities.put("ASSIGNPERMISSIONS", "Assign Permissions for this group");
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", "CGroupsManager.init():: unable to set activities" + e, e);
            }
        }
        try {
            if (this.targets == null) {
                this.targets = new HashMap();
                IEntityGroup everyone = GroupService.getDistinguishedGroup(GroupService.EVERYONE);
                this.targets.put(everyone.getKey(), everyone.getName());
                Iterator allgroups = everyone.getAllMembers();
                while (allgroups.hasNext()) {
                    IGroupMember g = (IGroupMember)allgroups.next();
                    if (!g.isGroup() || this.targets.get(g.getKey()) != null) continue;
                    try {
                        this.targets.put(g.getKey(), ((IEntityGroup)g).getName());
                    }
                    catch (Exception e) {
                        Utility.logMessage("ERROR", "CGroupsManager.init():: unable to add target" + e, e);
                    }
                }
                IEntityGroup allChans = GroupService.getDistinguishedGroup(GroupService.CHANNEL_CATEGORIES);
                this.targets.put(allChans.getKey(), allChans.getName());
                Iterator allcgroups = allChans.getAllMembers();
                while (allcgroups.hasNext()) {
                    IGroupMember g = (IGroupMember)allcgroups.next();
                    if (!g.isGroup() || this.targets.get(g.getKey()) != null) continue;
                    try {
                        this.targets.put(g.getKey(), ((IEntityGroup)g).getName());
                    }
                    catch (Exception e) {
                        Utility.logMessage("ERROR", "CGroupsManager.init():: unable to add target" + e, e);
                    }
                }
            }
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "CGroupsManager.init():: unable to set targets" + e, e);
        }
    }

    @Override
    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    @Override
    public void receiveEvent(PortalEvent ev) {
        if (ev.getEventNumber() == 1) {
            try {
                CGroupsManagerSessionData sd = this.sessionData;
                if (sd.lockedGroup != null) {
                    sd.lockedGroup.getLock().release();
                    sd.lockedGroup = null;
                }
                if (sd.servantChannel != null) {
                    sd.servantChannel.receiveEvent(ev);
                }
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", this.getClass().getName() + "::receiveEvent(): Exception = " + e, e);
            }
        }
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        long time2;
        long time1;
        ChannelRuntimeData runtimeData;
        CGroupsManagerSessionData sessionData;
        block16: {
            Utility.logMessage("DEBUG", this.getClass().getName() + "::renderXML(): this = " + this);
            sessionData = this.getSessionData();
            runtimeData = sessionData.runtimeData;
            time1 = Calendar.getInstance().getTime().getTime();
            time2 = 0L;
            Document viewDoc = null;
            try {
                if (sessionData.servantChannel != null) {
                    sessionData.servantChannel.renderXML(out);
                    Utility.logMessage("DEBUG", this.getClass().getName() + ".renderXML(): Defering to servant render");
                    break block16;
                }
                viewDoc = sessionData.model;
                time2 = Calendar.getInstance().getTime().getTime();
                XSLT xslt = XSLT.getTransformer(this, runtimeData.getLocales());
                xslt.setXML(viewDoc);
                xslt.setTarget(out);
                xslt.setStylesheetParameter("baseActionURL", sessionData.runtimeData.getBaseActionURL());
                if (sessionData.isAdminUser) {
                    xslt.setStylesheetParameter("ignorePermissions", "true");
                }
                if (sessionData.customMessage != null) {
                    xslt.setStylesheetParameter("customMessage", sessionData.customMessage);
                }
                xslt.setStylesheetParameter("mode", sessionData.mode);
                xslt.setStylesheetParameter("page", String.valueOf(sessionData.currentPage));
                if (sessionData.highlightedGroupID != null) {
                    xslt.setStylesheetParameter("highlightedGroupID", sessionData.highlightedGroupID);
                }
                if (sessionData.rootViewGroupID != null) {
                    xslt.setStylesheetParameter("rootViewGroupID", sessionData.rootViewGroupID);
                } else if (sessionData.defaultRootViewGroupID != null) {
                    xslt.setStylesheetParameter("rootViewGroupID", sessionData.defaultRootViewGroupID);
                }
                if (sessionData.feedback != null) {
                    xslt.setStylesheetParameter("feedback", sessionData.feedback);
                    sessionData.feedback = null;
                }
                if (sessionData.servantMode) {
                    xslt.setStylesheetParameter("grpServantMode", "true");
                }
                if (!sessionData.allowFinish) {
                    xslt.setStylesheetParameter("blockFinishActions", "true");
                }
                try {
                    xslt.setXSL(sslLocation, "main", sessionData.runtimeData.getBrowserInfo());
                    xslt.transform();
                }
                catch (PortalException pe) {
                    Utility.logMessage("ERROR", pe.toString(), pe);
                    if (pe.getCause() != null) {
                        Utility.logMessage("ERROR", pe.getCause().toString(), pe.getCause());
                    }
                }
                catch (Exception e) {
                    Utility.logMessage("ERROR", e.toString(), e);
                }
                Utility.logMessage("DEBUG", "CGroupsManager::renderXML(): Servant services complete");
                Utility.printDoc(viewDoc, "CGroupsManager::renderXML(): Final document state:");
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", e.toString(), e);
            }
        }
        long time3 = Calendar.getInstance().getTime().getTime();
        Utility.logMessage("DEBUG", this.getClass().getName() + ".renderXML() timer: " + String.valueOf(time3 - time1) + " ms total, xsl took " + String.valueOf(time3 - time2) + " ms for view " + runtimeData.getParameter("grpView"));
        Utility.logMessage("DEBUG", this.getClass().getName() + ".renderXML() time since setRD: " + String.valueOf(time3 - sessionData.startRD));
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) {
        Utility.logMessage("DEBUG", this.getClass().getName() + "::setRuntimeData(): this = " + this);
        CGroupsManagerSessionData sessionData = this.getSessionData();
        ChannelRuntimeData runtimeData = sessionData.runtimeData = rd;
        sessionData.startRD = Calendar.getInstance().getTime().getTime();
        if (sessionData.servantChannel == null) {
            if (Utility.hasValue(runtimeData.getParameter("grpCommand"))) {
                String theCommand = runtimeData.getParameter("grpCommand");
                Utility.logMessage("DEBUG", this.getClass().getName() + "::renderXML(): COMMAND PROCESS About to get the'" + theCommand + "' command");
                IGroupsManagerCommand c = GroupsManagerCommandFactory.get(theCommand);
                Utility.logMessage("DEBUG", this.getClass().getName() + "::renderXML(): Got the '" + theCommand + "' command = " + (c != null));
                if (c != null) {
                    Utility.logMessage("DEBUG", this.getClass().getName() + "::renderXML(): setup parms and about to execute command");
                    try {
                        c.execute(sessionData);
                    }
                    catch (Exception e) {
                        Utility.logMessage("ERROR", e.toString(), e);
                        sessionData.feedback = "Error executing command " + theCommand + ": " + e.getMessage();
                    }
                }
            }
            if (Utility.hasValue(runtimeData.getParameter("grpPageForward"))) {
                sessionData.currentPage += Integer.parseInt(runtimeData.getParameter("grpPageForward"));
            }
            if (Utility.hasValue(runtimeData.getParameter("grpPageBack"))) {
                sessionData.currentPage -= Integer.parseInt(runtimeData.getParameter("grpPageBack"));
            }
        }
        if (sessionData.servantChannel != null) {
            try {
                Utility.logMessage("DEBUG", this.getClass().getName() + ".setRuntimeData(): Setting Servant runtimedata");
                sessionData.servantChannel.setRuntimeData(sessionData.runtimeData);
                if (sessionData.servantChannel.isFinished()) {
                    sessionData.servantChannel = null;
                    Enumeration rd2 = runtimeData.keys();
                    while (rd2.hasMoreElements()) {
                        runtimeData.remove(rd2.nextElement());
                    }
                    Utility.logMessage("DEBUG", this.getClass().getName() + ".setRuntimeData(): removed servant");
                } else {
                    Utility.logMessage("DEBUG", this.getClass().getName() + ".setRuntimeData(): servant Not Finished");
                }
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", this.getClass().getName() + ".setRuntimeDat(): Problem setting servant runtimedata " + e, e);
            }
        }
    }

    @Override
    public void setStaticData(ChannelStaticData sd) {
        try {
            CGroupsManagerSessionData sessionData = this.getSessionData();
            Utility.logMessage("DEBUG", this.getClass().getName() + "::setStaticData(): this = " + this);
            Utility.logMessage("DEBUG", this.getClass().getName() + "::setStaticData(): session Data = " + sessionData);
            Utility.logMessage("DEBUG", this.getClass().getName() + "::setStaticData(): sd = " + sd);
            sessionData.staticData = sd;
            IEntityGroup admin = GroupService.getDistinguishedGroup(GroupService.PORTAL_ADMINISTRATORS);
            IGroupMember currUser = AuthorizationService.instance().getGroupMember(sessionData.staticData.getAuthorizationPrincipal());
            sessionData.isAdminUser = admin.deepContains(currUser);
            sessionData.user = sessionData.staticData.getPerson();
            sessionData.authPrincipal = sd.getAuthorizationPrincipal();
            sessionData.model = GroupsManagerXML.getGroupsManagerXml(sessionData);
            Utility.logMessage("DEBUG", this.getClass().getName() + "::setStaticData(): staticData Person ID = " + sessionData.user.getID());
            for (Map.Entry m : sessionData.staticData.entrySet()) {
                Utility.logMessage("DEBUG", this.getClass().getName() + "::setStaticData(): staticData " + m.getKey() + " = " + m.getValue());
            }
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", e.toString(), e);
        }
    }

    @Override
    public String getOwnerName() {
        return "Groups Manager";
    }

    @Override
    public String[] getActivityTokens() {
        this.init();
        return activities.keySet().toArray(new String[0]);
    }

    @Override
    public String getOwnerToken() {
        return "org.jasig.portal.channels.groupsmanager.CGroupsManager";
    }

    @Override
    public String getActivityName(String token) {
        return (String)activities.get(token);
    }

    @Override
    public String[] getTargetTokens() {
        this.init();
        return this.targets.keySet().toArray(new String[0]);
    }

    @Override
    public String getTargetName(String token) {
        String r = (String)this.targets.get(token);
        if (r == null) {
            try {
                r = EntityNameFinderService.instance().getNameFinder(IEntityGroup.class).getName(token);
            }
            catch (Exception e) {
                Utility.logMessage("ERROR", e.toString(), e);
            }
        }
        return r;
    }

    @Override
    public ChannelCacheKey generateKey() {
        ChannelCacheKey cck;
        Utility.logMessage("DEBUG", this.getClass().getName() + "::generateKey(): this = " + this);
        CGroupsManagerSessionData sessionData = this.getSessionData();
        ChannelStaticData staticData = sessionData.staticData;
        if (sessionData.servantChannel == null) {
            cck = new ChannelCacheKey();
            cck.setKey(staticData.getChannelPublishId() + "-" + staticData.getChannelSubscribeId() + "-" + String.valueOf(staticData.getPerson().getID()));
            cck.setKeyValidity(this.vKey());
            Utility.logMessage("DEBUG", "CGroupsManager.generateKey():: [NO SERVANT] key = " + cck.getKey());
        } else {
            cck = ((ICacheable)((Object)sessionData.servantChannel)).generateKey();
            Utility.logMessage("DEBUG", "CGroupsManager.generateKey():: [SERVANT] key = " + cck.getKey());
        }
        Utility.logMessage("DEBUG", "CGroupsManager.generateKey():: ChannelCacheKey.getKeyValidity = " + cck.getKeyValidity());
        return cck;
    }

    private String vKey() {
        Utility.logMessage("DEBUG", this.getClass().getName() + "::vKey(): this = " + this);
        CGroupsManagerSessionData sessionData = this.getSessionData();
        String vkey = sessionData.currentPage + " - " + sessionData.feedback + " - " + sessionData.highlightedGroupID + " - " + sessionData.mode + " - " + sessionData.rootViewGroupID;
        Utility.logMessage("DEBUG", this.getClass().getName() + ".vKey() : vKey returns = " + vkey);
        return vkey;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        Utility.logMessage("DEBUG", this.getClass().getName() + "::isCacheValid(): this = " + this);
        CGroupsManagerSessionData sessionData = this.getSessionData();
        ChannelRuntimeData runtimeData = sessionData.runtimeData;
        boolean valid = false;
        if (sessionData.servantChannel == null) {
            if (validity != null && validity.equals(this.vKey()) && runtimeData.get("grpCommand") == null) {
                valid = true;
            }
            long time3 = Calendar.getInstance().getTime().getTime();
            Utility.logMessage("DEBUG", this.getClass().getName() + ".isCacheValid() time since setRD: " + String.valueOf(time3 - sessionData.startRD) + ", valid=" + valid);
        } else {
            valid = ((ICacheable)((Object)sessionData.servantChannel)).isCacheValid(validity);
        }
        return valid;
    }

    public synchronized CGroupsManagerSessionData getSessionData() {
        CGroupsManagerSessionData sd = this.sessionData;
        if (sd == null) {
            sd = new CGroupsManagerSessionData();
            sd.permissible = this;
            this.sessionData = sd;
        }
        Utility.logMessage("DEBUG", this.getClass().getName() + "::getSessionData(): sd = " + sd);
        return sd;
    }
}

