/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.cusermanager.provider;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMUserIdentityStore;
import org.jasig.portal.channels.cusermanager.IDataHandler;
import org.jasig.portal.channels.cusermanager.provider.Md5passwd;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.tools.DeleteUser;

@Deprecated
public class DefaultDataHandlerImpl
implements IDataHandler {
    private static final Log LOG = LogFactory.getLog(DefaultDataHandlerImpl.class);
    protected static final String SINGLEQUOTE = "'";
    protected static final String WILDCARD = "%";
    protected static final String UPDMASK = "{0}={1}, ";
    protected static final String UPDCONDMASK = " where USER_NAME={0}";
    protected static final String COUNTUSERS = "select count( USER_NAME ) as cnt from UP_PERSON_DIR where USER_NAME={0}";
    protected static final String ADDUSER = "insert into UP_PERSON_DIR ({0}) values ({1})";
    protected static final String UPDPWD = "update UP_PERSON_DIR set ENCRPTD_PSWD={0}, LST_PSWD_CGH_DT={1} where USER_NAME={2} ".toUpperCase();
    protected static final String USERSELECT = "select * from UP_PERSON_DIR {0} order by USER_NAME, FIRST_NAME, LAST_NAME";
    protected static final String ALLUSERS = MessageFormat.format("select * from UP_PERSON_DIR {0} order by USER_NAME, FIRST_NAME, LAST_NAME", "");
    protected static final String GETTHISUSER = MessageFormat.format("select * from UP_PERSON_DIR {0} order by USER_NAME, FIRST_NAME, LAST_NAME", "where USER_NAME = {0} ");
    protected static final String SEARCHUSERS = MessageFormat.format("select * from UP_PERSON_DIR {0} order by USER_NAME, FIRST_NAME, LAST_NAME", "where USER_NAME like {0} or LAST_NAME like {0} or FIRST_NAME like {0} ");
    private IUserIdentityStore rdbmuser = new RDBMUserIdentityStore();

    @Override
    public IPerson[] getAllUsers() throws Exception {
        return this.runQuery(ALLUSERS);
    }

    @Override
    public IPerson[] getAllUsersLike(String SearchString) throws Exception {
        return this.runQuery(SEARCHUSERS, SearchString + WILDCARD);
    }

    @Override
    public IPerson getUser(String UID) throws Exception {
        return this.runQuery(GETTHISUSER, UID)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserInformation(IPerson AnIndividual) throws Exception {
        StringBuffer updsql = new StringBuffer("update UP_PERSON_DIR set ".toUpperCase());
        String tmpcond = null;
        String worker = null;
        Enumeration<String> E = AnIndividual.getAttributeNames();
        while (E.hasMoreElements()) {
            worker = E.nextElement();
            if (worker.toLowerCase().indexOf("pswd") != -1) continue;
            if (!worker.equals("user_name")) {
                updsql.append(MessageFormat.format(UPDMASK, worker.toUpperCase(), SINGLEQUOTE + (String)AnIndividual.getAttribute(worker) + SINGLEQUOTE));
                continue;
            }
            tmpcond = MessageFormat.format(UPDCONDMASK.toUpperCase(), SINGLEQUOTE + (String)AnIndividual.getAttribute(worker) + SINGLEQUOTE);
        }
        updsql.setLength(updsql.length() - 2);
        updsql.append(tmpcond);
        LOG.debug((Object)("Issuing: " + updsql.toString()));
        Connection C = this.getDBConn();
        try {
            Statement statement = C.createStatement();
            try {
                statement.executeUpdate(updsql.toString());
            }
            finally {
                DefaultDataHandlerImpl.close(statement);
            }
        }
        finally {
            this.releaseConn(C);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(IPerson AnIndividual) throws Exception {
        boolean preexisting = false;
        Connection C = this.getDBConn();
        try {
            Statement statement = C.createStatement();
            try {
                ResultSet R = statement.executeQuery(MessageFormat.format(COUNTUSERS, SINGLEQUOTE + AnIndividual.getAttribute("user_name") + SINGLEQUOTE));
                try {
                    R.next();
                    if (R.getInt("cnt") > 0) {
                        preexisting = true;
                    }
                }
                finally {
                    DefaultDataHandlerImpl.close(R);
                }
            }
            finally {
                DefaultDataHandlerImpl.close(statement);
            }
        }
        finally {
            this.releaseConn(C);
        }
        if (preexisting) {
            throw new Exception(MessageFormat.format("Username \"{0}\" already exists!", (String)AnIndividual.getAttribute("user_name")));
        }
        StringBuffer fields = new StringBuffer("");
        StringBuffer values = new StringBuffer("");
        String worker = null;
        Enumeration<String> E = AnIndividual.getAttributeNames();
        while (E.hasMoreElements()) {
            worker = E.nextElement();
            fields.append(worker + ", ");
            values.append(SINGLEQUOTE + AnIndividual.getAttribute(worker) + SINGLEQUOTE + ", ");
        }
        fields.setLength(fields.length() - 2);
        values.setLength(values.length() - 2);
        C = this.getDBConn();
        try {
            Statement statement = C.createStatement();
            try {
                statement.execute(MessageFormat.format(ADDUSER, fields.toString(), values.toString()));
            }
            finally {
                DefaultDataHandlerImpl.close(statement);
            }
        }
        finally {
            this.releaseConn(C);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserPassword(IPerson AnIndividual, String OriginalPassword) throws Exception {
        if (OriginalPassword != null && !Md5passwd.verifyPassword((String)AnIndividual.getAttribute("user_name"), OriginalPassword)) {
            throw new Exception("Password NOT changed!\r\nCurrent Password does  not match stored password.");
        }
        String newpwd = "*LCK*";
        if (!((String)AnIndividual.getAttribute("encrptd_pswd")).equals("NULLIFY.THIS.USER")) {
            newpwd = Md5passwd.encode((String)AnIndividual.getAttribute("encrptd_pswd"));
        }
        Connection C = this.getDBConn();
        try {
            Statement statement = C.createStatement();
            try {
                statement.execute(MessageFormat.format(UPDPWD, SINGLEQUOTE + newpwd + SINGLEQUOTE, RDBMServices.getDbMetaData().sqlTimeStamp(new Date()), SINGLEQUOTE + (String)AnIndividual.getAttribute("user_name") + SINGLEQUOTE));
            }
            finally {
                DefaultDataHandlerImpl.close(statement);
            }
        }
        finally {
            this.releaseConn(C);
        }
    }

    @Override
    public void removeUser(IPerson AnIndividual) throws Exception {
        PersonImpl per = new PersonImpl();
        per.setAttribute("username", AnIndividual.getAttribute("user_name"));
        int portalUID = -1;
        try {
            portalUID = this.rdbmuser.getPortalUID(per, false);
        }
        catch (AuthorizationException ae) {
            // empty catch block
        }
        if (portalUID > -1) {
            this.rdbmuser.removePortalUID(portalUID);
            String userName = (String)AnIndividual.getAttribute("user_name");
            IGroupMember gm = GroupService.getGroupMember(userName, IPerson.class);
            Iterator itr = gm.getContainingGroups();
            while (itr.hasNext()) {
                IEntityGroup group = (IEntityGroup)itr.next();
                if (!group.isEditable()) continue;
                ILockableEntityGroup lg = GroupService.findLockableGroup(group.getKey(), this.getClass().getName());
                lg.removeMember(gm);
                lg.update();
                LOG.info((Object)("Removed " + userName + " from " + group.getKey()));
            }
            DeleteUser.deleteBookmarks(portalUID);
        }
        AnIndividual.setAttribute("encrptd_pswd", "NULLIFY.THIS.USER");
        this.setUserPassword(AnIndividual, null);
    }

    private Connection getDBConn() {
        return RDBMServices.getConnection();
    }

    private void releaseConn(Connection C) {
        RDBMServices.releaseConnection(C);
    }

    private IPerson[] runQuery(String Query) throws Exception {
        return this.runQuery(Query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPerson[] runQuery(String Query, String Conditional) throws Exception {
        IPerson[] result = null;
        Connection C = this.getDBConn();
        try {
            Statement statement = C.createStatement();
            try {
                ResultSet R = statement.executeQuery(Conditional == null ? Query : MessageFormat.format(Query, SINGLEQUOTE + Conditional + SINGLEQUOTE));
                try {
                    result = this.mkIPeople(R);
                }
                finally {
                    DefaultDataHandlerImpl.close(R);
                }
            }
            finally {
                DefaultDataHandlerImpl.close(statement);
            }
        }
        finally {
            this.releaseConn(C);
        }
        return result;
    }

    private IPerson[] mkIPeople(ResultSet R) throws Exception {
        Vector<PersonImpl> v = new Vector<PersonImpl>();
        PersonImpl person = null;
        while (R.next()) {
            person = new PersonImpl();
            for (int i = 1; i <= R.getMetaData().getColumnCount(); ++i) {
                if (R.getMetaData().getColumnType(i) != 93) {
                    person.setAttribute(R.getMetaData().getColumnName(i).toLowerCase(), R.getString(i) == null ? "" : R.getString(i));
                    continue;
                }
                person.setAttribute(R.getMetaData().getColumnName(i).toLowerCase(), R.getString(i) == null ? "" : RDBMServices.getDbMetaData().sqlTimeStamp(new Date(R.getTimestamp(i).getTime())));
            }
            v.addElement(person);
        }
        PersonImpl pwdtst = null;
        IPerson[] people = new IPerson[v.size()];
        for (int i = 0; i < people.length; ++i) {
            people[i] = (IPerson)v.elementAt(i);
            try {
                pwdtst = new PersonImpl();
                pwdtst.setAttribute("username", people[i].getAttribute("user_name"));
                this.rdbmuser.getPortalUID(pwdtst, false);
                continue;
            }
            catch (AuthorizationException ae) {
                people[i].setAttribute("encrptd_pswd", "Acc.Is.Locked");
            }
        }
        return people;
    }

    private static void close(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException e) {
            LOG.warn((Object)"failed to close statement", (Throwable)e);
        }
    }

    private static void close(ResultSet resultSet) {
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            LOG.warn((Object)"failed to close resultset", (Throwable)e);
        }
    }

    static {
        LOG.debug((Object)"USERSELECT: select * from UP_PERSON_DIR {0} order by USER_NAME, FIRST_NAME, LAST_NAME");
        LOG.debug((Object)("ALLUSERS: " + ALLUSERS));
        LOG.debug((Object)("GETTHISUSER: " + GETTHISUSER));
        LOG.debug((Object)("SEARCHUSERS: " + SEARCHUSERS));
        LOG.debug((Object)"ADDUSER: insert into UP_PERSON_DIR ({0}) values ({1})");
        LOG.debug((Object)"UPDMASK: {0}={1}, ");
        LOG.debug((Object)"UPDCONDMASK:  where USER_NAME={0}");
        LOG.debug((Object)("UPDPWD: " + UPDPWD));
    }
}

