/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AbstractChannelRegistryStore;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.channel.dao.IChannelDefinitionDao;
import org.jasig.portal.channel.dao.IChannelTypeDao;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;

@Deprecated
public final class JpaChannelRegistryStore
extends AbstractChannelRegistryStore {
    private IChannelDefinitionDao channelDao;
    private IChannelTypeDao channelTypeDao;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private Log log = LogFactory.getLog(JpaChannelRegistryStore.class);

    public void setChannelDao(IChannelDefinitionDao channelDao) {
        this.channelDao = channelDao;
    }

    public void setChannelTypeDao(IChannelTypeDao channelTypeDao) {
        this.channelTypeDao = channelTypeDao;
    }

    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Override
    public IChannelDefinition newChannelDefinition(int channelTypeId, String fname, String clazz, String name, String title) {
        IChannelType channelType = this.getChannelType(channelTypeId);
        if (channelType == null) {
            throw new IllegalArgumentException("No IChannelType exists for id " + channelTypeId);
        }
        return this.channelDao.createChannelDefinition(channelType, fname, clazz, name, title);
    }

    @Override
    public IChannelDefinition getChannelDefinition(int channelId) {
        return this.channelDao.getChannelDefinition(channelId);
    }

    @Override
    public IChannelDefinition getChannelDefinition(String fname) {
        return this.channelDao.getChannelDefinition(fname);
    }

    @Override
    public IChannelDefinition getChannelDefinitionByName(String name) {
        return this.channelDao.getChannelDefinitionByName(name);
    }

    @Override
    public void saveChannelDefinition(IChannelDefinition channelDef) {
        int channelId = channelDef.getId();
        this.channelDao.updateChannelDefinition(channelDef);
        if (channelId < 0) {
            IChannelDefinition newChannel = this.getChannelDefinition(channelDef.getFName());
            channelId = newChannel.getId();
        }
    }

    @Override
    public void deleteChannelDefinition(IChannelDefinition channelDef) {
        this.channelDao.deleteChannelDefinition(channelDef);
    }

    @Override
    public List<IChannelDefinition> getChannelDefinitions() {
        List<IChannelDefinition> defs = this.channelDao.getChannelDefinitions();
        return defs;
    }

    @Override
    public List<IChannelDefinition> getChannelDefinitions(IPerson person) {
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        List<IChannelDefinition> defs = this.channelDao.getChannelDefinitions();
        ArrayList<IChannelDefinition> manageableChannels = new ArrayList<IChannelDefinition>();
        for (IChannelDefinition def : defs) {
            if (!ap.canSubscribe(def.getId())) continue;
            manageableChannels.add(def);
        }
        return manageableChannels;
    }

    @Override
    public IChannelType newChannelType(String name, String clazz, String cpdUri) {
        return this.channelTypeDao.createChannelType(name, clazz, cpdUri);
    }

    @Override
    public IChannelType getOrCreateChannelType(String name, String clazz, String cpdUri) {
        IChannelType channelType = this.getChannelType(name);
        if (channelType != null) {
            return channelType;
        }
        return this.newChannelType(name, clazz, cpdUri);
    }

    @Override
    public IChannelType getChannelType(int channelTypeId) {
        return this.channelTypeDao.getChannelType(channelTypeId);
    }

    @Override
    public IChannelType getChannelType(String name) {
        return this.channelTypeDao.getChannelType(name);
    }

    @Override
    public List<IChannelType> getChannelTypes() {
        return this.channelTypeDao.getChannelTypes();
    }

    @Override
    public IChannelType saveChannelType(IChannelType chanType) {
        return this.channelTypeDao.updateChannelType(chanType);
    }

    @Override
    public void deleteChannelType(IChannelType chanType) {
        this.channelTypeDao.deleteChannelType(chanType);
    }
}

