/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.ChannelDefinitionTagHandler;
import org.jasig.portal.car.ChannelTypeTagHandler;
import org.jasig.portal.car.ComponentTagHandler;
import org.jasig.portal.car.DatabaseTagHandler;
import org.jasig.portal.car.ExtensionTagHandler;
import org.jasig.portal.car.ParsingContext;
import org.jasig.portal.car.Path;
import org.jasig.portal.car.PathRouter;
import org.jasig.portal.car.WorkerTagHandler;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptorHandler {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log log = LogFactory.getLog(DescriptorHandler.class);
    private Properties workers = new Properties();
    private SAX2BufferImpl services = new SAX2BufferImpl();
    public static final String COMPONENT_TAG_NAME = "component";
    public static final String WORKER_TAG_NAME = "worker";
    public static final String SERVICE_TAG_NAME = "service";
    public static final String EXTENSION_TAG_NAME = "ext";
    public static final String CHANDEF_TAG_NAME = "channel-definition";
    public static final String CHANTYPE_TAG_NAME = "channel-type";
    public static final String DATABASE_TAG_NAME = "database";
    public static final String PROCESS_TAG_NAME = "processIf";
    public static final Path COMPONENT = Path.fromTag("component");
    public static final Path WORKERS = new Path().append("component").append("worker");
    public static final Path PROCESS = new Path().append("component").append("processIf");
    public static final Path SERVICES = new Path().append("component").append("service");
    public static final Path EXTENSIONS = new Path().append("component").append("ext");
    public static final Path CHANDEFS = new Path().append("component").append("channel-definition");
    public static final Path CHANTYPES = new Path().append("component").append("channel-type");
    public static final Path DBDEFS = new Path().append("component").append("database");

    DescriptorHandler(JarFile jarFile) {
        ParsingContext ctx = new ParsingContext(jarFile);
        PathRouter[] routers = new PathRouter[]{new PathRouter(WORKERS, new WorkerTagHandler(this.workers)), new PathRouter(SERVICES, this.services), new PathRouter(EXTENSIONS, new ExtensionTagHandler(ctx)), new PathRouter(CHANDEFS, new ChannelDefinitionTagHandler(ctx)), new PathRouter(CHANTYPES, new ChannelTypeTagHandler(ctx)), new PathRouter(DBDEFS, new DatabaseTagHandler(ctx))};
        this.parseDescriptor(jarFile, new ComponentTagHandler(ctx, routers));
    }

    private void parseDescriptor(JarFile jarFile, ComponentTagHandler handler) {
        ZipEntry entry = jarFile.getEntry("META-INF/comp.xml");
        SAXParser parser = null;
        InputStream is = null;
        if (entry == null) {
            return;
        }
        try {
            is = jarFile.getInputStream(entry);
            parser = SAXParserFactory.newInstance().newSAXParser();
            this.doParse(jarFile, handler, parser, is);
        }
        catch (ZipException ze) {
            log.error((Object)("The zip entry META-INF/comp.xml in " + jarFile.getName() + " has an invalid format. Details: " + ze));
        }
        catch (IOException ioe) {
            log.error((Object)("Unable to read entry META-INF/comp.xml in " + jarFile.getName() + ". Details: " + ioe));
        }
        catch (SecurityException se) {
            log.error((Object)("Unable to read entry META-INF/comp.xml in " + jarFile.getName() + " because some entries are incorrectly signed. " + "Details: " + se));
        }
        catch (FactoryConfigurationError fce) {
            log.error((Object)("Unable to read entry META-INF/comp.xml in " + jarFile.getName() + " because a parser factory could not be created." + " Details: " + fce));
        }
        catch (ParserConfigurationException pce) {
            log.error((Object)("Unable to read entry META-INF/comp.xml in " + jarFile.getName() + " because a parser could not be created." + " Details: " + pce));
        }
        catch (SAXException sxe) {
            log.error((Object)("Unable to read entry META-INF/comp.xml in " + jarFile.getName() + " because a parser could not be created." + " Details: " + sxe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParse(JarFile jarFile, ComponentTagHandler handler, SAXParser parser, InputStream is) {
        try {
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (RuntimeException re) {
            log.error((Object)("Unable to completely parse entry META-INF/comp.xml in " + jarFile.getName() + " because a fatal parser error occurred. "), (Throwable)re);
        }
        catch (IOException ioe) {
            log.error((Object)("Unable to completely parse entry META-INF/comp.xml in " + jarFile.getName()), (Throwable)ioe);
        }
        catch (SAXException sxe) {
            log.error((Object)("Unable to completely parse entry META-INF/comp.xml in " + jarFile.getName()), (Throwable)sxe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)"Unable to close inputStream", (Throwable)ioe);
            }
        }
    }

    public synchronized void getWorkers(Properties p) {
        if (this.workers.size() > 0) {
            for (Map.Entry<Object, Object> e : this.workers.entrySet()) {
                if (p.containsKey(e.getKey())) continue;
                p.put(e.getKey(), e.getValue());
            }
        }
    }

    public synchronized void getServices(ContentHandler c) throws SAXException {
        if (!this.services.isEmpty()) {
            this.services.outputBuffer(c);
        }
    }
}

