/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.ByteArrayInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.car.ParsingContext;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.tools.chanpub.ChannelPublisher;
import org.jasig.portal.tools.chanpub.IChannelPublisher;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultChanPubInnerHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(DefaultChanPubInnerHandler.class);
    private ParsingContext ctx = null;
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer charBuf = new StringBuffer();

    public DefaultChanPubInnerHandler(ParsingContext ctx) {
        this.ctx = ctx;
        this.buffer.append("<!DOCTYPE channel-definition SYSTEM \"channelDefinition.dtd\">");
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.buffer.append('<');
        this.buffer.append(qName);
        this.buffer.append('>');
        this.charBuf = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charBuf.append(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        block5: {
            this.buffer.append(this.charBuf.toString());
            this.buffer.append("</");
            this.buffer.append(qName);
            this.buffer.append('>');
            this.charBuf = new StringBuffer();
            if (qName.equals("channel-definition") && this.ctx.getPath().equals(DescriptorHandler.CHANDEFS)) {
                try {
                    byte[] bytes = this.buffer.toString().getBytes();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("CAR channel definition '" + this.buffer.toString() + "' ready to publish."));
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    IChannelPublisher publisher = ChannelPublisher.getChannelArchiveInstance();
                    IChannelDefinition chanDef = null;
                    chanDef = publisher.publishChannel(is);
                    if (chanDef != null && log.isInfoEnabled()) {
                        log.info((Object)(" Successfully published channel " + chanDef.getTitle() + " with fname " + chanDef.getFName()));
                    }
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) break block5;
                    log.info((Object)"A problem occurred during auto publishing.", (Throwable)e);
                }
            }
        }
    }
}

