/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.car.ParsingContext;
import org.jasig.portal.spring.locator.DbLoaderLocator;
import org.jasig.portal.tools.dbloader.DbLoaderConfiguration;
import org.jasig.portal.tools.dbloader.IDbLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseTagHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(DatabaseTagHandler.class);
    private boolean CREATE_SCRPT_DFLT = false;
    private boolean POP_TBL_DFLT = true;
    private boolean CREATE_TBL_DFLT = true;
    private boolean DROP_TBL_DFLT = false;
    private boolean createScript;
    private boolean populateTables;
    private boolean createTables;
    private boolean dropTables;
    private ParsingContext ctx = null;
    private String tables = null;
    private String data = null;
    private StringBuffer chars = null;

    DatabaseTagHandler(ParsingContext ctx) {
        this.ctx = ctx;
        this.resetValues();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.chars = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.chars.append(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("tables")) {
            this.tables = this.chars.toString();
        } else if (qName.equals("data")) {
            this.data = this.chars.toString();
        } else if (qName.equals("drop-tables")) {
            this.dropTables = this.getBoolean(this.chars.toString(), this.DROP_TBL_DFLT);
        } else if (qName.equals("create-tables")) {
            this.createTables = this.getBoolean(this.chars.toString(), this.CREATE_TBL_DFLT);
        } else if (qName.equals("populate-tables")) {
            this.populateTables = this.getBoolean(this.chars.toString(), this.POP_TBL_DFLT);
        } else if (qName.equals("create-script")) {
            this.createScript = this.getBoolean(this.chars.toString(), this.CREATE_SCRPT_DFLT);
        } else if (qName.equals("database") && this.ctx.getPath().equals(DescriptorHandler.DBDEFS)) {
            this.loadDatabase();
            this.resetValues();
        }
    }

    private boolean getBoolean(String string, boolean deflt) {
        if (string == null) {
            return deflt;
        }
        if (string.equals("false")) {
            return false;
        }
        if (string.equals("true")) {
            return true;
        }
        return deflt;
    }

    private void resetValues() {
        this.tables = null;
        this.data = null;
        this.dropTables = this.DROP_TBL_DFLT;
        this.createTables = this.CREATE_TBL_DFLT;
        this.createScript = this.CREATE_SCRPT_DFLT;
        this.populateTables = this.POP_TBL_DFLT;
    }

    private void loadDatabase() {
        if (this.tables == null) {
            log.error((Object)"A database declaration in a channel deployment descriptor must contain a non-empty <tables> element to successfully create tables for the channel and populate them with data. Declaration ignored.");
            return;
        }
        try {
            URL tablesURL;
            ClassLoader cl = CarResources.getInstance().getClassLoader();
            URL dataURL = null;
            if (this.data != null && (dataURL = cl.getResource(this.data)) == null) {
                log.error((Object)("JAR file = '" + this.ctx.getJarFile().getName() + "' unable to find specified data file '" + this.data + "'"));
            }
            if ((tablesURL = cl.getResource(this.tables)) == null) {
                log.error((Object)("JAR file = '" + this.ctx.getJarFile().getName() + "' unable to find specified tables file '" + this.tables + "'"));
            }
            if (this.data != null && dataURL == null || tablesURL == null) {
                return;
            }
            DbLoaderConfiguration config = new DbLoaderConfiguration(this.dropTables, this.createTables, this.populateTables, (Resource)new UrlResource(this.tables), (Resource)new UrlResource(this.data), null);
            String dataString = "(no data definition)";
            if (dataURL != null) {
                dataString = dataURL.toString();
            }
            IDbLoader dbLoader = DbLoaderLocator.getDbLoader();
            try {
                dbLoader.process(config);
                if (log.isInfoEnabled()) {
                    log.info((Object)("***** Successfully processed *****\n" + tablesURL + " and \n" + dataString));
                }
            }
            catch (Exception e) {
                log.error((Object)("***** Failure during processing ***** \n" + tablesURL + " and \n" + dataString), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem occurred while loading database from CAR.", (Throwable)e);
        }
    }
}

