/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.car.DefaultChanPubInnerHandler;
import org.jasig.portal.car.DescriptorHandler;
import org.jasig.portal.car.ParsingContext;
import org.jasig.portal.properties.PropertiesManager;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChannelDefinitionTagHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ChannelDefinitionTagHandler.class);
    private static Class cHandlerClass = null;
    private static Constructor cDefaultConstructor = null;
    private static Constructor cExtendedConstructor = null;
    private ContentHandler handlerInstance = null;
    private ParsingContext ctx = null;
    private static final String HANDLER_PROPERTY = "org.jasig.portal.car.ChannelDefinition.contentHandler";

    ChannelDefinitionTagHandler(ParsingContext ctx) {
        this.ctx = ctx;
        if (cHandlerClass == null) {
            this.initialize();
        }
    }

    private void initialize() {
        String declaredClass = null;
        try {
            declaredClass = PropertiesManager.getProperty(HANDLER_PROPERTY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (declaredClass != null) {
            this.loadTheClass(declaredClass);
        } else {
            cHandlerClass = DefaultChanPubInnerHandler.class;
        }
        if (cHandlerClass != null) {
            this.getTheConstructor();
        }
    }

    private void loadTheClass(String handlerClass) {
        try {
            CarResources cRes = CarResources.getInstance();
            ClassLoader cl = cRes.getClassLoader();
            cHandlerClass = cl.loadClass(handlerClass);
        }
        catch (ClassNotFoundException clfe) {
            log.error((Object)("Specified contentHandler class " + handlerClass + " specified in portal.properties not found. " + "Ignoring channel-definition block " + "in deployment descriptor of " + this.ctx.getJarFile().getName() + "."));
        }
    }

    private void getTheConstructor() {
        try {
            cExtendedConstructor = cHandlerClass.getConstructor(ParsingContext.class);
            return;
        }
        catch (NoSuchMethodException nsme) {
            try {
                cDefaultConstructor = cHandlerClass.getConstructor(null);
            }
            catch (NoSuchMethodException nsme2) {
                log.error((Object)("Niether Extended constructor nor default, zero parameter constructor were found for specified contentHandler class " + cHandlerClass.getName() + " specified in portal.properties. Ignoring " + "channel-definition block " + "in deployment descriptor of " + this.ctx.getJarFile().getName() + "."), (Throwable)nsme2);
            }
            return;
        }
    }

    private Object instantiateTheClass() {
        Object obj = null;
        try {
            if (cExtendedConstructor != null) {
                obj = cExtendedConstructor.newInstance(this.ctx);
            } else if (cDefaultConstructor != null) {
                obj = cDefaultConstructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to create specified contentHandler class " + cHandlerClass.getName() + " specified in portal.properties. Ignoring " + "channel-definition block " + "in deployment descriptor of " + this.ctx.getJarFile().getName() + "."), (Throwable)e);
        }
        return obj;
    }

    private ContentHandler castToContentHandler(Object obj) {
        ContentHandler handler = null;
        try {
            handler = (ContentHandler)obj;
        }
        catch (ClassCastException cce) {
            log.error((Object)("ContentHandler class " + obj.getClass().getName() + " specified in portal.properties" + " does not implement ContentHandler." + " Ignoring channel-definition block in" + " deployment descriptor of " + this.ctx.getJarFile().getName() + "."));
        }
        return handler;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("channel-definition") && this.ctx.getPath().equals(DescriptorHandler.CHANDEFS) && cHandlerClass != null) {
            Object obj = this.instantiateTheClass();
            this.handlerInstance = this.castToContentHandler(obj);
        }
        if (this.handlerInstance != null) {
            this.handlerInstance.startElement(namespaceURI, localName, qName, atts);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.handlerInstance != null) {
            this.handlerInstance.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.handlerInstance != null) {
            this.handlerInstance.endElement(namespaceURI, localName, qName);
        }
        if (qName.equals("channel-definition") && this.ctx.getPath().equals(DescriptorHandler.CHANDEFS)) {
            this.handlerInstance = null;
        }
    }
}

