/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.jndi.IJndiManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutManagerFactory;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.locator.JndiManagerLocator;
import org.jasig.portal.utils.PropsMatcher;
import org.w3c.dom.Document;

public class UserPreferencesManager
implements IUserPreferencesManager {
    private static final String BROWSER_MAPPINGS_PROPERTIES = "/properties/browser.mappings";
    private static final String USER_PREFERENCES_KEY = UserPreferencesManager.class.getName();
    private static final boolean DEFAULT_SAVE_USER_PREFERENCES_AT_LOGOUT = false;
    private static final boolean saveUserPreferencesAtLogout = PropertiesManager.getPropertyAsBoolean(UserPreferencesManager.class.getName() + ".save_UserPreferences_at_logout", false);
    private static PropsMatcher userAgentMatcher;
    protected static final Log logger;
    private IUserLayoutManager userLayoutManager;
    private UserPreferences completeUserPreferences;
    private ThemeStylesheetDescription themeStylesheetDescription;
    private StructureStylesheetDescription structureStylesheetDescription;
    private boolean unmappedUserAgent;
    private final IPerson person;
    IUserLayoutStore userLayoutStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PropsMatcher getUserAgentMatcher() {
        if (userAgentMatcher == null) {
            InputStream userAgentMatcherStream = null;
            try {
                userAgentMatcherStream = UserPreferencesManager.class.getResourceAsStream(BROWSER_MAPPINGS_PROPERTIES);
                userAgentMatcher = new PropsMatcher(userAgentMatcherStream);
            }
            catch (IOException ioe) {
                logger.error((Object)"Failed to load browser mapping file: '/properties/browser.mappings'", (Throwable)ioe);
            }
            finally {
                IOUtils.closeQuietly((InputStream)userAgentMatcherStream);
            }
        }
        return userAgentMatcher;
    }

    public UserPreferencesManager(HttpServletRequest req, IPerson person) throws PortalException {
        this(req, person, null);
    }

    public UserPreferencesManager(HttpServletRequest req, IPerson person, LocaleManager localeManager) throws PortalException {
        block17: {
            this.unmappedUserAgent = false;
            this.userLayoutStore = null;
            this.userLayoutManager = null;
            try {
                String profileFname;
                PropsMatcher userAgentMatcher;
                UserProfile userProfile;
                this.person = person;
                this.userLayoutStore = UserLayoutStoreFactory.getUserLayoutStoreImpl();
                String userAgent = req.getHeader("User-Agent");
                if (StringUtils.isEmpty((String)userAgent)) {
                    userAgent = "null";
                }
                if ((userProfile = this.userLayoutStore.getUserProfile(this.person, userAgent)) == null) {
                    userProfile = this.userLayoutStore.getSystemProfile(userAgent);
                }
                if (userProfile == null && (userAgentMatcher = UserPreferencesManager.getUserAgentMatcher()) != null && (profileFname = userAgentMatcher.match(userAgent)) != null && (userProfile = this.userLayoutStore.getUserProfileByFname(person, profileFname)) == null) {
                    userProfile = this.userLayoutStore.getSystemProfileByFname(profileFname);
                }
                if (userProfile != null) {
                    if (localeManager != null && LocaleManager.isLocaleAware()) {
                        userProfile.setLocaleManager(localeManager);
                    }
                    this.userLayoutManager = UserLayoutManagerFactory.getUserLayoutManager(this.person, userProfile);
                    HttpSession session = req.getSession(true);
                    try {
                        if (session != null) {
                            this.completeUserPreferences = (UserPreferences)session.getAttribute(USER_PREFERENCES_KEY);
                        }
                        if (this.completeUserPreferences == null) {
                            this.completeUserPreferences = this.userLayoutStore.getUserPreferences(this.person, userProfile);
                        } else {
                            logger.debug((Object)"Found UserPreferences in session, using it instead of creating new UserPreferences");
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("UserPreferencesManager(): caught an exception trying to retreive user preferences for user=\"" + this.person.getID() + "\", profile=\"" + userProfile.getProfileName() + "\"."), (Throwable)e);
                        this.completeUserPreferences = new UserPreferences(userProfile);
                    }
                    if (this.completeUserPreferences != null) {
                        session.setAttribute(USER_PREFERENCES_KEY, (Object)this.completeUserPreferences);
                    }
                    try {
                        IJndiManager jndiManager = JndiManagerLocator.getJndiManager();
                        String userId = Integer.toString(this.person.getID());
                        String layoutId = Integer.toString(userProfile.getLayoutId());
                        Document userLayoutDom = this.userLayoutManager.getUserLayoutDOM();
                        jndiManager.initializeSessionContext(session, userId, layoutId, userLayoutDom);
                    }
                    catch (PortalException ipe) {
                        logger.error((Object)"UserPreferencesManager(): Could not properly initialize user context", (Throwable)ipe);
                    }
                    break block17;
                }
                this.unmappedUserAgent = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("UserPreferencesManager::UserPreferencesManager() : unable to find a profile for user \"" + this.person.getID() + "\" and userAgent=\"" + userAgent + "\"."));
                }
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Exception e) {
                String msg = "Exception constructing UserPreferencesManager on request " + req + " for user " + this.person;
                logger.error((Object)msg, (Throwable)e);
                throw new PortalException(msg, (Throwable)e);
            }
        }
    }

    UserPreferencesManager(IPerson person) {
        this.unmappedUserAgent = false;
        this.userLayoutStore = null;
        this.person = person;
    }

    @Override
    public IPerson getPerson() {
        return this.person;
    }

    protected String getChannelPublishId(String channelSubscribeId) throws PortalException {
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)this.getUserLayoutManager().getNode(channelSubscribeId);
        if (channel != null) {
            return channel.getChannelPublishId();
        }
        return null;
    }

    @Override
    public boolean isUserAgentUnmapped() {
        return this.unmappedUserAgent;
    }

    @Override
    public void setNewUserLayoutAndUserPreferences(IUserLayoutManager newUlm, UserPreferences newPreferences) throws PortalException {
        try {
            if (newPreferences != null) {
                if (!this.completeUserPreferences.getProfile().getProfileFname().equals(newPreferences.getProfile().getProfileFname()) || this.completeUserPreferences.getProfile().isSystemProfile() != newPreferences.getProfile().isSystemProfile()) {
                    this.userLayoutManager = newUlm != null && newUlm.getLayoutId() == newPreferences.getProfile().getLayoutId() ? newUlm : UserLayoutManagerFactory.getUserLayoutManager(this.person, newPreferences.getProfile());
                }
                this.userLayoutStore.putUserPreferences(this.person, newPreferences);
                this.completeUserPreferences = newPreferences;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception setting new user layout manager " + newUlm + " and/or new prefererences " + newPreferences), (Throwable)e);
            throw new GeneralRenderingException(e);
        }
    }

    @Override
    public IUserLayoutManager getUserLayoutManager() {
        return this.userLayoutManager;
    }

    @Override
    public void finishedSession(HttpSession session) {
        try {
            if (saveUserPreferencesAtLogout) {
                this.userLayoutStore.putUserPreferences(this.person, this.completeUserPreferences);
                this.userLayoutManager.saveUserLayout();
            }
        }
        catch (Exception e) {
            logger.error((Object)"UserPreferencesManager::finishedSession() : unable to persist layout upon session termination !", (Throwable)e);
        }
    }

    @Override
    public UserPreferences getUserPreferencesCopy() {
        return new UserPreferences(this.getUserPreferences());
    }

    @Override
    public UserProfile getCurrentProfile() {
        return this.getUserPreferences().getProfile();
    }

    @Override
    public ThemeStylesheetDescription getThemeStylesheetDescription() throws Exception {
        if (this.themeStylesheetDescription == null) {
            this.themeStylesheetDescription = this.userLayoutStore.getThemeStylesheetDescription(this.getCurrentProfile().getThemeStylesheetId());
        }
        return this.themeStylesheetDescription;
    }

    @Override
    public StructureStylesheetDescription getStructureStylesheetDescription() throws Exception {
        if (this.structureStylesheetDescription == null) {
            this.structureStylesheetDescription = this.userLayoutStore.getStructureStylesheetDescription(this.getCurrentProfile().getStructureStylesheetId());
        }
        return this.structureStylesheetDescription;
    }

    @Override
    public UserPreferences getUserPreferences() {
        return this.completeUserPreferences;
    }

    static {
        logger = LogFactory.getLog(UserPreferencesManager.class);
    }
}

