/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.UserPreferencesManager;
import org.jasig.portal.events.EventPublisherLocator;
import org.jasig.portal.events.support.UserSessionCreatedPortalEvent;
import org.jasig.portal.events.support.UserSessionDestroyedPortalEvent;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.user.IUserInstance;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class UserInstance
implements IUserInstance {
    private static final AtomicInteger userSessions = new AtomicInteger();
    protected final Log log = LogFactory.getLog(this.getClass());
    private final IUserPreferencesManager preferencesManager;
    private final ChannelManager channelManager;
    private final LocaleManager localeManager;
    private final Object renderingLock;
    private final IPerson person;

    public static long getUserSessions() {
        return userSessions.longValue();
    }

    public UserInstance(IPerson person, HttpServletRequest request) {
        this.person = person;
        String acceptLanguage = request.getHeader("Accept-Language");
        this.localeManager = new LocaleManager(person, acceptLanguage);
        this.preferencesManager = new UserPreferencesManager(request, this.person, this.localeManager);
        if (this.preferencesManager.isUserAgentUnmapped()) {
            this.log.warn((Object)"A Mapping User-Agent could not be found for the UserPreferencesManager");
        }
        HttpSession session = request.getSession(false);
        this.channelManager = new ChannelManager(this.preferencesManager, session);
        IUserLayoutManager userLayoutManager = this.preferencesManager.getUserLayoutManager();
        userLayoutManager.addLayoutEventListener(this.channelManager);
        this.renderingLock = new Object();
        ApplicationEventPublisher applicationEventPublisher = EventPublisherLocator.getApplicationEventPublisher();
        applicationEventPublisher.publishEvent((ApplicationEvent)new UserSessionCreatedPortalEvent(this, this.person));
        userSessions.incrementAndGet();
    }

    @Override
    public IPerson getPerson() {
        return this.person;
    }

    @Override
    public IUserPreferencesManager getPreferencesManager() {
        return this.preferencesManager;
    }

    @Override
    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    @Override
    public Object getRenderingLock() {
        return this.renderingLock;
    }

    @Override
    public void destroySession(HttpSession session) {
        if (this.channelManager != null) {
            this.channelManager.finishedSession(session);
            if (this.preferencesManager != null) {
                IUserLayoutManager userLayoutManager = this.preferencesManager.getUserLayoutManager();
                userLayoutManager.removeLayoutEventListener(this.channelManager);
            }
        }
        if (this.preferencesManager != null) {
            this.preferencesManager.finishedSession(session);
        }
        GroupService.finishedSession(this.person);
        ApplicationEventPublisher applicationEventPublisher = EventPublisherLocator.getApplicationEventPublisher();
        applicationEventPublisher.publishEvent((ApplicationEvent)new UserSessionDestroyedPortalEvent(this, this.person));
        userSessions.decrementAndGet();
    }
}

