/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.LoginServlet;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.events.EventPublisherLocator;
import org.jasig.portal.events.support.UserLoggedOutPortalEvent;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PersonManagerFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.springframework.context.ApplicationEvent;

public class LogoutServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(LogoutServlet.class);
    private static boolean INITIALIZED = false;
    private static String DEFAULT_REDIRECT;
    private static HashMap REDIRECT_MAP;

    public void init() throws ServletException {
        if (!INITIALIZED) {
            String upFile = "render.userLayoutRootNode.uP";
            HashMap<String, String> rdHash = new HashMap<String, String>(1);
            try {
                upFile = UPFileSpec.buildUPFile(0, "userLayoutRootNode", null, null);
                Properties props = ResourceLoader.getResourceAsProperties(LogoutServlet.class, "/properties/security.properties");
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propName = (String)propNames.nextElement();
                    String propValue = props.getProperty(propName);
                    if (!propName.startsWith("logoutRedirect.")) continue;
                    String key = propName.substring(15);
                    String string = key = key.startsWith("root.") ? key.substring(5) : key;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutServlet::initializer() Redirect key = " + key));
                        log.debug((Object)("LogoutServlet::initializer() Redirect value = " + propValue));
                    }
                    rdHash.put(key, propValue);
                }
            }
            catch (PortalException pe) {
                log.error((Object)"LogoutServlet::static ", (Throwable)pe);
            }
            catch (IOException ioe) {
                log.error((Object)"LogoutServlet::static", (Throwable)ioe);
            }
            REDIRECT_MAP = rdHash;
            DEFAULT_REDIRECT = upFile;
            INITIALIZED = true;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirect;
        block8: {
            this.init();
            redirect = this.getRedirectionUrl(request);
            HttpSession session = request.getSession(false);
            if (session != null) {
                try {
                    IPerson person = PersonManagerFactory.getPersonManagerInstance().getPerson(request);
                    if (person != null && person.getSecurityContext().isAuthenticated()) {
                        EventPublisherLocator.getApplicationEventPublisher().publishEvent((ApplicationEvent)new UserLoggedOutPortalEvent((Object)this, person));
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Exception recording logout associated with request " + request), (Throwable)e);
                }
                String originalUid = (String)session.getAttribute(LoginServlet.SWAP_ORIGINAL_UID);
                if (originalUid != null) {
                    redirect = request.getContextPath() + "/Login";
                } else {
                    try {
                        session.invalidate();
                    }
                    catch (IllegalStateException ise) {
                        if (!log.isTraceEnabled()) break block8;
                        log.trace((Object)"LogoutServlet encountered IllegalStateException invalidating a presumably already-invalidated session.", (Throwable)ise);
                    }
                }
            }
        }
        String encodedRedirectURL = response.encodeRedirectURL(redirect);
        response.sendRedirect(encodedRedirectURL);
    }

    private String getRedirectionUrl(HttpServletRequest request) {
        String defaultRedirect;
        String redirect;
        block13: {
            redirect = null;
            defaultRedirect = request.getContextPath() + '/' + DEFAULT_REDIRECT;
            IPerson person = null;
            if (REDIRECT_MAP == null) {
                return defaultRedirect;
            }
            try {
                person = PersonManagerFactory.getPersonManagerInstance().getPerson(request);
                if (person == null) break block13;
                ISecurityContext securityContext = person.getSecurityContext();
                if (securityContext.isAuthenticated()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"LogoutServlet::getRedirectionUrl() Looking for redirect string for the root context");
                    }
                    if ((redirect = (String)REDIRECT_MAP.get("root")) != null && !redirect.equals("")) {
                        return redirect;
                    }
                }
                Enumeration subCtxNames = securityContext.getSubContextNames();
                while (subCtxNames.hasMoreElements()) {
                    String subCtxName = (String)subCtxNames.nextElement();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutServlet::getRedirectionUrl()  subCtxName = " + subCtxName));
                    }
                    ISecurityContext sc = securityContext.getSubContext(subCtxName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutServlet::getRedirectionUrl() subCtxName isAuth = " + sc.isAuthenticated()));
                    }
                    if (!sc.isAuthenticated()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutServlet::getRedirectionUrl() Looking for redirect string for subCtxName = " + subCtxName));
                    }
                    if ((redirect = (String)REDIRECT_MAP.get(subCtxName)) == null || redirect.equals("")) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LogoutServlet::getRedirectionUrl() subCtxName redirect = " + redirect));
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)"LogoutServlet::getRedirectionUrl() Error:", (Throwable)e);
            }
        }
        if (redirect == null) {
            redirect = defaultRedirect;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("LogoutServlet::getRedirectionUrl() redirectionURL = " + redirect));
        }
        return redirect;
    }
}

