/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.services.HttpClientManager;

public class HttpProxyServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(HttpProxyServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String target;
        String checkReferer = PropertiesManager.getProperty(HttpProxyServlet.class.getName() + ".checkReferer", null);
        if (null != checkReferer && !checkReferer.equals("")) {
            StringTokenizer checkedReferers = new StringTokenizer(checkReferer, " ");
            boolean refOK = false;
            String referer = request.getHeader("Referer");
            if (log.isDebugEnabled()) {
                log.debug((Object)("HttpProxyServlet: HTTP Referer: " + referer));
            }
            if (null != referer) {
                while (checkedReferers.hasMoreTokens()) {
                    String goodRef = checkedReferers.nextToken();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("HttpProxyServlet: checking for " + goodRef));
                    }
                    if (!referer.startsWith(goodRef)) continue;
                    refOK = true;
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("HttpProxyServlet: referer accepted " + goodRef));
                    break;
                }
                if (!refOK) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("HttpProxyServlet: bad Referer: " + referer));
                    }
                    response.setStatus(404);
                    return;
                }
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("HttpProxyServlet: bad Referer: " + referer));
                }
                response.setStatus(404);
                return;
            }
        }
        if (request.getSession(false) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"HttpProxyServlet: no session");
            }
            response.setStatus(404);
            return;
        }
        if (request.getPathInfo() != null && !request.getPathInfo().equals("")) {
            target = "http:/" + request.getPathInfo();
            String qs = request.getQueryString();
            if (qs != null) {
                target = target + "?" + request.getQueryString();
            }
        } else {
            response.setStatus(404);
            log.warn((Object)"HttpProxyServlet: getPathInfo is empty");
            return;
        }
        try {
            HttpClient client = HttpClientManager.getNewHTTPClient();
            GetMethod get = new GetMethod(target);
            int rc = client.executeMethod((HttpMethod)get);
            if (rc != 200) {
                response.setStatus(404);
                log.info((Object)("httpProxyServlet returning response 404 after receiving response code: " + rc + " from url: " + "target"));
            }
            Header contentType = get.getResponseHeader("content-type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("httpProxyServlet examining element with content type = " + contentType));
            }
            if (!contentType.getValue().startsWith("image")) {
                response.setStatus(404);
                log.info((Object)("httpProxyServlet returning response 404 after receiving element with contentType =" + contentType));
                return;
            }
            response.setContentType(contentType.getValue());
            ServletOutputStream out = response.getOutputStream();
            try {
                InputStream is = get.getResponseBodyAsStream();
                try {
                    int bytesRead;
                    byte[] buf = new byte[4096];
                    while ((bytesRead = is.read(buf)) != -1) {
                        out.write(buf, 0, bytesRead);
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                out.close();
            }
        }
        catch (MalformedURLException e) {
            response.setStatus(404);
            log.warn((Object)("HttpProxyServlet: target=" + target.toString()), (Throwable)e);
        }
        catch (IOException e) {
            response.setStatus(404);
            log.warn((Object)e, (Throwable)e);
        }
    }
}

