/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.GuestUserPreferencesManager;
import org.jasig.portal.GuestUserPreferencesManagerWrapper;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.events.EventPublisherLocator;
import org.jasig.portal.events.support.UserSessionCreatedPortalEvent;
import org.jasig.portal.events.support.UserSessionDestroyedPortalEvent;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.user.IUserInstance;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class GuestUserInstance
implements IUserInstance {
    private static final AtomicInteger guestSessions = new AtomicInteger();
    protected final Log log = LogFactory.getLog(this.getClass());
    private final ChannelManager channelManager;
    private final LocaleManager localeManager;
    private final Object renderingLock;
    private final IPerson person;
    private final GuestUserPreferencesManagerWrapper userPreferencesManager;

    public static long getGuestSessions() {
        return guestSessions.longValue();
    }

    public GuestUserInstance(IPerson person, GuestUserPreferencesManager preferencesManager, HttpServletRequest request) {
        this.person = person;
        String acceptLanguage = request.getHeader("Accept-Language");
        this.localeManager = new LocaleManager(person, acceptLanguage);
        HttpSession session = request.getSession(false);
        String sessionId = session.getId();
        preferencesManager.setLocaleManager(this.localeManager);
        preferencesManager.registerSession(request);
        if (preferencesManager.isUserAgentUnmapped(sessionId)) {
            this.log.warn((Object)"A Mapping User-Agent could not be found for the GuestUserPreferencesManagerWrapper");
        }
        this.userPreferencesManager = new GuestUserPreferencesManagerWrapper(preferencesManager, sessionId);
        this.channelManager = new ChannelManager(this.userPreferencesManager, session);
        this.renderingLock = new Object();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("instance bound to a new session '" + request.getSession().getId() + "'"));
        }
        ApplicationEventPublisher applicationEventPublisher = EventPublisherLocator.getApplicationEventPublisher();
        applicationEventPublisher.publishEvent((ApplicationEvent)new UserSessionCreatedPortalEvent(this, person));
        guestSessions.incrementAndGet();
    }

    @Override
    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    @Override
    public IPerson getPerson() {
        return this.person;
    }

    @Override
    public IUserPreferencesManager getPreferencesManager() {
        return this.userPreferencesManager;
    }

    @Override
    public Object getRenderingLock() {
        return this.renderingLock;
    }

    @Override
    public void destroySession(HttpSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unbinding session '" + session.getId() + "'"));
        }
        this.channelManager.finishedSession(session);
        this.userPreferencesManager.finishedSession(session);
        ApplicationEventPublisher applicationEventPublisher = EventPublisherLocator.getApplicationEventPublisher();
        applicationEventPublisher.publishEvent((ApplicationEvent)new UserSessionDestroyedPortalEvent(this, this.person));
        guestSessions.decrementAndGet();
    }
}

