/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ErrorID;
import org.jasig.portal.Errors;
import org.jasig.portal.PortalException;
import org.jasig.portal.ProblemsTable;

public class ExceptionHelper {
    private static final Log log = LogFactory.getLog(ExceptionHelper.class);
    private static final String[] boundaries = new String[]{"at javax.servlet.http.HttpServlet."};

    public static String shortStackTrace(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        sw.flush();
        String stktr = sw.toString();
        return ExceptionHelper.trimStackTrace(stktr);
    }

    static String trimStackTrace(String stackTrace) {
        StringBuffer trimmedTrace = new StringBuffer();
        ArrayList<String> fragments = new ArrayList<String>();
        int causeCut = stackTrace.indexOf("Caused by");
        if (causeCut > 0) {
            while (stackTrace.length() > 0) {
                if (stackTrace.startsWith("Caused by")) {
                    causeCut = stackTrace.substring(9).indexOf("Caused by");
                    if (causeCut > 0) {
                        causeCut += 9;
                    }
                } else {
                    causeCut = stackTrace.indexOf("Caused by");
                }
                if (causeCut > -1) {
                    fragments.add(stackTrace.substring(0, causeCut));
                    stackTrace = stackTrace.substring(causeCut);
                    continue;
                }
                fragments.add(stackTrace);
                stackTrace = "";
            }
        } else {
            fragments.add(stackTrace);
        }
        for (String consideredFragment : fragments) {
            boolean appended = false;
            for (int i = 0; i < boundaries.length; ++i) {
                int cut = consideredFragment.indexOf(boundaries[i]);
                if (cut <= 0) continue;
                trimmedTrace.append(consideredFragment.substring(0, cut).trim());
                trimmedTrace.append("\n");
                appended = true;
                break;
            }
            if (appended) continue;
            trimmedTrace.append(consideredFragment.trim());
            trimmedTrace.append("\n");
        }
        return trimmedTrace.toString();
    }

    public static void genericHandler(ErrorID eid, String parm, Throwable ex) throws PortalException {
        if (ex instanceof PortalException) {
            if (((PortalException)ex).isLogPending()) {
                ExceptionHelper.traceToLog(eid, parm, ex);
            }
            throw (PortalException)ex;
        }
        ExceptionHelper.traceToLog(eid, parm, ex);
        PortalException nex = new PortalException(eid, ex);
        nex.setLogPending(false);
        ProblemsTable.store(nex);
        throw nex;
    }

    public static void genericHandler(ErrorID eid, Throwable ex) throws PortalException {
        ExceptionHelper.genericHandler(eid, null, ex);
    }

    public static void signal(ErrorID eid, String parm, boolean tracenow) throws PortalException {
        PortalException nex = new PortalException(eid);
        nex.setParameter(parm);
        ExceptionHelper.signal(nex, tracenow);
    }

    public static void signal(ErrorID eid, String parm) throws PortalException {
        ExceptionHelper.signal(eid, parm, true);
    }

    private static void signal(PortalException nex, boolean tracenow) throws PortalException {
        if (tracenow) {
            ExceptionHelper.traceToLog(nex.getErrorID(), nex.getParameter(), nex);
            ProblemsTable.store(nex);
        }
        throw nex;
    }

    public static void signal(ErrorID eid) throws PortalException {
        ExceptionHelper.signal(eid, null, true);
    }

    private static void traceToLog(ErrorID eid, String parm, Throwable ex) {
        if (ex != null && ex instanceof PortalException) {
            if (!((PortalException)ex).isLogPending()) {
                return;
            }
            ((PortalException)ex).setLogPending(false);
        }
        String logmsg = ExceptionHelper.errorInfo(eid, parm, ex);
        log.error((Object)logmsg);
    }

    public static String errorInfo(ErrorID eid, String parm, Throwable ex) {
        StringBuffer errorinfobuffer = new StringBuffer(1000);
        if (eid != Errors.legacy) {
            errorinfobuffer.append(eid.getMessage());
        } else {
            errorinfobuffer.append(ex.getMessage());
        }
        if (parm != null) {
            errorinfobuffer.append("\n    [specific data: ");
            errorinfobuffer.append(parm);
            errorinfobuffer.append("] ");
        }
        errorinfobuffer.append("\n");
        if (ex != null) {
            errorinfobuffer.append(ExceptionHelper.shortStackTrace(ex));
        }
        return errorinfobuffer.toString();
    }

    public static void genericTopHandler(ErrorID eid, String parm, Throwable t) {
        if (t instanceof PortalException && !((PortalException)t).isLogPending()) {
            return;
        }
        ExceptionHelper.traceToLog(eid, parm, t);
        if (t instanceof PortalException) {
            return;
        }
        PortalException nex = null;
        nex = new PortalException(eid, t);
        ProblemsTable.store(nex);
    }

    public static void genericTopHandler(ErrorID eid, Throwable ex) {
        ExceptionHelper.genericTopHandler(eid, null, ex);
    }

    public static void generateErrorPage(HttpServletResponse resp, Exception e) {
        resp.setContentType("text/html");
        resp.setStatus(500);
        try {
            PrintWriter out = resp.getWriter();
            out.println("<h1>uPortal Error</h1>");
            out.println("<p>Sorry, but uPortal encountered an error that is preventing it from rendering. The error must be corrected by system administrators. Try again later.</p>");
            out.println("<!--");
            ErrorID eid = Errors.bug;
            String parm = "";
            if (e instanceof PortalException) {
                PortalException pe = (PortalException)e;
                if (pe.errorID != null) {
                    eid = pe.errorID;
                }
                if (pe.parameter != null) {
                    parm = pe.parameter;
                }
            }
            out.println(ExceptionHelper.errorInfo(eid, parm, e));
            out.println("-->");
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

