/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.portlet.url.RequestType;

@Deprecated
public class ChannelRuntimeData
extends Hashtable<String, Object>
implements Cloneable {
    private static final Log log = LogFactory.getLog(ChannelRuntimeData.class);
    private BrowserInfo binfo = null;
    private Locale[] locales = null;
    private UPFileSpec channelUPFile;
    private String baseActionURL = null;
    private String httpRequestMethod = null;
    private String remoteAddress = null;
    private String keywords = null;
    private RequestType requestType = RequestType.RENDER;
    private boolean renderingAsRoot = false;
    private boolean targeted = false;
    private static final String TRADITIONAL_MEDIA_BASE = "media/";
    public static final String CAR_BASE = "/CAR_BASE";
    public static final String WEB_APP_BASE = null;

    public ChannelRuntimeData() {
        this.channelUPFile = new UPFileSpec();
    }

    @Override
    public Object clone() {
        ChannelRuntimeData crd = (ChannelRuntimeData)super.clone();
        crd.binfo = this.binfo;
        crd.locales = this.locales;
        crd.channelUPFile = this.channelUPFile;
        crd.baseActionURL = this.baseActionURL;
        crd.httpRequestMethod = this.httpRequestMethod;
        crd.keywords = this.keywords;
        crd.requestType = this.requestType;
        crd.renderingAsRoot = this.renderingAsRoot;
        crd.targeted = this.targeted;
        crd.putAll(this);
        return crd;
    }

    public void setUPFile(UPFileSpec upfs) {
        this.channelUPFile = upfs;
    }

    public UPFileSpec getUPFile() {
        return this.channelUPFile;
    }

    public void setHttpRequestMethod(String method) {
        this.httpRequestMethod = method;
    }

    public String getHttpRequestMethod() {
        return this.httpRequestMethod;
    }

    public void setBaseActionURL(String baseActionURL) {
        this.baseActionURL = baseActionURL;
    }

    public void setRenderingAsRoot(boolean rar) {
        this.renderingAsRoot = rar;
    }

    public void setTargeted(boolean targeted) {
        this.targeted = targeted;
    }

    public void setBrowserInfo(BrowserInfo bi) {
        this.binfo = bi;
    }

    public BrowserInfo getBrowserInfo() {
        return this.binfo;
    }

    public void setLocales(Locale[] locales) {
        this.locales = locales;
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public void setParameters(Map<String, Object> params) {
        this.putAll(params);
    }

    public void setParametersSingleValued(Map<String, Object> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (!(value instanceof String)) continue;
                this.setParameter(key, (String)value);
            }
        }
    }

    public String[] setParameterValues(String pName, String[] values) {
        return super.put(pName, values);
    }

    public void setParameter(String pName, String value) {
        String[] valueArray = new String[]{value};
        super.put(pName, valueArray);
    }

    public String getBaseActionURL() {
        if (this.baseActionURL != null) {
            return this.baseActionURL;
        }
        String url = null;
        try {
            url = this.channelUPFile.getUPFile();
        }
        catch (PortalException e) {
            log.error((Object)"Unable to construct a base action URL!", (Throwable)e);
        }
        return url;
    }

    public String getBaseActionURL(boolean idempotent) {
        return this.getBaseActionURL();
    }

    public String getFnameActionURL(String fname) {
        String url = null;
        try {
            UPFileSpec upfs = new UPFileSpec(this.channelUPFile);
            url = upfs.getUPFile();
            url = url + "?" + "uP_fname" + "=" + fname;
        }
        catch (Exception e) {
            log.error((Object)"Unable to construct a fname action URL!", (Throwable)e);
        }
        return url;
    }

    public String getBaseWorkerURL(String worker) {
        String url = null;
        try {
            UPFileSpec upfs = new UPFileSpec(this.channelUPFile);
            upfs.setMethod(1);
            upfs.setMethodNodeId(worker);
            url = upfs.getUPFile();
        }
        catch (Exception e) {
            log.error((Object)("unable to construct a worker action URL for a worker '" + worker + "'."), (Throwable)e);
        }
        return url;
    }

    public String getBaseMediaURL(Object aChannelObject) throws PortalException {
        return this.getBaseMediaURL(aChannelObject.getClass());
    }

    public String getBaseMediaURL(Class aChannelClass) throws PortalException {
        String mediaBase = null;
        mediaBase = aChannelClass == null ? TRADITIONAL_MEDIA_BASE : (aChannelClass == CarResources.class ? this.createBaseCarMediaURL() : (aChannelClass.getClassLoader() == CarResources.getInstance().getClassLoader() ? this.createBaseCarMediaURL() : TRADITIONAL_MEDIA_BASE));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning media base [" + mediaBase + "] for class [" + aChannelClass + "]"));
        }
        return mediaBase;
    }

    public String getBaseMediaURL(String resourcePath) throws PortalException {
        if (resourcePath == null || resourcePath.equals(WEB_APP_BASE)) {
            return TRADITIONAL_MEDIA_BASE;
        }
        if (resourcePath.equals(CAR_BASE)) {
            return this.createBaseCarMediaURL();
        }
        if (CarResources.getInstance().containsResource(resourcePath)) {
            return this.createBaseCarMediaURL();
        }
        return TRADITIONAL_MEDIA_BASE;
    }

    private String createBaseCarMediaURL() throws PortalException {
        String url = this.getBaseWorkerURL("carRsrc", true);
        return url.concat("?carRsrc=");
    }

    public String getBaseWorkerURL(String worker, boolean idempotent) throws PortalException {
        return this.getBaseWorkerURL(worker);
    }

    public boolean isRenderingAsRoot() {
        return this.renderingAsRoot;
    }

    public boolean isTargeted() {
        return this.targeted;
    }

    public String getParameter(String pName) {
        String[] value_array = this.getParameterValues(pName);
        if (value_array != null && value_array.length > 0) {
            return value_array[0];
        }
        return null;
    }

    public Object getObjectParameter(String pName) {
        Object[] value_array = this.getObjectParameterValues(pName);
        if (value_array != null && value_array.length > 0) {
            return value_array[0];
        }
        return null;
    }

    public String[] getParameterValues(String pName) {
        Object[] pars = (Object[])super.get(pName);
        if (pars instanceof String[]) {
            return (String[])pars;
        }
        return null;
    }

    public Object[] getObjectParameterValues(String pName) {
        return (Object[])super.get(pName);
    }

    public Enumeration getParameterNames() {
        return super.keys();
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(this.size());
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getParameter(name);
            params.put(name, value);
        }
        return params;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String string) {
        this.remoteAddress = string;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChannelRuntimeData: map=[").append(super.toString()).append("]");
        sb.append(" browserInfo = [").append(this.binfo).append("] ");
        sb.append(" locales = [").append(this.locales).append("] ");
        sb.append(" channelUPFile = [").append(this.channelUPFile).append("] ");
        sb.append(" baseActionURL = [").append(this.baseActionURL).append("] ");
        sb.append(" httpRequestMethod = [").append(this.httpRequestMethod).append("] ");
        sb.append(" remoteAddress = [").append(this.remoteAddress).append("] ");
        sb.append(" keywords = [").append(this.keywords).append("] ");
        sb.append(" requestType = [").append((Object)this.requestType).append("] ");
        sb.append(" renderingAsRoot = [").append(this.renderingAsRoot).append("] ");
        sb.append(" targeted = [").append(this.targeted).append("]");
        return sb.toString();
    }
}

