/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.events.EventPublisherLocator;
import org.jasig.portal.events.support.RemovedChannelDefinitionPortalEvent;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.SmartCache;
import org.springframework.context.ApplicationEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@Deprecated
public class ChannelRegistryManager {
    private static final Log log = LogFactory.getLog(ChannelRegistryManager.class);
    protected static final IChannelRegistryStore crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
    private static final int DEFAULT_REGISTRY_CACHE_TIMEOUT = 900;
    private static final int DEFAULT_CHAN_TYPES_CACHE_TIMEOUT = 900;
    private static final int DEFAULT_CPD_CACHE_TIMEOUT = 900;
    private static final boolean DEFAULT_LOCALE_AWARE = false;
    protected static final int registryCacheTimeout = PropertiesManager.getPropertyAsInt("org.jasig.portal.ChannelRegistryManager.channel_registry_cache_timeout", 900);
    protected static final int chanTypesCacheTimeout = PropertiesManager.getPropertyAsInt("org.jasig.portal.ChannelRegistryManager.channel_types_cache_timeout", 900);
    protected static final int cpdCacheTimeout = PropertiesManager.getPropertyAsInt("org.jasig.portal.ChannelRegistryManager.cpd_cache_timeout", 900);
    protected static final boolean localeAware = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.i18n.LocaleManager.locale_aware", false);
    protected static final SmartCache channelRegistryCache = new SmartCache(registryCacheTimeout);
    protected static final SmartCache channelTypesCache = new SmartCache(chanTypesCacheTimeout);
    protected static final SmartCache cpdCache = new SmartCache(cpdCacheTimeout);
    private static final String CHANNEL_REGISTRY_CACHE_KEY = "channelRegistryCacheKey";
    private static final String CHANNEL_TYPES_CACHE_KEY = "channelTypesCacheKey";
    private static final String CPD_CACHE_KEY = "cpdCacheKey";
    private static final String FRAMEWORK_OWNER = "UP_FRAMEWORK";
    private static final String SUBSCRIBER_ACTIVITY = "SUBSCRIBE";
    private static final String GRANT_PERMISSION_TYPE = "GRANT";

    public static Document getChannelRegistry() throws PortalException {
        Document channelRegistry = (Document)channelRegistryCache.get(CHANNEL_REGISTRY_CACHE_KEY);
        if (channelRegistry == null) {
            try {
                channelRegistry = ChannelRegistryManager.getChannelRegistryXML();
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
            if (channelRegistry != null) {
                channelRegistryCache.put(CHANNEL_REGISTRY_CACHE_KEY, channelRegistry);
                log.info((Object)"Caching channel registry.");
            } else {
                throw new PortalException("unable to get registry (null)");
            }
        }
        return (Document)channelRegistry.cloneNode(true);
    }

    public static Document getChannelRegistry(IPerson person) throws PortalException {
        Document channelRegistry = ChannelRegistryManager.getChannelRegistry();
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        NodeList nl = channelRegistry.getElementsByTagName("channel");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            Element channel = (Element)nl.item(i);
            String channelPublishId = channel.getAttribute("chanID");
            String string = channelPublishId = channelPublishId.startsWith("chan") ? channelPublishId.substring(4) : channelPublishId;
            if (ap.canSubscribe(Integer.parseInt(channelPublishId))) continue;
            channel.getParentNode().removeChild(channel);
        }
        return channelRegistry;
    }

    public static Document getManageableChannelRegistry(IPerson person) throws PortalException {
        Document channelRegistry = ChannelRegistryManager.getChannelRegistry();
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        NodeList nl = channelRegistry.getElementsByTagName("channel");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            Element channel = (Element)nl.item(i);
            String channelPublishId = channel.getAttribute("chanID");
            String string = channelPublishId = channelPublishId.startsWith("chan") ? channelPublishId.substring(4) : channelPublishId;
            if (ap.canManage(Integer.parseInt(channelPublishId))) continue;
            channel.getParentNode().removeChild(channel);
        }
        return channelRegistry;
    }

    public static Document getChannelRegistryXML() throws Exception {
        Document doc = DocumentFactory.getNewDocument();
        Element registry = doc.createElement("registry");
        doc.appendChild(registry);
        IEntityGroup channelCategoriesGroup = GroupService.getDistinguishedGroup(GroupService.CHANNEL_CATEGORIES);
        ChannelRegistryManager.processGroupsRecursively(channelCategoriesGroup, doc, registry);
        return doc;
    }

    private static void processGroupsRecursively(IEntityGroup group, Document owner, Element parentGroup) throws Exception {
        Date now = new Date();
        Iterator iter = group.getMembers();
        while (iter.hasNext()) {
            Date approvalDate;
            IChannelDefinition channelDef;
            IGroupMember member = (IGroupMember)iter.next();
            if (member.isGroup()) {
                IEntityGroup memberGroup = (IEntityGroup)member;
                String key = memberGroup.getKey();
                String name = memberGroup.getName();
                String description = memberGroup.getDescription();
                Element categoryE = owner.createElement("category");
                categoryE.setAttribute("ID", "cat" + key);
                categoryE.setIdAttribute("ID", true);
                categoryE.setAttribute("name", name);
                categoryE.setAttribute("description", description);
                parentGroup.appendChild(categoryE);
                ChannelRegistryManager.processGroupsRecursively(memberGroup, owner, categoryE);
                continue;
            }
            IEntity channelDefMember = (IEntity)member;
            int channelPublishId = CommonUtils.parseInt(channelDefMember.getKey());
            if (channelPublishId <= 0 || (channelDef = crs.getChannelDefinition(channelPublishId)) == null || (approvalDate = channelDef.getApprovalDate()) == null || !approvalDate.before(now)) continue;
            Element channelDefE = channelDef.getDocument(owner, "chan" + channelPublishId);
            if ((channelDefE = (Element)owner.importNode(channelDefE, true)).getAttribute("ID") != null) {
                channelDefE.setIdAttribute("ID", true);
            }
            parentGroup.appendChild(channelDefE);
        }
    }

    public static Element getChannel(String channelPublishId) throws PortalException {
        Document channelRegistry = ChannelRegistryManager.getChannelRegistry();
        Element channelE = null;
        try {
            String expression = "(//channel[@ID = '" + channelPublishId + "'])[1]";
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            channelE = (Element)xpath.evaluate(expression, channelRegistry, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new GeneralRenderingException("Not able to find channel " + channelPublishId + " within channel registry.", (Throwable)e);
        }
        return channelE;
    }

    public static Element getChannelXML(String subscribeId, IChannelDefinition channelDef) {
        Document doc = DocumentFactory.getNewDocument();
        Element channelE = doc.createElement("channel");
        channelE.setAttribute("ID", subscribeId);
        channelE.setAttribute("chanID", String.valueOf(channelDef.getId()));
        channelE.setAttribute("timeout", String.valueOf(channelDef.getTimeout()));
        if (localeAware) {
            String locale = channelDef.getLocale();
            channelE.setAttribute("name", channelDef.getName(locale));
            channelE.setAttribute("title", channelDef.getTitle(locale));
            channelE.setAttribute("locale", locale);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ChannelRegistryManager::getChannelXML: locale=" + locale));
            }
        } else {
            channelE.setAttribute("name", channelDef.getName());
            channelE.setAttribute("title", channelDef.getTitle());
        }
        channelE.setAttribute("fname", channelDef.getFName());
        channelE.setAttribute("class", channelDef.getJavaClass());
        channelE.setAttribute("typeID", String.valueOf(channelDef.getTypeId()));
        channelE.setAttribute("editable", channelDef.isEditable() ? "true" : "false");
        channelE.setAttribute("hasHelp", channelDef.hasHelp() ? "true" : "false");
        channelE.setAttribute("hasAbout", channelDef.hasAbout() ? "true" : "false");
        channelE.setAttribute("secure", channelDef.isSecure() ? "true" : "false");
        channelE.setAttribute("isPortlet", channelDef.isPortlet() ? "true" : "false");
        Set<IChannelParameter> parameters = channelDef.getParameters();
        for (IChannelParameter cp : parameters) {
            Element parameterE = doc.createElement("parameter");
            parameterE.setAttribute("name", cp.getName());
            parameterE.setAttribute("value", cp.getValue());
            if (cp.getOverride()) {
                parameterE.setAttribute("override", "yes");
            }
            channelE.appendChild(parameterE);
        }
        return channelE;
    }

    public static Document getChannelTypesXML() throws Exception {
        Document doc = DocumentFactory.getNewDocument();
        Element channelTypesE = doc.createElement("channelTypes");
        List<IChannelType> channelTypes = crs.getChannelTypes();
        for (IChannelType channelType : channelTypes) {
            int channelTypeId = channelType.getId();
            String javaClass = channelType.getJavaClass();
            String name = channelType.getName();
            String descr = channelType.getDescription();
            String cpdUri = channelType.getCpdUri();
            Element channelTypeE = doc.createElement("channelType");
            channelTypeE.setAttribute("ID", String.valueOf(channelTypeId));
            Element classE = doc.createElement("class");
            classE.appendChild(doc.createTextNode(javaClass));
            channelTypeE.appendChild(classE);
            Element nameE = doc.createElement("name");
            nameE.appendChild(doc.createTextNode(name));
            channelTypeE.appendChild(nameE);
            Element descriptionE = doc.createElement("description");
            descriptionE.appendChild(doc.createTextNode(descr));
            channelTypeE.appendChild(descriptionE);
            Element cpdUriE = doc.createElement("cpd-uri");
            cpdUriE.appendChild(doc.createTextNode(cpdUri));
            channelTypeE.appendChild(cpdUriE);
            channelTypesE.appendChild(channelTypeE);
        }
        doc.appendChild(channelTypesE);
        return doc;
    }

    public static NodeList getCategories(String channelPublishId) throws PortalException {
        Document channelRegistry = (Document)channelRegistryCache.get(CHANNEL_REGISTRY_CACHE_KEY);
        NodeList categories = null;
        try {
            String expression = "//category[channel/@ID = '" + channelPublishId + "']";
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            categories = (NodeList)xpath.evaluate(expression, channelRegistry, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new GeneralRenderingException("Not able to find channel " + channelPublishId + " within channel registry.", (Throwable)e);
        }
        return categories;
    }

    public static void removeChannel(String channelID, IPerson person) throws Exception {
        channelRegistryCache.remove(CHANNEL_REGISTRY_CACHE_KEY);
        String sChannelPublishId = channelID.startsWith("chan") ? channelID.substring(4) : channelID;
        int channelPublishId = Integer.parseInt(sChannelPublishId);
        IChannelDefinition channelDef = crs.getChannelDefinition(channelPublishId);
        crs.disapproveChannelDefinition(channelDef);
        EventPublisherLocator.getApplicationEventPublisher().publishEvent((ApplicationEvent)new RemovedChannelDefinitionPortalEvent((Object)channelDef, person, channelDef));
    }

    public static Document getChannelTypes() throws PortalException {
        Document channelTypes = (Document)channelTypesCache.get(CHANNEL_TYPES_CACHE_KEY);
        if (channelTypes == null) {
            try {
                channelTypes = ChannelRegistryManager.getChannelTypesXML();
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
            if (channelTypes != null) {
                channelTypesCache.put(CHANNEL_TYPES_CACHE_KEY, channelTypes);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Caching channel types.");
                }
            } else {
                throw new PortalException("unable to get channelTypes (null)");
            }
        }
        return (Document)channelTypes.cloneNode(true);
    }

    public static Document getCPD(String chanTypeID) throws PortalException {
        if (chanTypeID == null || chanTypeID.equals("-1")) {
            return null;
        }
        Document cpd = (Document)cpdCache.get(CPD_CACHE_KEY + chanTypeID);
        if (cpd == null) {
            Element channelTypes = ChannelRegistryManager.getChannelTypes().getDocumentElement();
            Node chanType = null;
            for (Node n = channelTypes.getFirstChild(); !(n == null || n.getNodeType() == 1 && n.getNodeName().equals("channelType") && chanTypeID.equals((chanType = (Element)n).getAttribute("ID"))); n = n.getNextSibling()) {
            }
            String cpdUri = null;
            for (Node n = chanType.getLastChild(); n != null; n = n.getPreviousSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals("cpd-uri")) continue;
                for (Node m = n.getFirstChild(); m != null; m = m.getNextSibling()) {
                    if (!(m instanceof Text)) continue;
                    cpdUri = m.getNodeValue();
                }
                break;
            }
            if (cpdUri != null) {
                try {
                    cpd = ResourceLoader.getResourceAsDocument(ChannelRegistryManager.class, cpdUri, true);
                }
                catch (IOException ioe) {
                    throw new ResourceMissingException(cpdUri, "Channel publishing document", ioe);
                }
                catch (SAXException se) {
                    throw new PortalException("Unable to parse CPD file: " + cpdUri, (Throwable)se);
                }
                catch (ParserConfigurationException pce) {
                    throw new PortalException("Unable to parse CPD file: " + cpdUri, (Throwable)pce);
                }
            }
            if (cpd != null) {
                cpdCache.put(CPD_CACHE_KEY + chanTypeID, cpd);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Caching CPD for channel type " + chanTypeID));
                }
            } else {
                throw new PortalException("unable to get Channel Publishing Document (null)");
            }
        }
        return (Document)cpd.cloneNode(true);
    }

    public static void expireCache() {
        channelRegistryCache.remove(CHANNEL_REGISTRY_CACHE_KEY);
    }
}

