/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class BrowserInfo {
    protected Cookie[] cookies;
    protected Map headers;

    public BrowserInfo() {
    }

    public BrowserInfo(Cookie[] cookies, Map headers) {
        this.cookies = cookies;
        this.headers = headers;
    }

    public BrowserInfo(HttpServletRequest req) {
        this.headers = new HashMap();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String hName = (String)e.nextElement();
            this.headers.put(hName.toLowerCase(), req.getHeader(hName));
        }
        this.cookies = req.getCookies();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public String getHeader(String hName) {
        return (String)this.headers.get(hName.toLowerCase());
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public String getUserAgent() {
        String ua = (String)this.headers.get("user-agent");
        if (ua == null || ua.equals("")) {
            ua = "null";
        }
        return ua;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        for (String header : this.headers.keySet()) {
            sb.append("[").append(header).append("]");
            sb.append("=");
            sb.append("[").append(this.headers.get(header)).append("] ");
        }
        return sb.toString();
    }
}

