/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class BindModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        try {
            String username = credential.getUsername();
            String password = this.getPasswordEncoder().encode(credential.getPassword());
            Connection c = this.getDataSource().getConnection(username, password);
            DataSourceUtils.releaseConnection((Connection)c, (DataSource)this.getDataSource());
            return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
        }
        catch (SQLException e) {
            throw new FailedLoginException(e.getMessage());
        }
        catch (Exception e) {
            throw new PreventedException("Unexpected SQL connection error", (Throwable)e);
        }
    }
}

