/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoSearchLoadingIndexedTypeContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoProjectionHitMapper<R, E>
implements ProjectionHitMapper<R, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName;
    private final DocumentReferenceConverter<R> documentReferenceConverter;
    private final BridgeSessionContext sessionContext;
    private final PojoLoadingPlan<E> loadingPlan;

    public PojoProjectionHitMapper(Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName, DocumentReferenceConverter<R> documentReferenceConverter, BridgeSessionContext sessionContext, PojoLoadingPlan<E> loadingPlan) {
        this.targetTypesByEntityName = targetTypesByEntityName;
        this.documentReferenceConverter = documentReferenceConverter;
        this.sessionContext = sessionContext;
        this.loadingPlan = loadingPlan;
    }

    public Object planLoading(DocumentReference reference) {
        PojoSearchLoadingIndexedTypeContext<E> type = this.targetTypesByEntityName.get(reference.typeName());
        if (type == null) {
            throw log.unexpectedEntityNameForEntityLoading(reference.typeName(), this.targetTypesByEntityName.keySet());
        }
        Object identifier = type.identifierMapping().fromDocumentIdentifier(reference.id(), this.sessionContext);
        int ordinal = this.loadingPlan.planLoading(type, identifier);
        if (this.targetTypesByEntityName.size() == 1) {
            return ordinal;
        }
        return new TypeAndOrdinal<E>(type, ordinal);
    }

    public LoadingResult<R, E> loadBlocking(Deadline deadline) {
        this.loadingPlan.loadBlocking(deadline);
        if (this.targetTypesByEntityName.size() == 1) {
            return new SingleTypeLoadingResult(this.documentReferenceConverter, this.targetTypesByEntityName.values().iterator().next(), this.loadingPlan);
        }
        return new MultiTypeLoadingResult(this.documentReferenceConverter, this.loadingPlan);
    }

    private static final class TypeAndOrdinal<E> {
        private final PojoSearchLoadingIndexedTypeContext<? extends E> type;
        private final int ordinal;

        public TypeAndOrdinal(PojoSearchLoadingIndexedTypeContext<? extends E> type, int ordinal) {
            this.type = type;
            this.ordinal = ordinal;
        }
    }

    private static class MultiTypeLoadingResult<R, E>
    implements LoadingResult<R, E> {
        private final DocumentReferenceConverter<R> documentReferenceConverter;
        private final PojoLoadingPlan<E> loadingPlan;

        private MultiTypeLoadingResult(DocumentReferenceConverter<R> documentReferenceConverter, PojoLoadingPlan<E> loadingPlan) {
            this.documentReferenceConverter = documentReferenceConverter;
            this.loadingPlan = loadingPlan;
        }

        public E get(Object key) {
            TypeAndOrdinal typeAndOrdinal = (TypeAndOrdinal)key;
            return (E)this.loadingPlan.retrieve(typeAndOrdinal.type, typeAndOrdinal.ordinal);
        }

        public R convertReference(DocumentReference reference) {
            return (R)this.documentReferenceConverter.fromDocumentReference(reference);
        }
    }

    private static class SingleTypeLoadingResult<R, E>
    implements LoadingResult<R, E> {
        private final DocumentReferenceConverter<R> documentReferenceConverter;
        private final PojoSearchLoadingIndexedTypeContext<? extends E> type;
        private final PojoLoadingPlan<E> loadingPlan;

        private SingleTypeLoadingResult(DocumentReferenceConverter<R> documentReferenceConverter, PojoSearchLoadingIndexedTypeContext<? extends E> type, PojoLoadingPlan<E> loadingPlan) {
            this.documentReferenceConverter = documentReferenceConverter;
            this.type = type;
            this.loadingPlan = loadingPlan;
        }

        public E get(Object key) {
            return this.loadingPlan.retrieve(this.type, (Integer)key);
        }

        public R convertReference(DocumentReference reference) {
            return (R)this.documentReferenceConverter.fromDocumentReference(reference);
        }
    }
}

