/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.model.spi.AbstractPojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class SyntheticPojoGenericTypeModel<T>
extends AbstractPojoGenericTypeModel<T> {
    private final PojoGenericTypeModel<?> arrayElementType;
    private final List<PojoGenericTypeModel<?>> genericTypeArguments;

    public static <T> PojoGenericTypeModel<T[]> array(PojoRawTypeModel<? super T[]> rawTypeModel, PojoGenericTypeModel<T> elementType) {
        return new SyntheticPojoGenericTypeModel<T[]>(rawTypeModel, elementType, Collections.emptyList());
    }

    public static <T> PojoGenericTypeModel<T> genericType(PojoRawTypeModel<? super T> rawTypeModel, PojoGenericTypeModel<?> firstTypeArgument, PojoGenericTypeModel<?> ... otherTypeArguments) {
        return new SyntheticPojoGenericTypeModel<T>(rawTypeModel, null, CollectionHelper.asList(firstTypeArgument, (Object[])otherTypeArguments));
    }

    public static <T> PojoGenericTypeModel<T> opaqueType(PojoRawTypeModel<T> rawTypeModel) {
        return new SyntheticPojoGenericTypeModel<T>(rawTypeModel, null, Collections.emptyList());
    }

    private SyntheticPojoGenericTypeModel(PojoRawTypeModel<? super T> rawTypeModel, PojoGenericTypeModel<?> arrayElementType, List<PojoGenericTypeModel<?>> genericTypeArguments) {
        super(rawTypeModel);
        this.arrayElementType = arrayElementType;
        this.genericTypeArguments = genericTypeArguments;
    }

    @Override
    public String name() {
        if (this.arrayElementType != null) {
            return this.arrayElementType.name() + "[]";
        }
        if (this.genericTypeArguments.isEmpty()) {
            return this.rawType().name();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.rawType().name());
        builder.append('<');
        boolean first = true;
        for (PojoGenericTypeModel<?> genericTypeArgument : this.genericTypeArguments) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(genericTypeArgument.name());
        }
        builder.append('>');
        return builder.toString();
    }

    @Override
    public <U> Optional<PojoTypeModel<? extends U>> castTo(Class<U> target) {
        return Optional.empty();
    }

    @Override
    public Optional<PojoGenericTypeModel<?>> arrayElementType() {
        return Optional.ofNullable(this.arrayElementType);
    }

    @Override
    public Optional<? extends PojoGenericTypeModel<?>> typeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        if (this.genericTypeArguments.isEmpty()) {
            return Optional.empty();
        }
        if (rawSuperType.isAssignableFrom(this.rawType().typeIdentifier().javaClass())) {
            return Optional.of(this.genericTypeArguments.get(typeParameterIndex));
        }
        return Optional.empty();
    }
}

