/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.spi;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeFamilyInformation;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcTypeBaseline;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class JdbcTypeRegistry
implements JdbcTypeBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JdbcTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<Integer, JdbcType> descriptorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, JdbcTypeConstructor> descriptorConstructorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AggregateJdbcType> aggregateDescriptorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<TypeConstructedJdbcTypeKey, JdbcType> typeConstructorDescriptorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SqlTypedJdbcType> sqlTypedDescriptorMap = new ConcurrentHashMap();

    public JdbcTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JdbcTypeBaseline.prime(this);
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void addDescriptor(JdbcType jdbcType) {
        JdbcType previous = this.descriptorMap.put(jdbcType.getDefaultSqlTypeCode(), jdbcType);
        if (previous != null && previous != jdbcType) {
            log.debugf("addDescriptor(%s) replaced previous registration(%s)", (Object)jdbcType, (Object)previous);
        }
    }

    @Override
    public void addDescriptor(int typeCode, JdbcType jdbcType) {
        JdbcType previous = this.descriptorMap.put(typeCode, jdbcType);
        if (previous != null && previous != jdbcType) {
            log.debugf("addDescriptor(%d, %s) replaced previous registration(%s)", typeCode, (Object)jdbcType, (Object)previous);
        }
    }

    public void addDescriptorIfAbsent(JdbcType jdbcType) {
        this.descriptorMap.putIfAbsent(jdbcType.getDefaultSqlTypeCode(), jdbcType);
    }

    public void addDescriptorIfAbsent(int typeCode, JdbcType jdbcType) {
        this.descriptorMap.putIfAbsent(typeCode, jdbcType);
    }

    public JdbcType findDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.get(jdbcTypeCode);
    }

    public JdbcType getDescriptor(int jdbcTypeCode) {
        JdbcTypeFamilyInformation.Family family;
        JdbcType descriptor = this.descriptorMap.get(jdbcTypeCode);
        if (descriptor != null) {
            return descriptor;
        }
        if (JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode)) {
            log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", jdbcTypeCode);
        }
        if ((family = JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode)) != null) {
            for (int potentialAlternateTypeCode : family.getTypeCodes()) {
                if (potentialAlternateTypeCode == jdbcTypeCode) continue;
                JdbcType potentialAlternateDescriptor = this.descriptorMap.get(potentialAlternateTypeCode);
                if (potentialAlternateDescriptor != null) {
                    return potentialAlternateDescriptor;
                }
                if (!JdbcTypeNameMapper.isStandardTypeCode(potentialAlternateTypeCode)) continue;
                log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", potentialAlternateTypeCode);
            }
        }
        ObjectJdbcType fallBackDescriptor = new ObjectJdbcType(jdbcTypeCode);
        this.addDescriptor(fallBackDescriptor);
        return fallBackDescriptor;
    }

    public AggregateJdbcType resolveAggregateDescriptor(int jdbcTypeCode, String typeName, EmbeddableMappingType embeddableMappingType, RuntimeModelCreationContext creationContext) {
        JdbcType descriptor;
        String registrationKey;
        if (typeName != null) {
            registrationKey = typeName.toLowerCase(Locale.ROOT);
            AggregateJdbcType aggregateJdbcType = this.aggregateDescriptorMap.get(registrationKey);
            if (aggregateJdbcType != null) {
                if (aggregateJdbcType.getEmbeddableMappingType() != embeddableMappingType) {
                    return aggregateJdbcType.resolveAggregateJdbcType(embeddableMappingType, typeName, creationContext);
                }
                return aggregateJdbcType;
            }
        } else {
            registrationKey = null;
        }
        if (!((descriptor = this.getDescriptor(jdbcTypeCode)) instanceof AggregateJdbcType)) {
            throw new IllegalArgumentException(String.format("Tried to resolve the JdbcType [%s] as AggregateJdbcType but it does not implement that interface!", descriptor.getClass().getName()));
        }
        AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)descriptor;
        AggregateJdbcType resolvedJdbcType = aggregateJdbcType.resolveAggregateJdbcType(embeddableMappingType, typeName, creationContext);
        if (registrationKey != null) {
            this.aggregateDescriptorMap.put(registrationKey, resolvedJdbcType);
            if (resolvedJdbcType instanceof SqlTypedJdbcType) {
                SqlTypedJdbcType sqlTypedJdbcType = (SqlTypedJdbcType)((Object)resolvedJdbcType);
                this.sqlTypedDescriptorMap.put(sqlTypedJdbcType.getSqlTypeName().toLowerCase(Locale.ROOT), sqlTypedJdbcType);
            }
        }
        return resolvedJdbcType;
    }

    public AggregateJdbcType findAggregateDescriptor(String typeName) {
        return this.aggregateDescriptorMap.get(typeName.toLowerCase(Locale.ROOT));
    }

    public SqlTypedJdbcType findSqlTypedDescriptor(String sqlTypeName) {
        return this.sqlTypedDescriptorMap.get(sqlTypeName.toLowerCase(Locale.ROOT));
    }

    public JdbcType resolveTypeConstructorDescriptor(int jdbcTypeConstructorCode, BasicType<?> elementType, @Nullable ColumnTypeInformation columnTypeInformation) {
        return this.resolveTypeConstructorDescriptor(jdbcTypeConstructorCode, (Object)elementType, columnTypeInformation);
    }

    public JdbcType resolveTypeConstructorDescriptor(int jdbcTypeConstructorCode, JdbcType elementType, @Nullable ColumnTypeInformation columnTypeInformation) {
        return this.resolveTypeConstructorDescriptor(jdbcTypeConstructorCode, (Object)elementType, columnTypeInformation);
    }

    private JdbcType resolveTypeConstructorDescriptor(int jdbcTypeConstructorCode, Object elementType, @Nullable ColumnTypeInformation columnTypeInformation) {
        TypeConstructedJdbcTypeKey key = new TypeConstructedJdbcTypeKey(jdbcTypeConstructorCode, elementType, columnTypeInformation);
        JdbcType descriptor = this.typeConstructorDescriptorMap.get(key);
        if (descriptor != null) {
            return descriptor;
        }
        JdbcTypeConstructor jdbcTypeConstructor = this.getConstructor(jdbcTypeConstructorCode);
        if (jdbcTypeConstructor != null) {
            JdbcType jdbcType = elementType instanceof BasicType ? jdbcTypeConstructor.resolveType(this.typeConfiguration, this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect(), (BasicType)elementType, columnTypeInformation) : jdbcTypeConstructor.resolveType(this.typeConfiguration, this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect(), (JdbcType)elementType, columnTypeInformation);
            JdbcType existingType = this.typeConstructorDescriptorMap.putIfAbsent(key, jdbcType);
            if (existingType != null) {
                return existingType;
            }
            if (jdbcType instanceof SqlTypedJdbcType) {
                SqlTypedJdbcType sqlTypedJdbcType = (SqlTypedJdbcType)jdbcType;
                this.sqlTypedDescriptorMap.put(sqlTypedJdbcType.getSqlTypeName().toLowerCase(Locale.ROOT), sqlTypedJdbcType);
            }
            return jdbcType;
        }
        return this.getDescriptor(jdbcTypeConstructorCode);
    }

    public boolean hasRegisteredDescriptor(int jdbcTypeCode) {
        return this.descriptorMap.containsKey(jdbcTypeCode) || JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode) || JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode) != null;
    }

    public JdbcTypeConstructor getConstructor(int jdbcTypeCode) {
        return this.descriptorConstructorMap.get(jdbcTypeCode);
    }

    public void addTypeConstructor(int jdbcTypeCode, JdbcTypeConstructor jdbcTypeConstructor) {
        this.descriptorConstructorMap.put(jdbcTypeCode, jdbcTypeConstructor);
    }

    public void addTypeConstructor(JdbcTypeConstructor jdbcTypeConstructor) {
        this.addTypeConstructor(jdbcTypeConstructor.getDefaultSqlTypeCode(), jdbcTypeConstructor);
    }

    public void addTypeConstructorIfAbsent(int jdbcTypeCode, JdbcTypeConstructor jdbcTypeConstructor) {
        this.descriptorConstructorMap.putIfAbsent(jdbcTypeCode, jdbcTypeConstructor);
    }

    public void addTypeConstructorIfAbsent(JdbcTypeConstructor jdbcTypeConstructor) {
        this.addTypeConstructorIfAbsent(jdbcTypeConstructor.getDefaultSqlTypeCode(), jdbcTypeConstructor);
    }

    private static final class TypeConstructedJdbcTypeKey {
        private final int typeConstructorTypeCode;
        private final Object jdbcTypeOrBasicType;
        private final TruthValue nullable;
        private final int typeCode;
        private final @Nullable String typeName;
        private final int columnSize;
        private final int decimalDigits;

        public TypeConstructedJdbcTypeKey(int typeConstructorTypeCode, Object jdbcTypeOrBasicType, @Nullable ColumnTypeInformation columnTypeInformation) {
            this.typeConstructorTypeCode = typeConstructorTypeCode;
            this.jdbcTypeOrBasicType = jdbcTypeOrBasicType;
            if (columnTypeInformation == null) {
                this.nullable = TruthValue.UNKNOWN;
                this.typeCode = 1111;
                this.typeName = null;
                this.columnSize = 0;
                this.decimalDigits = 0;
            } else {
                this.nullable = columnTypeInformation.getNullable();
                this.typeCode = columnTypeInformation.getTypeCode();
                this.typeName = columnTypeInformation.getTypeName();
                this.columnSize = columnTypeInformation.getColumnSize();
                this.decimalDigits = columnTypeInformation.getDecimalDigits();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeConstructedJdbcTypeKey that = (TypeConstructedJdbcTypeKey)o;
            if (this.typeConstructorTypeCode != that.typeConstructorTypeCode) {
                return false;
            }
            if (this.typeCode != that.typeCode) {
                return false;
            }
            if (this.columnSize != that.columnSize) {
                return false;
            }
            if (this.decimalDigits != that.decimalDigits) {
                return false;
            }
            if (!this.jdbcTypeOrBasicType.equals(that.jdbcTypeOrBasicType)) {
                return false;
            }
            if (this.nullable != that.nullable) {
                return false;
            }
            return Objects.equals(this.typeName, that.typeName);
        }

        public int hashCode() {
            int result = this.typeConstructorTypeCode;
            result = 31 * result + this.jdbcTypeOrBasicType.hashCode();
            result = 31 * result + (this.nullable != null ? this.nullable.hashCode() : 0);
            result = 31 * result + this.typeCode;
            result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            result = 31 * result + this.columnSize;
            result = 31 * result + this.decimalDigits;
            return result;
        }
    }
}

