/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.hibernate.dialect.XmlHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class XmlJdbcType
implements AggregateJdbcType {
    public static final XmlJdbcType INSTANCE = new XmlJdbcType(null);
    private final EmbeddableMappingType embeddableMappingType;

    protected XmlJdbcType(EmbeddableMappingType embeddableMappingType) {
        this.embeddableMappingType = embeddableMappingType;
    }

    @Override
    public int getJdbcTypeCode() {
        return 2009;
    }

    public String toString() {
        return "XmlJdbcType";
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new XmlJdbcType(mappingType);
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return XmlHelper.toString(this.embeddableMappingType, domainValue, options);
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        return (Object[])XmlHelper.fromString(this.embeddableMappingType, (String)rawJdbcValue, false, options);
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        if (this.embeddableMappingType != null) {
            return XmlHelper.toString(this.embeddableMappingType, value, options);
        }
        return options.getSessionFactory().getFastSessionServices().getXmlFormatMapper().toString(value, javaType, options);
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        if (this.embeddableMappingType != null) {
            return XmlHelper.fromString(this.embeddableMappingType, string, javaType.getJavaTypeClass() != Object[].class, options);
        }
        if (javaType.getJavaType() == SQLXML.class) {
            SQLXML sqlxml = options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createSQLXML();
            sqlxml.setString(string);
            return (X)sqlxml;
        }
        return options.getSessionFactory().getFastSessionServices().getXmlFormatMapper().fromString(string, javaType, options);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new XmlValueBinder<X>(javaType, (JdbcType)this);
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getSQLXML(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getSQLXML(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getSQLXML(name), options);
            }

            private X getObject(SQLXML sqlxml, WrapperOptions options) throws SQLException {
                if (sqlxml == null) {
                    return null;
                }
                return ((XmlJdbcType)this.getJdbcType()).fromString(sqlxml.getString(), this.getJavaType(), options);
            }
        };
    }

    protected static class XmlValueBinder<X>
    extends BasicBinder<X> {
        public XmlValueBinder(JavaType<X> javaType, JdbcType jdbcType) {
            super(javaType, jdbcType);
        }

        @Override
        protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
            String xml = ((XmlJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
            SQLXML sqlxml = st.getConnection().createSQLXML();
            sqlxml.setString(xml);
            st.setSQLXML(index, sqlxml);
        }

        @Override
        protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
            String xml = ((XmlJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
            SQLXML sqlxml = st.getConnection().createSQLXML();
            sqlxml.setString(xml);
            st.setSQLXML(name, sqlxml);
        }
    }
}

