/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class XmlArrayJdbcType
extends ArrayJdbcType {
    public XmlArrayJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public int getJdbcTypeCode() {
        return 2009;
    }

    @Override
    public int getDdlTypeCode() {
        return 2009;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3019;
    }

    @Override
    public String toString() {
        return "XmlArrayJdbcType";
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        if (string == null) {
            return null;
        }
        if (javaType.getJavaType() == SQLXML.class) {
            SQLXML sqlxml = options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createSQLXML();
            sqlxml.setString(string);
            return (X)sqlxml;
        }
        return options.getSessionFactory().getFastSessionServices().getXmlFormatMapper().fromString(string, javaType, options);
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        return options.getSessionFactory().getFastSessionServices().getXmlFormatMapper().toString(value, javaType, options);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String xml = ((XmlArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                SQLXML sqlxml = st.getConnection().createSQLXML();
                sqlxml.setString(xml);
                st.setSQLXML(index, sqlxml);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String xml = ((XmlArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                SQLXML sqlxml = st.getConnection().createSQLXML();
                sqlxml.setString(xml);
                st.setSQLXML(name, sqlxml);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getSQLXML(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getSQLXML(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getSQLXML(name), options);
            }

            private X getObject(SQLXML sqlxml, WrapperOptions options) throws SQLException {
                if (sqlxml == null) {
                    return null;
                }
                return ((XmlArrayJdbcType)this.getJdbcType()).fromString(sqlxml.getString(), this.getJavaType(), options);
            }
        };
    }
}

