/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonArrayJdbcType;

public class OracleJsonArrayBlobJdbcType
extends JsonArrayJdbcType {
    public OracleJsonArrayBlobJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public int getJdbcTypeCode() {
        return 2004;
    }

    @Override
    public String toString() {
        return "JsonArrayBlobJdbcType";
    }

    @Override
    public String getCheckCondition(String columnName, JavaType<?> javaType, BasicValueConverter<?, ?> converter, Dialect dialect) {
        return columnName + " is json";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String json = OracleJsonArrayBlobJdbcType.this.toString(value, this.getJavaType(), options);
                st.setBytes(index, json.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String json = OracleJsonArrayBlobJdbcType.this.toString(value, this.getJavaType(), options);
                st.setBytes(name, json.getBytes(StandardCharsets.UTF_8));
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.fromString(rs.getBytes(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.fromString(statement.getBytes(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.fromString(statement.getBytes(name), options);
            }

            private X fromString(byte[] json, WrapperOptions options) throws SQLException {
                if (json == null) {
                    return null;
                }
                return OracleJsonArrayBlobJdbcType.this.fromString(new String(json, StandardCharsets.UTF_8), this.getJavaType(), options);
            }
        };
    }
}

