/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.ComponentArrayComparator;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;

public class ObjectArrayJavaType
extends AbstractClassJavaType<Object[]> {
    private final JavaType[] components;

    public ObjectArrayJavaType(JavaType[] components) {
        super(Object[].class, ImmutableMutabilityPlan.instance(), new ComponentArrayComparator(components));
        this.components = components;
    }

    @Override
    public String toString(Object[] value) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        this.append(sb, this.components, value, 0);
        for (int i = 1; i < this.components.length; ++i) {
            sb.append(", ");
            this.append(sb, this.components, value, i);
        }
        sb.append(')');
        return sb.toString();
    }

    private void append(StringBuilder sb, JavaType[] components, Object[] value, int i) {
        Object o = value[i];
        if (o == null) {
            sb.append("null");
        } else {
            sb.append(components[i].toString(o));
        }
    }

    @Override
    public boolean areEqual(Object[] one, Object[] another) {
        if (one == another) {
            return true;
        }
        if (one != null && another != null && one.length == another.length) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i].areEqual(one[i], another[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int extractHashCode(Object[] objects) {
        int hashCode = 1;
        for (int i = 0; i < objects.length; ++i) {
            hashCode = 31 * hashCode + this.components[i].extractHashCode(objects[i]);
        }
        return hashCode;
    }

    @Override
    public <X> X unwrap(Object[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Object[].class.isAssignableFrom(type)) {
            return (X)value;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Object[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            return objects;
        }
        throw this.unknownWrap(value.getClass());
    }
}

