/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.CoercionHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class LongJavaType
extends AbstractClassJavaType<Long>
implements PrimitiveJavaType<Long>,
VersionJavaType<Long> {
    private static final Long ZERO = 0L;
    public static final LongJavaType INSTANCE = new LongJavaType();

    public LongJavaType() {
        super(Long.class);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(Long value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Long fromString(CharSequence string) {
        return Long.valueOf(string.toString());
    }

    @Override
    public <X> X unwrap(Long value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Long.class.isAssignableFrom(type) || type == Object.class) {
            return (X)value;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)Byte.valueOf(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return (X)Float.valueOf(value.floatValue());
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return (X)BigInteger.valueOf(value);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)BigDecimal.valueOf(value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Long wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            return Long.valueOf(string);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer" -> true;
            default -> false;
        };
    }

    @Override
    public <X> Long coerce(X value, JavaType.CoercionContext coercionContext) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return CoercionHelper.toLong(byteValue);
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return CoercionHelper.toLong(shortValue);
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return CoercionHelper.toLong(integerValue);
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return CoercionHelper.toLong(doubleValue);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return CoercionHelper.toLong(floatValue);
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return CoercionHelper.toLong(bigInteger);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return CoercionHelper.toLong(bigDecimal);
        }
        if (value instanceof String) {
            String string = (String)value;
            return CoercionHelper.coerceWrappingError(() -> Long.parseLong(string));
        }
        throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce value '%s' [%s] to Long", value, value.getClass().getName()));
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Long.TYPE;
    }

    @Override
    public Class<Long[]> getArrayClass() {
        return Long[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return long[].class;
    }

    @Override
    public Long getDefaultValue() {
        return 0L;
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.getDefaultSqlPrecision(dialect, jdbcType) + 1;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 19;
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }

    @Override
    public Long next(Long current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return current + 1L;
    }

    @Override
    public Long seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return ZERO;
    }
}

